/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Flying;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class MobAiReducerModule
extends AbstractModule
implements Listener {
    private final EnumSet<EntityType> list = EnumSet.noneOf(EntityType.class);
    private final EnumSet<CreatureSpawnEvent.SpawnReason> reasons = EnumSet.noneOf(CreatureSpawnEvent.SpawnReason.class);
    private final HashSet<String> ai_list = new HashSet();
    private ScheduledTask task;
    private NMS mobAiReducer;
    private boolean ignore_models;
    private boolean animals;
    private boolean monsters;
    private boolean villagers;
    private boolean tameable;
    private boolean birds;
    private boolean others;
    private boolean list_mode;
    private boolean force_load;
    private boolean click_event;
    private int purge_interval;
    private boolean collides;
    private boolean silent;
    private boolean keep_dedicated;
    private boolean ai_list_mode;
    private boolean temptEnabled;
    private double temptRange;
    private double temptSpeed;
    private int temptCooldown;
    private boolean temptTriggerBothHands;
    private boolean temptEvent;
    private boolean temptTeleport;
    private boolean breedEnabled;
    private double breedRange;
    private boolean breedEvent;
    private boolean breedTeleport;
    private double breedSpeed;

    public MobAiReducerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.VERY_HIGH, "MobAiReducer", new String[]{"Replaces creature movement to optimize and reduce behavior.", "Addresses inefficiencies caused by default animal behavior like unnecessary random movements or constant looking around.", "MobAiReducer intervenes by disabling unnecessary PathFinders or replacing them with more efficient ones.", "Crucial in scenarios with numerous animals as even minor movements can strain server resources."}, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOGM3NTA1ZjIyNGQ1MTY0YTExN2Q4YzY5ZjAxNWY5OWVmZjQzNDQ3MWM4YTJkZjkwNzA5NmM0MjQyYzM1MjRlOCJ9fX0=");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onSpawn(CreatureSpawnEvent e) {
        if (!(this.reasons.contains(e.getSpawnReason()) && this.isEnabled((Entity)e.getEntity()) && this.canContinue(e.getEntity().getWorld()))) {
            return;
        }
        this.mobAiReducer.optimize((Entity)e.getEntity(), false);
    }

    public boolean isEnabled(Entity ent) {
        if (!this.ignore_models && HookManager.getInstance().getModel().hasModel(ent) || this.list.contains(ent.getType()) != this.list_mode) {
            return false;
        }
        if (ent instanceof Villager) {
            return this.villagers;
        }
        if (ent instanceof Tameable) {
            return this.tameable;
        }
        if (ent instanceof Flying) {
            return this.birds;
        }
        if (ent instanceof Animals) {
            return this.animals;
        }
        if (ent instanceof Monster) {
            return this.monsters;
        }
        return this.others;
    }

    @Override
    public void load() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
        Bukkit.getPluginManager().registerEvents((Listener)this.mobAiReducer, (Plugin)this.getPlugin());
        if (this.force_load) {
            this.getAllowedWorlds().forEach(w -> w.getLivingEntities().stream().filter(this::isEnabled).forEach(ent -> this.mobAiReducer.optimize((Entity)ent, true)));
        }
        this.task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), t -> this.mobAiReducer.purge(), 60L, (long)this.purge_interval, TimeUnit.SECONDS);
    }

    @Override
    public boolean loadConfig() {
        this.mobAiReducer = (NMS)ReflectionUtils.createInstance("MobAiReducer", this);
        this.ignore_models = HookManager.getInstance().noneModels() || this.getSection().getBoolean("ignore_models");
        this.animals = this.getSection().getBoolean("entities.animals");
        this.monsters = this.getSection().getBoolean("entities.monsters");
        this.villagers = this.getSection().getBoolean("entities.villagers");
        this.tameable = this.getSection().getBoolean("entities.tameable");
        this.birds = this.getSection().getBoolean("entities.birds");
        this.others = this.getSection().getBoolean("entities.others");
        this.force_load = this.getSection().getBoolean("force_load");
        this.click_event = this.getSection().getBoolean("click_event");
        this.purge_interval = this.getSection().getInt("purge_interval");
        this.list_mode = this.getSection().getBoolean("list_mode");
        ReflectionUtils.convertEnums(EntityType.class, this.list, this.getSection().getStringList("list"));
        ReflectionUtils.convertEnums(CreatureSpawnEvent.SpawnReason.class, this.reasons, this.getSection().getStringList("spawn_reasons"));
        this.collides = this.getSection().getBoolean("collides");
        this.silent = this.getSection().getBoolean("silent");
        this.keep_dedicated = this.getSection().getBoolean("pathfinder.keep_dedicated");
        this.ai_list_mode = this.getSection().getBoolean("pathfinder.list_mode");
        this.ai_list.clear();
        this.ai_list.addAll(this.getSection().getStringList("pathfinder.list"));
        this.temptEnabled = this.getSection().getBoolean("animals.tempt.enabled");
        this.temptRange = this.getSection().getDouble("animals.tempt.range");
        this.temptSpeed = this.getSection().getDouble("animals.tempt.speed");
        this.temptCooldown = this.getSection().getInt("animals.tempt.cooldown");
        this.temptTriggerBothHands = this.getSection().getBoolean("animals.tempt.trigger_two_hands");
        this.temptEvent = this.getSection().getBoolean("animals.tempt.event");
        this.temptTeleport = this.getSection().getBoolean("animals.tempt.teleport");
        this.breedEnabled = this.getSection().getBoolean("animals.breed.enabled");
        this.breedRange = this.getSection().getDouble("animals.breed.range");
        this.breedSpeed = this.getSection().getDouble("animals.breed.speed");
        this.breedEvent = this.getSection().getBoolean("animals.breed.event");
        this.breedTeleport = this.getSection().getBoolean("animals.breed.teleport");
        if (this.mobAiReducer != null) {
            this.mobAiReducer.load();
            return true;
        }
        return false;
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
    }

    public EnumSet<EntityType> getList() {
        return this.list;
    }

    public EnumSet<CreatureSpawnEvent.SpawnReason> getReasons() {
        return this.reasons;
    }

    public HashSet<String> getAi_list() {
        return this.ai_list;
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public NMS getMobAiReducer() {
        return this.mobAiReducer;
    }

    public boolean isIgnore_models() {
        return this.ignore_models;
    }

    public boolean isAnimals() {
        return this.animals;
    }

    public boolean isMonsters() {
        return this.monsters;
    }

    public boolean isVillagers() {
        return this.villagers;
    }

    public boolean isTameable() {
        return this.tameable;
    }

    public boolean isBirds() {
        return this.birds;
    }

    public boolean isOthers() {
        return this.others;
    }

    public boolean isList_mode() {
        return this.list_mode;
    }

    public boolean isForce_load() {
        return this.force_load;
    }

    public boolean isClick_event() {
        return this.click_event;
    }

    public int getPurge_interval() {
        return this.purge_interval;
    }

    public boolean isCollides() {
        return this.collides;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public boolean isKeep_dedicated() {
        return this.keep_dedicated;
    }

    public boolean isAi_list_mode() {
        return this.ai_list_mode;
    }

    public boolean isTemptEnabled() {
        return this.temptEnabled;
    }

    public double getTemptRange() {
        return this.temptRange;
    }

    public double getTemptSpeed() {
        return this.temptSpeed;
    }

    public int getTemptCooldown() {
        return this.temptCooldown;
    }

    public boolean isTemptTriggerBothHands() {
        return this.temptTriggerBothHands;
    }

    public boolean isTemptEvent() {
        return this.temptEvent;
    }

    public boolean isTemptTeleport() {
        return this.temptTeleport;
    }

    public boolean isBreedEnabled() {
        return this.breedEnabled;
    }

    public double getBreedRange() {
        return this.breedRange;
    }

    public boolean isBreedEvent() {
        return this.breedEvent;
    }

    public boolean isBreedTeleport() {
        return this.breedTeleport;
    }

    public double getBreedSpeed() {
        return this.breedSpeed;
    }

    public static abstract class NMS
    implements Listener {
        private final MobAiReducerModule module;

        public NMS(MobAiReducerModule module) {
            this.module = module;
        }

        public abstract void load();

        public abstract void optimize(Entity var1, boolean var2);

        public abstract void purge();

        public MobAiReducerModule getModule() {
            return this.module;
        }
    }
}

