/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.modules;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.hooks.LevelledMobsHook;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.managers.ModuleManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.objects.AbstractModule;
import xyz.lychee.lagfixer.objects.AbstractSupportNms;
import xyz.lychee.lagfixer.utils.ItemBuilder;
import xyz.lychee.lagfixer.utils.ReflectionUtils;

public class WorldCleanerModule
extends AbstractModule
implements Listener {
    private final HashSet<ItemStack> items = new HashSet();
    private final HashMap<Integer, String> messages = new HashMap();
    private final EnumSet<EntityType> creatures_list = EnumSet.noneOf(EntityType.class);
    private final EnumSet<EntityType> projectiles_blacklist = EnumSet.noneOf(EntityType.class);
    private final ArrayList<Inventory> inventories = new ArrayList();
    private final EnumSet<Material> items_abyss_blacklist = EnumSet.noneOf(Material.class);
    private final ItemBuilder items_abyss_previous;
    private final ItemBuilder items_abyss_next;
    private final ItemBuilder items_abyss_filler;
    private final EnumSet<Material> items_blacklist = EnumSet.noneOf(Material.class);
    private NMS worldCleaner;
    private Command command;
    private ScheduledTask task;
    private boolean opened = false;
    private int second;
    private int interval;
    private boolean alerts;
    private boolean creatures_enabled;
    private boolean creatures_named;
    private boolean creatures_dropitems;
    private boolean creatures_stacked;
    private boolean creatures_levelled;
    private boolean creatures_ignore_models;
    private boolean creatures_listmode;
    private boolean items_enabled;
    private boolean items_disableitemdespawn;
    private int items_timelived;
    private boolean items_abyss_enabled;
    private boolean items_abyss_alerts;
    private boolean items_abyss_itemdespawn;
    private String items_abyss_permission;
    private int items_abyss_close;
    private boolean projectiles_enabled;

    public WorldCleanerModule(LagFixer plugin, ModuleManager manager) {
        super(plugin, manager, AbstractModule.Impact.MEDIUM, "WorldCleaner", new String[]{"Cleans up old items on the ground to accelerate server performance.", "Accumulation of items over time contributes to server lag, especially in densely populated or active servers.", "Kills creatures to accelerate server performance.", "Players can retrieve items from the Abyss inventory using the /abyss command."}, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTlkODA2Yjc1ZWM5NTAwNmM1ZWMzODY2YzU0OGM1NTcxYWYzZTc4OGM3ZDE2MjllZGU2NGJjMWI3NDg4NTljZCJ9fX0=");
        this.items_abyss_previous = ItemBuilder.createSkull("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjg0ZjU5NzEzMWJiZTI1ZGMwNThhZjg4OGNiMjk4MzFmNzk1OTliYzY3Yzk1YzgwMjkyNWNlNGFmYmEzMzJmYyJ9fX0=");
        this.items_abyss_next = ItemBuilder.createSkull("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTYzMzlmZjJlNTM0MmJhMThiZGM0OGE5OWNjYTY1ZDEyM2NlNzgxZDg3ODI3MmY5ZDk2NGVhZDNiOGFkMzcwIn19fQ==");
        this.items_abyss_filler = new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE).setName("&8#");
    }

    @EventHandler
    public void onDespawn(ItemDespawnEvent e) {
        if (this.items_disableitemdespawn) {
            e.setCancelled(true);
            return;
        }
        if (this.items_abyss_enabled && this.items_abyss_itemdespawn && !this.items_abyss_blacklist.contains(e.getEntity().getItemStack().getType())) {
            HookManager.StackerContainer stacker = HookManager.getInstance().getStacker();
            if (stacker != null) {
                stacker.addItemsToList(e.getEntity(), this.items);
            } else {
                this.items.add(e.getEntity().getItemStack());
            }
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        Inventory inv = e.getClickedInventory();
        if (inv != null && this.inventories.contains(inv)) {
            ItemStack is = e.getCurrentItem();
            if (is == null) {
                return;
            }
            if (is.equals((Object)this.items_abyss_next.getItem())) {
                e.setCancelled(true);
                int next = this.inventories.indexOf(inv) + 1;
                if (next < this.inventories.size()) {
                    e.getWhoClicked().openInventory(this.inventories.get(next));
                }
            } else if (is.equals((Object)this.items_abyss_previous.getItem())) {
                e.setCancelled(true);
                int previous = this.inventories.indexOf(inv) - 1;
                if (previous >= 0) {
                    e.getWhoClicked().openInventory(this.inventories.get(previous));
                }
            } else if (is.equals((Object)this.items_abyss_filler.getItem())) {
                e.setCancelled(true);
            }
        }
    }

    @Override
    public void load() throws IOException {
        this.command = new Command(Collections.emptyList());
        Bukkit.getCommandMap().register(this.command.getName(), (org.bukkit.command.Command)this.command);
        this.second = this.interval + 1;
        this.task = Bukkit.getAsyncScheduler().runAtFixedRate((Plugin)this.getPlugin(), t1 -> {
            if (--this.second <= 0) {
                ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
                for (World world : this.getAllowedWorlds()) {
                    this.worldCleaner.purgeAll(world, futures);
                }
                if (this.alerts && this.messages.containsKey(this.second)) {
                    AbstractSupportNms.RegionsReport regionsReport = SupportManager.getInstance().getRegionsReport();
                    Component text = Language.createComponent(this.messages.get(this.second), true, Placeholder.unparsed((String)"remaining", (String)Integer.toString(this.second)), Placeholder.unparsed((String)"items", (String)Integer.toString(regionsReport.getItems())), Placeholder.unparsed((String)"creatures", (String)Integer.toString(regionsReport.getCreatures())), Placeholder.unparsed((String)"projectiles", (String)Integer.toString(regionsReport.getProjectiles())));
                    Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(text));
                }
                CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).orTimeout(5L, TimeUnit.SECONDS).whenComplete((v, t) -> {
                    if (this.items_abyss_enabled) {
                        String guiName = this.getLanguage().getString("items.abyss.gui.name", true, new TagResolver.Single[0]);
                        Collection<Object> toStore = new ArrayList<ItemStack>(this.items);
                        this.items.clear();
                        int page = 0;
                        while (!toStore.isEmpty()) {
                            Inventory inv = Bukkit.createInventory(null, (int)54, (Component)Language.getSerializer().deserialize(guiName.replace("<page>", Integer.toString(++page))));
                            for (int i = 45; i < 52; ++i) {
                                inv.setItem(i, this.items_abyss_filler.getItem());
                            }
                            inv.setItem(52, this.items_abyss_previous.getItem());
                            inv.setItem(53, this.items_abyss_next.getItem());
                            toStore = inv.addItem(toStore.toArray(new ItemStack[0])).values();
                            this.inventories.add(inv);
                        }
                        this.opened = true;
                        if (this.items_abyss_alerts) {
                            Component open = this.getLanguage().getComponent("items.abyss.open", true, new TagResolver.Single[0]);
                            Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(open));
                        }
                        Bukkit.getAsyncScheduler().runDelayed((Plugin)this.getPlugin(), t2 -> {
                            this.opened = false;
                            Bukkit.getGlobalRegionScheduler().execute((Plugin)this.getPlugin(), () -> {
                                this.inventories.forEach(inv -> {
                                    new HashSet(inv.getViewers()).forEach(HumanEntity::closeInventory);
                                    inv.clear();
                                });
                                this.inventories.clear();
                            });
                            if (this.items_abyss_alerts) {
                                Component close = this.getLanguage().getComponent("items.abyss.close", true, new TagResolver.Single[0]);
                                Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(close));
                            }
                        }, (long)this.items_abyss_close, TimeUnit.SECONDS);
                    }
                });
                this.second = this.interval + 1;
            } else if (this.alerts && this.messages.containsKey(this.second)) {
                AbstractSupportNms.RegionsReport regionsReport = SupportManager.getInstance().getRegionsReport();
                Component text = Language.createComponent(this.messages.get(this.second), true, Placeholder.unparsed((String)"remaining", (String)Integer.toString(this.second)), Placeholder.unparsed((String)"items", (String)Integer.toString(regionsReport.getItems())), Placeholder.unparsed((String)"creatures", (String)Integer.toString(regionsReport.getCreatures())), Placeholder.unparsed((String)"projectiles", (String)Integer.toString(regionsReport.getProjectiles())));
                Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(text));
            }
        }, 1L, 1L, TimeUnit.SECONDS);
        this.getPlugin().getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this.getPlugin());
    }

    public boolean clearCreature(Entity ent) {
        HookManager.ModelContainer model;
        if (this.getCreatures_list().contains(ent.getType()) != this.isCreatures_listmode()) {
            return false;
        }
        HookManager hm = HookManager.getInstance();
        if (!this.isCreatures_ignore_models() && (model = hm.getModel()) != null && model.hasModel(ent)) {
            return false;
        }
        LevelledMobsHook lvlHook = hm.getHook(LevelledMobsHook.class);
        if (lvlHook != null && ent instanceof LivingEntity && lvlHook.isLevelled((LivingEntity)ent)) {
            return this.isCreatures_levelled();
        }
        HookManager.StackerContainer stacker = hm.getStacker();
        if (stacker != null && ent instanceof LivingEntity && stacker.isStacked((LivingEntity)ent)) {
            return this.isCreatures_stacked();
        }
        if (ent.getCustomName() != null) {
            return this.isCreatures_named();
        }
        return true;
    }

    public boolean clearItem(Entity ent) {
        return !ent.isInvulnerable() && ent.getTicksLived() > this.getItems_timelived() && ent instanceof Item && ((Item)ent).getPickupDelay() < 200 && !this.getItems_blacklist().contains(((Item)ent).getItemStack().getType());
    }

    public boolean clearProjectile(Entity ent) {
        return !this.getProjectiles_blacklist().contains(ent.getType());
    }

    @Override
    public boolean loadConfig() {
        this.worldCleaner = (NMS)ReflectionUtils.createInstance("WorldCleaner", this);
        this.interval = Math.max(this.getSection().getInt("interval"), 1);
        this.alerts = this.getSection().getBoolean("alerts");
        this.creatures_enabled = this.getSection().getBoolean("creatures.enabled");
        if (this.creatures_enabled) {
            this.creatures_named = this.getSection().getBoolean("creatures.named");
            this.creatures_dropitems = this.getSection().getBoolean("creatures.drop_items");
            this.creatures_stacked = this.getSection().getBoolean("creatures.stacked");
            this.creatures_levelled = this.getSection().getBoolean("creatures.levelled");
            this.creatures_ignore_models = HookManager.getInstance().noneModels() || this.getSection().getBoolean("creatures.ignore_models");
            this.creatures_listmode = this.getSection().getBoolean("creatures.list_mode");
            ReflectionUtils.convertEnums(EntityType.class, this.creatures_list, this.getSection().getStringList("creatures.list"));
        }
        this.items_enabled = this.getSection().getBoolean("items.enabled");
        if (this.items_enabled) {
            this.items_timelived = this.getSection().getInt("items.time_lived") / 50;
            this.items_disableitemdespawn = this.getSection().getBoolean("items.disable_item_despawn");
            ReflectionUtils.convertEnums(Material.class, this.items_blacklist, this.getSection().getStringList("items.blacklist"));
            this.items_abyss_enabled = this.getSection().getBoolean("items.abyss.enabled");
            if (this.items_abyss_enabled) {
                this.items_abyss_alerts = this.getSection().getBoolean("items.abyss.alerts");
                this.items_abyss_permission = this.getSection().getString("items.abyss.permission");
                this.items_abyss_itemdespawn = this.getSection().getBoolean("items.abyss.item_despawn");
                this.items_abyss_close = this.getSection().getInt("items.abyss.close");
                ReflectionUtils.convertEnums(Material.class, this.items_abyss_blacklist, this.getSection().getStringList("items.abyss.blacklist"));
                this.items_abyss_previous.setName(this.getLanguage().getString("items.abyss.gui.previous", false, new TagResolver.Single[0]));
                this.items_abyss_next.setName(this.getLanguage().getString("items.abyss.gui.next", false, new TagResolver.Single[0]));
            }
        }
        this.messages.clear();
        for (String str : Language.getYaml().getStringList("messages." + this.getName() + ".countingdown")) {
            try {
                int equalSignIndex = str.indexOf(61);
                if (equalSignIndex != -1) {
                    String index = str.substring(0, equalSignIndex);
                    String message = str.substring(equalSignIndex + 1);
                    try {
                        int parsedIndex = Integer.parseInt(index);
                        this.messages.put(parsedIndex, message);
                    }
                    catch (NumberFormatException e) {
                        this.getPlugin().getLogger().warning("Invalid index format in countingdown message: " + index + " for message \"" + message + "\"");
                    }
                    continue;
                }
                this.getPlugin().getLogger().warning("Skipping malformed countingdown message (no \"=\" found): " + str);
            }
            catch (Exception ex) {
                this.getPlugin().getLogger().info("Error processing countingdown message: " + str);
                this.getPlugin().printError(ex);
            }
        }
        this.projectiles_enabled = this.getSection().getBoolean("projectiles.enabled");
        if (this.projectiles_enabled) {
            ReflectionUtils.convertEnums(EntityType.class, this.projectiles_blacklist, this.getSection().getStringList("projectiles.blacklist"));
        }
        return this.worldCleaner != null;
    }

    @Override
    public void disable() throws IOException {
        HandlerList.unregisterAll((Listener)this);
        if (this.task != null && !this.task.isCancelled()) {
            this.task.cancel();
        }
        if (this.command != null) {
            this.command.unregister(Bukkit.getCommandMap());
        }
    }

    public HashSet<ItemStack> getItems() {
        return this.items;
    }

    public HashMap<Integer, String> getMessages() {
        return this.messages;
    }

    public EnumSet<EntityType> getCreatures_list() {
        return this.creatures_list;
    }

    public EnumSet<EntityType> getProjectiles_blacklist() {
        return this.projectiles_blacklist;
    }

    public ArrayList<Inventory> getInventories() {
        return this.inventories;
    }

    public EnumSet<Material> getItems_abyss_blacklist() {
        return this.items_abyss_blacklist;
    }

    public ItemBuilder getItems_abyss_previous() {
        return this.items_abyss_previous;
    }

    public ItemBuilder getItems_abyss_next() {
        return this.items_abyss_next;
    }

    public ItemBuilder getItems_abyss_filler() {
        return this.items_abyss_filler;
    }

    public EnumSet<Material> getItems_blacklist() {
        return this.items_blacklist;
    }

    public NMS getWorldCleaner() {
        return this.worldCleaner;
    }

    public Command getCommand() {
        return this.command;
    }

    public ScheduledTask getTask() {
        return this.task;
    }

    public boolean isOpened() {
        return this.opened;
    }

    public int getSecond() {
        return this.second;
    }

    public int getInterval() {
        return this.interval;
    }

    public boolean isAlerts() {
        return this.alerts;
    }

    public boolean isCreatures_enabled() {
        return this.creatures_enabled;
    }

    public boolean isCreatures_named() {
        return this.creatures_named;
    }

    public boolean isCreatures_dropitems() {
        return this.creatures_dropitems;
    }

    public boolean isCreatures_stacked() {
        return this.creatures_stacked;
    }

    public boolean isCreatures_levelled() {
        return this.creatures_levelled;
    }

    public boolean isCreatures_ignore_models() {
        return this.creatures_ignore_models;
    }

    public boolean isCreatures_listmode() {
        return this.creatures_listmode;
    }

    public boolean isItems_enabled() {
        return this.items_enabled;
    }

    public boolean isItems_disableitemdespawn() {
        return this.items_disableitemdespawn;
    }

    public int getItems_timelived() {
        return this.items_timelived;
    }

    public boolean isItems_abyss_enabled() {
        return this.items_abyss_enabled;
    }

    public boolean isItems_abyss_alerts() {
        return this.items_abyss_alerts;
    }

    public boolean isItems_abyss_itemdespawn() {
        return this.items_abyss_itemdespawn;
    }

    public String getItems_abyss_permission() {
        return this.items_abyss_permission;
    }

    public int getItems_abyss_close() {
        return this.items_abyss_close;
    }

    public boolean isProjectiles_enabled() {
        return this.projectiles_enabled;
    }

    public class Command
    extends BukkitCommand {
        public Command(List<String> aliases) {
            super("abyss", "Abyss lagfixer command", "/abyss", aliases);
        }

        public boolean execute(@NotNull CommandSender sender, @NotNull String s, @NotNull String[] args) {
            Component text;
            if (!WorldCleanerModule.this.items_abyss_enabled) {
                text = Language.getMainValue("disabled_module", true, Placeholder.unparsed((String)"module", (String)("Abyss (" + this.getName() + ")")));
            } else if (WorldCleanerModule.this.items_abyss_permission != null && !WorldCleanerModule.this.items_abyss_permission.isEmpty() && !sender.hasPermission(WorldCleanerModule.this.items_abyss_permission)) {
                text = Language.getMainValue("no_access", true, Placeholder.unparsed((String)"permission", (String)WorldCleanerModule.this.items_abyss_permission));
            } else if (!WorldCleanerModule.this.opened) {
                text = WorldCleanerModule.this.getLanguage().getComponent("items.abyss.closed", true, new TagResolver.Single[0]);
            } else if (sender instanceof Player) {
                if (WorldCleanerModule.this.inventories.isEmpty()) {
                    text = WorldCleanerModule.this.getLanguage().getComponent("items.abyss.empty", true, new TagResolver.Single[0]);
                } else {
                    ((Player)sender).openInventory(WorldCleanerModule.this.inventories.get(0));
                    text = WorldCleanerModule.this.getLanguage().getComponent("items.abyss.opened", true, new TagResolver.Single[0]);
                }
            } else {
                text = Language.getMainValue("player_only", true, new TagResolver.Single[0]);
            }
            if (text != null) {
                sender.sendMessage(text);
            }
            return false;
        }
    }

    public static abstract class NMS {
        private final WorldCleanerModule module;

        public NMS(WorldCleanerModule module) {
            this.module = module;
        }

        public abstract void purgeAll(World var1, List<CompletableFuture<Void>> var2);

        public abstract void purgeCreatures(World var1, List<CompletableFuture<Void>> var2);

        public abstract void purgeItems(World var1, List<CompletableFuture<Void>> var2);

        public abstract void purgeProjectiles(World var1, List<CompletableFuture<Void>> var2);

        public WorldCleanerModule getModule() {
            return this.module;
        }
    }
}

