/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R1;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import org.jetbrains.annotations.NotNull;

public interface OptimizedEntities {

    public static class OMinecartTNT
    extends MinecartTNT
    implements OptimizedEntities {
        OMinecartTNT(MinecartTNT mt) {
            super(mt.getType(), mt.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return false;
        }
    }

    public static class OMinecartSpawner
    extends MinecartSpawner
    implements OptimizedEntities {
        OMinecartSpawner(MinecartSpawner other) {
            super(other.getType(), other.level());
            Optional.ofNullable(this.getSpawner().nextSpawnData).flatMap(sd -> EntityType.by((CompoundTag)sd.entityToSpawn())).ifPresent(type -> this.getSpawner().setEntityId(type, other.level(), other.level().getRandom(), this.blockPosition()));
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return false;
        }
    }

    public static class OMinecartFurnace
    extends MinecartFurnace
    implements OptimizedEntities {
        OMinecartFurnace(MinecartFurnace mf) {
            super(mf.getType(), mf.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return false;
        }
    }

    public static class OMinecartHopper
    extends MinecartHopper
    implements OptimizedEntities {
        OMinecartHopper(MinecartHopper mh) {
            super(mh.getType(), mh.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return false;
        }
    }

    public static class OMinecartChest
    extends MinecartChest
    implements OptimizedEntities {
        OMinecartChest(MinecartChest mc) {
            super(mc.getType(), mc.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return false;
        }
    }

    public static class OMinecart
    extends Minecart
    implements OptimizedEntities {
        OMinecart(Minecart m) {
            super(m.getType(), m.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return false;
        }
    }

    public static class OChestBoat
    extends ChestBoat
    implements OptimizedEntities {
        OChestBoat(ChestBoat cb) {
            super(cb.getType(), cb.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return true;
        }
    }

    public static class OBoat
    extends Boat
    implements OptimizedEntities {
        OBoat(Boat b) {
            super(b.getType(), b.level());
        }

        public boolean canCollideWith(@NotNull Entity entity) {
            return false;
        }

        public boolean isPushable() {
            return true;
        }
    }
}

