/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R2;

import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.modules.EntityLimiterModule;

public class EntityLimiter
extends EntityLimiterModule.NMS {
    public EntityLimiter(EntityLimiterModule module) {
        super(module);
    }

    @Override
    public void overflowPurge(World world) {
        int limit_creatures = (int)((double)this.getModule().getCreatures() * this.getModule().getOverflow_multiplier());
        int limit_items = (int)((double)this.getModule().getItems() * this.getModule().getOverflow_multiplier());
        int limit_vehicles = (int)((double)this.getModule().getVehicles() * this.getModule().getOverflow_multiplier());
        int limit_projectiles = (int)((double)this.getModule().getProjectiles() * this.getModule().getOverflow_multiplier());
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
            Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, () -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    int creatures = 0;
                    int items = 0;
                    int vehicles = 0;
                    int projectiles = 0;
                    boolean others = false;
                    int locks = 0;
                    for (Entity bent : slices.getChunkEntities()) {
                        net.minecraft.world.entity.Entity ent = ((CraftEntity)bent).getHandle();
                        if (this.getModule().getWhitelist().contains(bent.getType()) || !this.getModule().isOverflow_named() && ent.getCustomName() != null || !this.getModule().isIgnore_models() && HookManager.getInstance().getModel().hasModel((Entity)ent.getBukkitEntityRaw())) continue;
                        boolean removed = false;
                        if (ent instanceof Mob) {
                            if (this.getModule().isOverflow_creatures() && creatures < limit_creatures) {
                                ++creatures;
                            } else {
                                removed = true;
                            }
                        } else if (ent instanceof ItemEntity) {
                            if (this.getModule().isOverflow_items() && items < limit_items) {
                                ++items;
                            } else {
                                removed = true;
                            }
                        } else if (ent instanceof AbstractMinecart || ent instanceof Boat) {
                            if (this.getModule().isOverflow_vehicles() && vehicles < limit_vehicles) {
                                ++vehicles;
                            } else {
                                removed = true;
                            }
                        } else if (ent instanceof Projectile) {
                            if (this.getModule().isOverflow_projectiles() && projectiles < limit_projectiles) {
                                ++projectiles;
                            } else {
                                removed = true;
                            }
                        }
                        if (!removed) continue;
                        ent.remove(Entity.RemovalReason.KILLED);
                        ++locks;
                    }
                    this.getModule().setLocks(this.getModule().getLocks() + locks);
                }
            });
        });
    }
}

