/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R2;

import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.monster.Strider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import org.bukkit.craftbukkit.v1_20_R2.entity.CraftCreature;
import org.bukkit.craftbukkit.v1_20_R2.event.CraftEventFactory;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.world.EntitiesLoadEvent;
import xyz.lychee.lagfixer.modules.MobAiReducerModule;

public class MobAiReducer
extends MobAiReducerModule.NMS
implements Listener {
    private final Map<PathfinderMob, Boolean> optimizedMobs = new MapMaker().weakKeys().concurrencyLevel(4).makeMap();
    private final Map<Class<? extends net.minecraft.world.entity.Entity>, TargetingConditions> temptTargeting = new HashMap<Class<? extends net.minecraft.world.entity.Entity>, TargetingConditions>();
    private final TargetingConditions breedTargeting = TargetingConditions.forNonCombat().ignoreLineOfSight();

    public MobAiReducer(MobAiReducerModule module) {
        super(module);
    }

    @Override
    public void load() {
        this.breedTargeting.range(this.getModule().getBreedRange());
        this.register(Cow.class, Items.WHEAT);
        this.register(MushroomCow.class, Items.WHEAT);
        this.register(Sheep.class, Items.WHEAT);
        this.register(Pig.class, Items.CARROT, Items.POTATO, Items.BEETROOT);
        this.register(Chicken.class, Items.WHEAT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.BEETROOT_SEEDS);
        this.register(Rabbit.class, Items.CARROT, Items.GOLDEN_CARROT, Items.DANDELION);
        this.register(Horse.class, Items.APPLE, Items.GOLDEN_APPLE, Items.GOLDEN_CARROT, Items.SUGAR, Items.HAY_BLOCK, Items.WHEAT);
        this.register(Donkey.class, Items.APPLE, Items.GOLDEN_APPLE, Items.GOLDEN_CARROT, Items.SUGAR, Items.HAY_BLOCK, Items.WHEAT);
        this.register(Llama.class, Items.HAY_BLOCK, Items.WHEAT);
        this.register(Parrot.class, Items.WHEAT_SEEDS, Items.MELON_SEEDS, Items.PUMPKIN_SEEDS, Items.BEETROOT_SEEDS);
        this.register(Ocelot.class, Items.COD, Items.SALMON);
        this.register(Cat.class, Items.COD, Items.SALMON);
        this.register(Panda.class, Items.BAMBOO, Items.CAKE);
        this.register(Fox.class, Items.SWEET_BERRIES, Items.GLOW_BERRIES);
        this.register(Turtle.class, Items.SEAGRASS);
        this.register(Bee.class, Items.POPPY, Items.DANDELION, Items.BLUE_ORCHID, Items.ALLIUM, Items.AZURE_BLUET, Items.RED_TULIP, Items.ORANGE_TULIP, Items.WHITE_TULIP, Items.PINK_TULIP, Items.OXEYE_DAISY, Items.CORNFLOWER, Items.LILY_OF_THE_VALLEY, Items.SUNFLOWER);
        this.register(Strider.class, Items.WARPED_FUNGUS);
        this.register(Goat.class, Items.WHEAT);
        this.register(Axolotl.class, Items.TROPICAL_FISH_BUCKET);
        this.register(Frog.class, Items.SLIME_BALL);
        this.register(Camel.class, Items.CACTUS);
        this.register(Sniffer.class, Items.TORCHFLOWER_SEEDS, Items.PITCHER_POD);
    }

    private void register(Class<? extends net.minecraft.world.entity.Entity> clazz, Item ... items) {
        HashSet itemSet = Sets.newHashSet((Object[])items);
        this.temptTargeting.computeIfAbsent(clazz, k -> TargetingConditions.forNonCombat().ignoreLineOfSight()).range(this.getModule().getTemptRange()).selector(entity -> itemSet.contains(entity.getMainHandItem().getItem()) || this.getModule().isTemptTriggerBothHands() && itemSet.contains(entity.getOffhandItem().getItem()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void optimize(Entity ent, boolean init) {
        Set goals;
        if (!(ent instanceof CraftCreature)) {
            return;
        }
        PathfinderMob handle = ((CraftCreature)ent).getHandle();
        if (this.optimizedMobs.containsKey(handle)) {
            return;
        }
        MobAiReducerModule module = this.getModule();
        boolean keepDedicated = module.isKeep_dedicated();
        boolean aiListMode = module.isAi_list_mode();
        HashSet<String> aiList = module.getAi_list();
        handle.collides = module.isCollides();
        handle.setSilent(module.isSilent());
        this.optimizedMobs.put(handle, Boolean.TRUE);
        boolean isAnimal = handle instanceof Animal;
        Class<?> handleClass = handle.getClass();
        TargetingConditions temptTargeting = module.isTemptEnabled() ? this.temptTargeting.get(handleClass) : null;
        Set set = goals = handle.goalSelector.getAvailableGoals();
        synchronized (set) {
            HashSet<WrappedGoal> toAdd = new HashSet<WrappedGoal>();
            HashSet<WrappedGoal> toRemove = new HashSet<WrappedGoal>();
            for (WrappedGoal pgw : goals) {
                Goal goal = pgw.getGoal();
                Class<?> goalClass = goal.getClass();
                if (keepDedicated && !goalClass.getName().contains("ai.goal")) continue;
                if (isAnimal && module.isBreedEnabled() && goalClass == BreedGoal.class) {
                    toRemove.add(pgw);
                    toAdd.add(new WrappedGoal(pgw.getPriority(), (Goal)new OptimizedBreedGoal((Animal)handle)));
                    continue;
                }
                if (module.isTemptEnabled() && goalClass == TemptGoal.class && temptTargeting != null) {
                    toRemove.add(pgw);
                    toAdd.add(new WrappedGoal(pgw.getPriority(), (Goal)new OptimizedTemptGoal(handle, temptTargeting)));
                    continue;
                }
                String simpleName = goalClass.getSimpleName();
                if (aiList.stream().anyMatch(simpleName::contains) != aiListMode) continue;
                toRemove.add(pgw);
            }
            if (!toRemove.isEmpty()) {
                goals.removeAll(toRemove);
            }
            if (!toAdd.isEmpty()) {
                goals.addAll(toAdd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        Map<PathfinderMob, Boolean> map = this.optimizedMobs;
        synchronized (map) {
            this.optimizedMobs.keySet().removeIf(ent -> !ent.isAlive() || !ent.valid);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onLoad(EntitiesLoadEvent e) {
        if (this.getModule().canContinue(e.getWorld())) {
            this.optimizeEntities(e.getEntities());
        }
    }

    public void optimizeEntities(List<Entity> list) {
        for (Entity entity : list) {
            if (!this.getModule().isEnabled(entity)) continue;
            this.optimize(entity, false);
        }
    }

    public class OptimizedBreedGoal
    extends Goal {
        protected final Animal animal;
        protected Animal partner;

        public OptimizedBreedGoal(Animal entityanimal) {
            this.animal = entityanimal;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (!this.animal.isInLove()) {
                return false;
            }
            this.partner = this.getFreePartner();
            if (this.partner == null || !this.partner.isAlive() || !this.partner.isInLove()) {
                return false;
            }
            if (MobAiReducer.this.getModule().isBreedEvent()) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.animal, (LivingEntity)this.partner, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.CUSTOM);
                return !event.isCancelled();
            }
            return true;
        }

        public void tick() {
            if (MobAiReducer.this.getModule().isBreedTeleport()) {
                this.animal.teleportTo(this.partner.getX(), this.partner.getY(), this.partner.getZ());
            } else {
                this.animal.getNavigation().moveTo((net.minecraft.world.entity.Entity)this.partner, MobAiReducer.this.getModule().getBreedSpeed());
            }
            this.animal.spawnChildFromBreeding(this.animal.level().getMinecraftWorld(), this.partner);
        }

        private Animal getFreePartner() {
            List nearbyEntities = this.animal.level().getNearbyEntities(this.animal.getClass(), MobAiReducer.this.breedTargeting, (LivingEntity)this.animal, this.animal.getBoundingBox().inflate(8.0));
            return nearbyEntities.stream().filter(arg_0 -> ((Animal)this.animal).canMate(arg_0)).min(Comparator.comparingDouble(other -> other.distanceToSqr((net.minecraft.world.entity.Entity)this.animal))).orElse(null);
        }
    }

    public class OptimizedTemptGoal
    extends Goal {
        private final PathfinderMob mob;
        private final TargetingConditions targeting;
        private int cooldown = 0;
        private Player targetPlayer;

        public OptimizedTemptGoal(PathfinderMob mob, TargetingConditions targeting) {
            this.mob = mob;
            this.targeting = targeting;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            this.targetPlayer = this.mob.level().getNearestPlayer(this.targeting, (LivingEntity)this.mob);
            if (this.targetPlayer == null) {
                return false;
            }
            if (MobAiReducer.this.getModule().isTemptEvent()) {
                EntityTargetLivingEntityEvent event = CraftEventFactory.callEntityTargetLivingEvent((net.minecraft.world.entity.Entity)this.mob, (LivingEntity)this.targetPlayer, (EntityTargetEvent.TargetReason)EntityTargetEvent.TargetReason.TEMPT);
                return !event.isCancelled();
            }
            return true;
        }

        public void tick() {
            if (this.mob.distanceToSqr((net.minecraft.world.entity.Entity)this.targetPlayer) >= 6.25 || MobAiReducer.this.getModule().isTemptTeleport()) {
                if (MobAiReducer.this.getModule().isTemptTeleport()) {
                    this.mob.teleportTo(this.targetPlayer.getX(), this.targetPlayer.getY(), this.targetPlayer.getZ());
                } else {
                    this.mob.getNavigation().moveTo((net.minecraft.world.entity.Entity)this.targetPlayer, this.mob instanceof Animal ? MobAiReducer.this.getModule().getTemptSpeed() : 0.35);
                }
            } else {
                this.mob.getNavigation().stop();
            }
            this.cooldown = MobAiReducer.this.getModule().getTemptCooldown();
        }
    }
}

