/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R3;

import java.util.IdentityHashMap;
import java.util.function.Function;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.entity.vehicle.MinecartHopper;
import net.minecraft.world.entity.vehicle.MinecartSpawner;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.item.ItemStack;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftBoat;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftMinecart;
import org.bukkit.craftbukkit.v1_20_R3.entity.CraftMinecartChest;
import org.bukkit.entity.Vehicle;
import xyz.lychee.lagfixer.modules.VehicleMotionReducerModule;
import xyz.lychee.lagfixer.nms.v1_20_R3.OptimizedEntities;

public class VehicleMotionReducer
extends VehicleMotionReducerModule.NMS {
    private static final IdentityHashMap<Class<? extends VehicleEntity>, Function<VehicleEntity, VehicleEntity>> VEHICLES = new IdentityHashMap(10);

    public VehicleMotionReducer(VehicleMotionReducerModule module) {
        super(module);
    }

    @Override
    public boolean optimizeVehicle(Vehicle vehicle) {
        if (vehicle instanceof CraftBoat) {
            if (!this.getModule().isBoat()) {
                return false;
            }
            return this.processEntity((VehicleEntity)((CraftBoat)vehicle).getHandle());
        }
        if (vehicle instanceof CraftMinecart) {
            if (!this.getModule().isMinecart()) {
                return false;
            }
            if (vehicle instanceof CraftMinecartChest && this.getModule().isMinecart_remove_chest()) {
                AbstractMinecartContainer mc = ((CraftMinecartChest)vehicle).getHandle();
                mc.clearContent();
                mc.removeVehicle();
                return true;
            }
            return this.processEntity((VehicleEntity)((CraftMinecart)vehicle).getHandle());
        }
        return false;
    }

    private boolean processEntity(VehicleEntity original) {
        if (original instanceof OptimizedEntities) {
            return false;
        }
        Function<VehicleEntity, VehicleEntity> factory = VEHICLES.get(original.getClass());
        if (factory == null) {
            return false;
        }
        VehicleEntity newVehicle = factory.apply(original);
        newVehicle.setSilent(true);
        this.copyLocation(original, newVehicle);
        this.transferItems(original, newVehicle);
        original.removeVehicle();
        original.level().addFreshEntity((Entity)newVehicle);
        return true;
    }

    private void transferItems(VehicleEntity from, VehicleEntity to) {
        if (from instanceof ContainerEntity && to instanceof ContainerEntity) {
            for (ItemStack stack : ((ContainerEntity)from).getItemStacks()) {
                if (stack.isEmpty()) continue;
                ((ContainerEntity)to).getItemStacks().add((Object)stack);
            }
            ((ContainerEntity)from).clearItemStacks();
        }
    }

    private void copyLocation(VehicleEntity from, VehicleEntity to) {
        to.setPos(from.xo, from.yo, from.zo);
        to.xo = from.xo;
        to.yo = from.yo;
        to.zo = from.zo;
        float yaw = Location.normalizeYaw((float)from.yRotO);
        to.setYRot(yaw);
        to.yRotO = yaw;
        to.setYHeadRot(yaw);
    }

    static {
        VEHICLES.put(Boat.class, e -> new OptimizedEntities.OBoat((Boat)e));
        VEHICLES.put(ChestBoat.class, e -> new OptimizedEntities.OChestBoat((ChestBoat)e));
        VEHICLES.put(MinecartChest.class, e -> new OptimizedEntities.OMinecartChest((MinecartChest)e));
        VEHICLES.put(MinecartHopper.class, e -> new OptimizedEntities.OMinecartHopper((MinecartHopper)e));
        VEHICLES.put(MinecartFurnace.class, e -> new OptimizedEntities.OMinecartFurnace((MinecartFurnace)e));
        VEHICLES.put(MinecartSpawner.class, e -> new OptimizedEntities.OMinecartSpawner((MinecartSpawner)e));
        VEHICLES.put(MinecartTNT.class, e -> new OptimizedEntities.OMinecartTNT((MinecartTNT)e));
        VEHICLES.put(Minecart.class, e -> new OptimizedEntities.OMinecart((Minecart)e));
    }
}

