/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R3;

import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R3.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;

public class WorldCleaner
extends WorldCleanerModule.NMS {
    public WorldCleaner(WorldCleanerModule module) {
        super(module);
    }

    @Override
    public void purgeAll(World world, List<CompletableFuture<Void>> into) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        HookManager.StackerContainer stacker = HookManager.getInstance().getStacker();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                EnumSet<Material> bl = this.getModule().getItems_abyss_blacklist();
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (ent instanceof Mob) {
                            Mob creature = (Mob)ent;
                            if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature)) continue;
                            if (this.getModule().isCreatures_dropitems()) {
                                creature.damage(Double.MAX_VALUE);
                                continue;
                            }
                            creature.remove();
                            continue;
                        }
                        if (ent instanceof Item) {
                            Item item = (Item)ent;
                            if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item)) continue;
                            if (this.getModule().isItems_abyss_enabled() && !this.getModule().getItems_abyss_blacklist().contains(item.getItemStack().getType()) && !bl.contains(item.getItemStack().getType())) {
                                if (stacker != null) {
                                    stacker.addItemsToList(item, items);
                                } else {
                                    items.add(item.getItemStack());
                                }
                            }
                            item.remove();
                            continue;
                        }
                        if (!(ent instanceof Projectile)) continue;
                        Projectile projectile = (Projectile)ent;
                        if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile)) continue;
                        projectile.remove();
                    }
                }
                this.getModule().getItems().addAll(items);
            }, runnable -> {
                ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, runnable);
            }));
        });
    }

    @Override
    public void purgeCreatures(World world, List<CompletableFuture<Void>> into) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (!(ent instanceof Mob)) continue;
                        Mob creature = (Mob)ent;
                        if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature)) continue;
                        if (this.getModule().isCreatures_dropitems()) {
                            creature.damage(Double.MAX_VALUE);
                            continue;
                        }
                        creature.remove();
                    }
                }
            }, runnable -> {
                ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, runnable);
            }));
        });
    }

    @Override
    public void purgeItems(World world, List<CompletableFuture<Void>> into) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (!(ent instanceof Item)) continue;
                        Item item = (Item)ent;
                        if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item)) continue;
                        item.remove();
                    }
                }
            }, runnable -> {
                ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, runnable);
            }));
        });
    }

    @Override
    public void purgeProjectiles(World world, List<CompletableFuture<Void>> into) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (!(ent instanceof Projectile)) continue;
                        Projectile projectile = (Projectile)ent;
                        if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile)) continue;
                        projectile.remove();
                    }
                }
            }, runnable -> {
                ChunkPos pos = new ChunkPos(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.x, pos.z, runnable);
            }));
        });
    }
}

