/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.nms.v1_20_R4;

import io.papermc.paper.util.CoordinateUtils;
import io.papermc.paper.world.ChunkEntitySlices;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_20_R4.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Projectile;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xyz.lychee.lagfixer.managers.HookManager;
import xyz.lychee.lagfixer.modules.WorldCleanerModule;

public class WorldCleaner
extends WorldCleanerModule.NMS {
    public WorldCleaner(WorldCleanerModule module) {
        super(module);
    }

    @Override
    public void purgeAll(World world, List<CompletableFuture<Void>> into) {
        WorldServer level = ((CraftWorld)world).getHandle();
        HookManager.StackerContainer stacker = HookManager.getInstance().getStacker();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                EnumSet<Material> bl = this.getModule().getItems_abyss_blacklist();
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    block6: for (Entity ent : slices.getChunkEntities()) {
                        Entity selector0$temp;
                        Objects.requireNonNull(ent);
                        int index$1 = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Mob.class, Item.class, Projectile.class}, (Object)selector0$temp, index$1)) {
                            case 0: {
                                Mob creature = (Mob)selector0$temp;
                                if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature)) continue block6;
                                if (this.getModule().isCreatures_dropitems()) {
                                    creature.damage(Double.MAX_VALUE);
                                    continue block6;
                                }
                                creature.remove();
                                continue block6;
                            }
                            case 1: {
                                Item item = (Item)selector0$temp;
                                if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item)) continue block6;
                                if (this.getModule().isItems_abyss_enabled() && !this.getModule().getItems_abyss_blacklist().contains(item.getItemStack().getType()) && !bl.contains(item.getItemStack().getType())) {
                                    if (stacker != null) {
                                        stacker.addItemsToList(item, items);
                                    } else {
                                        items.add(item.getItemStack());
                                    }
                                }
                                item.remove();
                                continue block6;
                            }
                            case 2: {
                                Projectile projectile = (Projectile)selector0$temp;
                                if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile)) continue block6;
                                projectile.remove();
                                continue block6;
                            }
                        }
                    }
                }
                this.getModule().getItems().addAll(items);
            }, runnable -> {
                ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.e, pos.f, runnable);
            }));
        });
    }

    @Override
    public void purgeCreatures(World world, List<CompletableFuture<Void>> into) {
        WorldServer level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (!(ent instanceof Mob)) continue;
                        Mob creature = (Mob)ent;
                        if (!this.getModule().isCreatures_enabled() || !this.getModule().clearCreature((Entity)creature)) continue;
                        if (this.getModule().isCreatures_dropitems()) {
                            creature.damage(Double.MAX_VALUE);
                            continue;
                        }
                        creature.remove();
                    }
                }
            }, runnable -> {
                ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.e, pos.f, runnable);
            }));
        });
    }

    @Override
    public void purgeItems(World world, List<CompletableFuture<Void>> into) {
        WorldServer level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (!(ent instanceof Item)) continue;
                        Item item = (Item)ent;
                        if (!this.getModule().isItems_enabled() || !this.getModule().clearItem((Entity)item)) continue;
                        item.remove();
                    }
                }
            }, runnable -> {
                ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.e, pos.f, runnable);
            }));
        });
    }

    @Override
    public void purgeProjectiles(World world, List<CompletableFuture<Void>> into) {
        WorldServer level = ((CraftWorld)world).getHandle();
        level.regioniser.computeForAllRegions(region -> {
            LongArrayList chunks = region.getOwnedChunks();
            if (chunks.isEmpty()) {
                return;
            }
            into.add(CompletableFuture.runAsync(() -> {
                LongListIterator longListIterator = chunks.iterator();
                while (longListIterator.hasNext()) {
                    long l = (Long)longListIterator.next();
                    ChunkEntitySlices slices = level.getEntityLookup().getChunk(CoordinateUtils.getChunkX((long)l), CoordinateUtils.getChunkZ((long)l));
                    if (slices == null) continue;
                    for (Entity ent : slices.getChunkEntities()) {
                        if (!(ent instanceof Projectile)) continue;
                        Projectile projectile = (Projectile)ent;
                        if (!this.getModule().isProjectiles_enabled() || !this.getModule().clearProjectile((Entity)projectile)) continue;
                        projectile.remove();
                    }
                }
            }, runnable -> {
                ChunkCoordIntPair pos = new ChunkCoordIntPair(((Long)chunks.getFirst()).longValue());
                Bukkit.getRegionScheduler().execute((Plugin)this.getModule().getPlugin(), world, pos.e, pos.f, runnable);
            }));
        });
    }
}

