/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.utils;

import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.lagfixer.hooks.PlaceholderAPIHook;
import xyz.lychee.lagfixer.managers.ConfigManager;
import xyz.lychee.lagfixer.managers.HookManager;

public class MessageUtils
extends JavaPlugin {
    private static final HashMap<String, Character> replaceable = new HashMap();

    private static void add(String from, char to) {
        replaceable.put("{" + from + "}", Character.valueOf(to));
    }

    public static String fixColors(@Nullable CommandSender sender, String message) {
        PlaceholderAPIHook papi;
        AtomicReference<String> text = new AtomicReference<String>(message);
        replaceable.forEach((from, to) -> text.updateAndGet(s -> s.replace((CharSequence)from, Character.toString(to.charValue()))));
        if (sender instanceof Player && (papi = HookManager.getInstance().getHook(PlaceholderAPIHook.class)) != null) {
            return papi.applyPlaceholders((Player)sender, ChatColor.translateAlternateColorCodes((char)'&', (String)text.get()));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text.get());
    }

    public static boolean sendMessage(boolean prefix, CommandSender sender, String message) {
        sender.sendMessage(MessageUtils.fixColors(sender, (prefix ? ConfigManager.getInstance().getLegacyPrefix() : "") + "&f" + message));
        return false;
    }

    public static TextComponent formatString(CommandSender sender, String message) {
        TextComponent text = Component.empty();
        Pattern pattern = Pattern.compile("(https?://\\S+)");
        Matcher matcher = pattern.matcher(message);
        int lastEnd = 0;
        while (matcher.find()) {
            String before = message.substring(lastEnd, matcher.start());
            if (!before.isEmpty()) {
                text = (TextComponent)text.append((Component)Component.text((String)MessageUtils.fixColors(sender, before)));
            }
            String url = MessageUtils.fixColors(sender, matcher.group());
            text = (TextComponent)text.append(((TextComponent)Component.text((String)url).clickEvent(ClickEvent.openUrl((String)ChatColor.stripColor((String)url)))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)ConfigManager.getInstance().getPrefix().append((Component)Component.text((String)"Click to open url!")))));
            lastEnd = matcher.end();
        }
        String remainingText = MessageUtils.fixColors(sender, message.substring(lastEnd));
        if (!remainingText.isEmpty()) {
            text = (TextComponent)text.append((Component)Component.text((String)remainingText));
        }
        return text;
    }

    public static TextComponent createMessage(boolean bool, TextComponent message) {
        return bool ? (TextComponent)((TextComponent)Component.empty().append((Component)ConfigManager.getInstance().getPrefix())).append((Component)message) : message;
    }

    public static boolean isInteger(String string) {
        return Pattern.matches("-?[0-9]+", string.subSequence(0, string.length()));
    }

    public static String getDurationBreakdown(long duration, boolean showMS) {
        long minutes;
        long hours;
        if (duration <= 0L) {
            return showMS ? "0ms" : "0s";
        }
        StringBuilder sb = new StringBuilder();
        Duration d = Duration.ofMillis(duration);
        long days = d.toDays();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if ((hours = d.toHours() % 24L) > 0L) {
            sb.append(hours).append("h ");
        }
        if ((minutes = d.toMinutes() % 60L) > 0L) {
            sb.append(minutes).append("m ");
        }
        if (days > 0L) {
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        long seconds = d.toMillis() / 1000L % 60L;
        long millis = d.toMillis() % 1000L;
        if (seconds > 0L) {
            if (showMS && millis > 0L) {
                sb.append(seconds).append(",").append(millis).append("s");
            } else {
                sb.append(seconds).append("s");
            }
        } else if (showMS && millis > 0L) {
            sb.append(millis).append("ms");
        }
        return sb.toString();
    }

    static {
        MessageUtils.add("*", '\u2022');
        MessageUtils.add(">>", '\u00bb');
        MessageUtils.add("<<", '\u00ab');
    }
}

