/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.Language;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.Component;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.TextComponent;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.event.ClickEvent;
import xyz.lychee.lagfixer.libs.kyori.adventure.text.event.HoverEvent;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.utils.MessageUtils;

public class ConfigManager
extends AbstractManager
implements Listener {
    private static ConfigManager instance;
    private TextComponent prefix;

    public ConfigManager(LagFixer plugin) {
        super(plugin);
        instance = this;
    }

    @Override
    public void load() throws Exception {
        YamlConfiguration lang = Language.getYaml();
        File langFile = new File(this.getPlugin().getDataFolder(), "lang.yml");
        this.loadConfig((FileConfiguration)lang, langFile);
        Language.getMainValues().clear();
        lang.getConfigurationSection("messages.Main").getValues(true).forEach((key, val) -> {
            if (val instanceof String) {
                Language.getMainValues().put((String)key, (String)val);
            }
        });
        FileConfiguration config = this.getPlugin().getConfig();
        File configFile = new File(this.getPlugin().getDataFolder(), "config.yml");
        this.loadConfig(config, configFile);
        this.prefix = (TextComponent)MessageUtils.colors(null, config.getString("main.prefix", "")).clickEvent(ClickEvent.openUrl("https://bit.ly/lagfixer-spigot"));
        if (config.getBoolean("main.prefix_hover")) {
            TextComponent description = MessageUtils.colors(null, "&fLagFixer &e" + this.getPlugin().getDescription().getVersion() + "\n &8{*} &7Click to open plugin in spigotmc!");
            this.prefix = (TextComponent)this.prefix.hoverEvent(HoverEvent.showText(((TextComponent)Component.empty().append(this.prefix)).append(description)));
        }
    }

    private void loadConfig(FileConfiguration cfg, File file) {
        try {
            if (!file.exists()) {
                this.getPlugin().saveResource(file.getName(), false);
            }
            cfg.load(file);
            cfg.options().copyDefaults(true);
            cfg.save(file);
        }
        catch (IOException | InvalidConfigurationException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void disable() {
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public TextComponent getPrefix() {
        return this.prefix;
    }

    public static ConfigManager getInstance() {
        return instance;
    }
}

