/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.lagfixer.managers;

import com.google.common.collect.Iterators;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.bukkit.Bukkit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.lychee.lagfixer.LagFixer;
import xyz.lychee.lagfixer.managers.CommandManager;
import xyz.lychee.lagfixer.managers.SupportManager;
import xyz.lychee.lagfixer.managers.UpdaterManager;
import xyz.lychee.lagfixer.objects.AbstractManager;
import xyz.lychee.lagfixer.objects.AbstractMonitor;

public class ErrorsManager
extends AbstractManager {
    private static final Logger log = LoggerFactory.getLogger(ErrorsManager.class);
    private static ErrorsManager instance;
    private final Gson gson = new Gson();
    private final UUID uuid = UUID.randomUUID();
    private final HashMap<ThrowableKey, Error> errors = new HashMap();
    private final Pattern pattern = Pattern.compile("https://spark\\.lucko\\.me/.{10}");
    private final AbstractFilter filter;
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();

    public ErrorsManager(LagFixer plugin) {
        super(plugin);
        instance = this;
        this.filter = new AbstractFilter(){

            public Filter.Result filter(LogEvent event) {
                if (event.getLoggerName().equals(ErrorsManager.this.getPlugin().getLogger().getName())) {
                    return Filter.Result.NEUTRAL;
                }
                if (event.getThrown() != null) {
                    return ErrorsManager.this.checkError(event.getThrown()) ? Filter.Result.NEUTRAL : Filter.Result.DENY;
                }
                Matcher matcher = ErrorsManager.this.pattern.matcher(event.getMessage().getFormattedMessage());
                if (matcher.find()) {
                    ErrorsManager.this.sendProfiler(matcher.group());
                    ErrorsManager.this.getPlugin().getLogger().info("&7Spark profiler has been sent to our support to improve LagFixer optimizations and investigate what loads the server the most.");
                }
                return Filter.Result.NEUTRAL;
            }
        };
    }

    @Override
    public void load() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        if (!Iterators.contains((Iterator)logger.getFilters(), (Object)this.filter)) {
            logger.addFilter((Filter)this.filter);
        }
        this.executor.scheduleAtFixedRate(() -> {
            if (this.errors.values().stream().allMatch(Error::isReported)) {
                return;
            }
            this.sendStackTraces();
        }, 3L, 3L, TimeUnit.MINUTES);
        this.getPlugin().getLogger().info(" &8\u2022 &rStarted listening console for LagFixer errors!");
    }

    @Override
    public void disable() {
        this.executor.shutdownNow();
    }

    public boolean checkError(Throwable t) {
        if (t == null) {
            return true;
        }
        ThrowableKey key = new ThrowableKey(t);
        List<String> stackTrace = this.filterStackTrace(t);
        if (stackTrace.isEmpty() || this.errors.containsKey(key)) {
            return true;
        }
        StringBuilder message = new StringBuilder();
        message.append("LagFixer error message:\n");
        message.append("\n&8&m-------------------------------&r");
        message.append("\n");
        message.append("\n&fAn error occurred in lagfixer:");
        message.append("\n &7-> &c").append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
        for (String str : stackTrace) {
            message.append("\n &7| &c").append(str);
        }
        message.append("\n");
        message.append("\n&fOur support has been informed about it, it will be fixed soon.");
        message.append("\n&fMake sure the LagFixer configuration is done correctly.");
        message.append("\n&fIf you have any doubts, contact support: &nhttps://discord.gg/CFmzJjgZdu&r");
        message.append("\n");
        message.append("\n&8&m-------------------------------\n");
        this.getPlugin().getLogger().warning(message.toString());
        this.errors.put(key, new Error(stackTrace, t));
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.getPlugin().getConfig().getBoolean("main.errors_reporter");
    }

    public void sendStackTraces() {
        JsonObject jsonObject = this.createJson();
        JsonArray errorsArray = new JsonArray();
        for (Error error : this.errors.values()) {
            if (error.isReported()) continue;
            error.handle(errorsArray);
        }
        jsonObject.add("errors", (JsonElement)errorsArray);
        this.connect("/errors?plugin=" + this.getPlugin().getName(), jsonObject);
    }

    public void sendProfiler(String url) {
        JsonObject jsonObject = this.createJson();
        jsonObject.addProperty("profiler", url);
        this.connect("/profilers?plugin=" + this.getPlugin().getName(), jsonObject);
    }

    public void sendBenchmark(CommandManager.Benchmark benchmark) {
        JsonObject jsonObject = this.createJson();
        jsonObject.add("benchmark", this.gson.toJsonTree((Object)benchmark));
        this.connect("/benchmarks?plugin=" + this.getPlugin().getName(), jsonObject);
    }

    private JsonObject createJson() {
        UpdaterManager updater = UpdaterManager.getInstance();
        SupportManager support = SupportManager.getInstance();
        AbstractMonitor monitor = support.getMonitor();
        JsonObject jo = new JsonObject();
        jo.addProperty("bukkit", Bukkit.getName() + " " + Bukkit.getServer().getBukkitVersion());
        jo.addProperty("version", this.getPlugin().getDescription().getVersion());
        jo.addProperty("uuid", this.uuid.toString());
        jo.addProperty("entities", (Number)support.getEntities());
        jo.addProperty("creatures", (Number)support.getCreatures());
        jo.addProperty("items", (Number)support.getItems());
        jo.addProperty("projectiles", (Number)support.getProjectiles());
        jo.addProperty("vehicles", (Number)support.getVehicles());
        jo.addProperty("players", (Number)Bukkit.getOnlinePlayers().size());
        jo.addProperty("maxplayers", (Number)Bukkit.getMaxPlayers());
        jo.addProperty("cpuprocess", (Number)monitor.getCpuProcess());
        jo.addProperty("cpusystem", (Number)monitor.getCpuSystem());
        jo.addProperty("ramused", (Number)monitor.getRamUsed());
        jo.addProperty("ramtotal", (Number)monitor.getRamTotal());
        jo.addProperty("ramfree", (Number)monitor.getRamFree());
        jo.addProperty("tps", (Number)monitor.getTps());
        jo.addProperty("mspt", (Number)monitor.getMspt());
        jo.addProperty("current_version", updater.getCurrentVersion());
        jo.addProperty("latest_version", updater.getLatestVersion());
        jo.addProperty("difference_version", (Number)updater.getDifference());
        return jo;
    }

    private void connect(String params, JsonObject jsonObject) {
        try {
            HttpsURLConnection conn = (HttpsURLConnection)URI.create("https://api.sakuramc.pl" + params).toURL().openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:90.0) Gecko/20100101 Firefox/90.0");
            conn.setDoOutput(true);
            OutputStream os = conn.getOutputStream();
            os.write(this.gson.toJson((JsonElement)jsonObject).getBytes());
            os.flush();
            os.close();
            InputStream is = conn.getInputStream();
            is.close();
            conn.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private List<String> filterStackTrace(Throwable ex) {
        ArrayList<String> list = new ArrayList<String>();
        for (StackTraceElement e : ex.getStackTrace()) {
            if (!e.getClassName().contains("lagfixer")) continue;
            list.add(String.format("%s -> %s() at %d line", e.getFileName(), e.getMethodName(), e.getLineNumber()));
        }
        return list;
    }

    public Gson getGson() {
        return this.gson;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public HashMap<ThrowableKey, Error> getErrors() {
        return this.errors;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public AbstractFilter getFilter() {
        return this.filter;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public static ErrorsManager getInstance() {
        return instance;
    }

    public static final class ThrowableKey {
        private final Class<? extends Throwable> type;
        private final String message;
        private final ThrowableKey causeKey;

        public ThrowableKey(Throwable t) {
            this.type = t.getClass();
            this.message = t.getMessage();
            this.causeKey = t.getCause() == null ? null : new ThrowableKey(t.getCause());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ThrowableKey)) {
                return false;
            }
            ThrowableKey that = (ThrowableKey)o;
            return this.type.equals(that.type) && Objects.equals(this.message, that.message) && Objects.equals(this.causeKey, that.causeKey);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.message, this.causeKey);
        }

        public String toString() {
            return this.type.getSimpleName() + ": " + this.message + (this.causeKey != null ? " <- " + this.causeKey : "");
        }
    }

    public class Error {
        private final String message;
        private final String stackTrace;
        private final String fullStackTrace;
        private transient boolean reported;

        public Error(List<String> stackTrace, Throwable ex) {
            this.message = ex.getClass().getSimpleName() + ": " + ex.getMessage();
            this.stackTrace = String.join((CharSequence)"\n", stackTrace);
            this.fullStackTrace = ExceptionUtils.getStackTrace((Throwable)ex);
            this.reported = false;
        }

        public void handle(JsonArray arr) {
            arr.add(ErrorsManager.this.gson.toJsonTree((Object)this, Error.class));
            this.reported = true;
        }

        public String getMessage() {
            return this.message;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public String getFullStackTrace() {
            return this.fullStackTrace;
        }

        public boolean isReported() {
            return this.reported;
        }

        public void setReported(boolean reported) {
            this.reported = reported;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Error)) {
                return false;
            }
            Error other = (Error)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$stackTrace = this.getStackTrace();
            String other$stackTrace = other.getStackTrace();
            if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
                return false;
            }
            String this$fullStackTrace = this.getFullStackTrace();
            String other$fullStackTrace = other.getFullStackTrace();
            return !(this$fullStackTrace == null ? other$fullStackTrace != null : !this$fullStackTrace.equals(other$fullStackTrace));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Error;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            String $fullStackTrace = this.getFullStackTrace();
            result = result * 59 + ($fullStackTrace == null ? 43 : $fullStackTrace.hashCode());
            return result;
        }

        public String toString() {
            return "ErrorsManager.Error(message=" + this.getMessage() + ", stackTrace=" + this.getStackTrace() + ", fullStackTrace=" + this.getFullStackTrace() + ", reported=" + this.isReported() + ")";
        }
    }
}

