/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.ultraeffects.effect;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import powercyphe.ultraeffects.ModConfig;
import powercyphe.ultraeffects.effect.TickingEffect;
import powercyphe.ultraeffects.registry.ModSounds;
import powercyphe.ultraeffects.util.UltraEffectsUtil;

public class StyleMeterEffect
extends TickingEffect {
    public StyleRank styleRank = StyleRank.DESTRUCTIVE;
    public float style;
    public float drainPerSecond = 0.0f;
    public float threshold;
    public float nextThreshold = 0.0f;
    public static float styleMax = StyleMeterEffect.getNextThreshold(StyleRank.values()[StyleRank.values().length - 1]);
    public class_2371<class_3545<class_2561, Integer>> styleList = class_2371.method_10211();
    public class_2371<class_3545<class_2561, Float>> styleQueue = class_2371.method_10211();

    @Override
    public void display() {
    }

    @Override
    public void tick() {
        if (this.style > 0.0f) {
            this.style = class_3532.method_15363((float)(this.style - this.drainPerSecond / 20.0f), (float)0.0f, (float)styleMax);
            if (this.style < this.threshold) {
                this.updateStyleRank();
                this.style = this.threshold + (this.nextThreshold - this.threshold) * 0.7f;
            }
        }
        if (!this.styleQueue.isEmpty()) {
            class_3545 pair = (class_3545)this.styleQueue.removeFirst();
            this.style += ((Float)pair.method_15441()).floatValue();
            if (!((class_2561)pair.method_15442()).getString().isEmpty()) {
                if (this.styleList.size() > 6) {
                    this.styleList.remove(6);
                }
                this.styleList.addFirst((Object)new class_3545((Object)((class_2561)pair.method_15442()), (Object)140));
                if (this.shouldDisplay() && ModConfig.styleMeterSound) {
                    UltraEffectsUtil.playSound(ModSounds.STYLE_METER_CLICK, class_3419.field_15248, 1.0f, 0.25f);
                }
            }
            this.updateStyleRank();
        }
        ArrayList<class_3545> marked = new ArrayList<class_3545>();
        for (class_3545 pair : this.styleList) {
            int index = this.styleList.indexOf((Object)pair);
            int styleDuration = (Integer)pair.method_15441();
            if (--styleDuration <= 0) {
                marked.add(pair);
                continue;
            }
            pair.method_34965((Object)styleDuration);
            this.styleList.set(index, (Object)pair);
        }
        this.styleList.removeAll(marked);
    }

    public void addStyle(class_2561 text, float points) {
        this.styleQueue.add((Object)new class_3545((Object)text, (Object)Float.valueOf(points)));
    }

    public void updateStyleRank() {
        for (StyleRank rank : StyleRank.values()) {
            float requiredStyle = StyleMeterEffect.getThreshold(rank);
            if (!(this.style > requiredStyle)) continue;
            this.styleRank = rank;
            this.threshold = StyleMeterEffect.getThreshold(rank);
            this.nextThreshold = StyleMeterEffect.getNextThreshold(rank);
            this.drainPerSecond = rank.getDrainPerSecond();
        }
    }

    public boolean shouldDisplay() {
        if (class_310.method_1551().field_1705.method_53531().method_53536()) {
            return false;
        }
        ModConfig.StyleMeterDisplayCondition styleMeterDisplayCondition = ModConfig.styleMeterDisplayCondition;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ALWAYS", "ANY_STYLE", "POINTS_ONLY", "EVENTS_ONLY"}, (ModConfig.StyleMeterDisplayCondition)styleMeterDisplayCondition, n)) {
            case 0 -> true;
            case 1 -> {
                if (this.style > 0.0f || !this.styleList.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.style > 0.0f) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (!this.styleList.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public float getLineMultiplier() {
        if (this.style <= 0.0f) {
            return 0.0f;
        }
        return class_3532.method_15363((float)((this.style - this.threshold) / (this.nextThreshold - this.threshold)), (float)0.0f, (float)1.0f);
    }

    private static float getThreshold(@NotNull StyleRank rank) {
        float t = 0.0f;
        for (int index = 0; index < rank.getIndex(); ++index) {
            StyleRank r = StyleRank.fromIndex(index);
            if (r == null) continue;
            t += r.getThreshold();
        }
        return t;
    }

    private static float getNextThreshold(@NotNull StyleRank rank) {
        return StyleMeterEffect.getThreshold(rank) + rank.getThreshold();
    }

    public static enum StyleRank {
        DESTRUCTIVE(0, 103419, 200.0f, 15.0f),
        CHAOTIC(1, 5046016, 300.0f, 18.75f),
        BRUTAL(2, 16701440, 400.0f, 22.5f),
        ANARCHIC(3, 16738816, 500.0f, 30.0f),
        SUPREME(4, 0xFF0000, 700.0f, 45.0f),
        SSADISTIC(5, 0xFF0000, 850.0f, 60.0f),
        SSSHITSTORM(6, 0xFF0000, 1000.0f, 90.0f),
        ULTRAKILL(7, 16766720, 1500.0f, 120.0f);

        private final String id = this.name().toLowerCase();
        private final int index;
        private final int color;
        private final float threshold;
        private final float drainPerSecond;

        private StyleRank(int index, int color, float threshold, float drainPerSecond) {
            this.index = index;
            this.color = color;
            this.threshold = threshold;
            this.drainPerSecond = drainPerSecond;
        }

        public String getId() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }

        public int getColor() {
            return this.color;
        }

        public float getThreshold() {
            return this.threshold;
        }

        public float getDrainPerSecond() {
            return this.drainPerSecond;
        }

        public String getTranslationKey(boolean suffix) {
            return "ultraeffects.style_meter." + this.getId() + (suffix ? ".suffix" : ".prefix");
        }

        @Nullable
        public static StyleRank fromIndex(int index) {
            for (StyleRank rank : StyleRank.values()) {
                if (index != rank.getIndex()) continue;
                return rank;
            }
            return null;
        }
    }
}

