/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.ultraeffects.hud.state;

import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1306;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import powercyphe.ultraeffects.ModConfig;
import powercyphe.ultraeffects.hud.state.HotbarHudBarRenderState;
import powercyphe.ultraeffects.hud.state.HotbarHudCursorRenderState;
import powercyphe.ultraeffects.util.UltraEffectsUtil;

public class HotbarHudRenderState {
    public int x = 0;
    public int y = 0;
    public int overlayTick = 0;
    public int heldItemTooltipFade = 0;
    public boolean chatFocused = false;
    public HotbarHudBarRenderState healthBar = HotbarHudBarRenderState.DEFAULT;
    public HotbarHudBarRenderState absorptionBar = HotbarHudBarRenderState.DEFAULT;
    public HotbarHudBarRenderState staminaBar = HotbarHudBarRenderState.DEFAULT;
    public Optional<HotbarHudBarRenderState> experienceBar = Optional.empty();
    public HotbarHudCursorRenderState cursorRenderState = HotbarHudCursorRenderState.DEFAULT;
    public class_1661 playerInventory = null;
    public class_1799 offHandStack;

    public void render(class_332 context, class_327 textRenderer, float tickProgress) {
        if (this.shouldRender()) {
            this.renderBackground(context, textRenderer, this.x, this.y, tickProgress);
            this.renderBars(context, textRenderer, this.x, this.y, tickProgress);
            this.renderItems(context, textRenderer, this.x, this.y, tickProgress);
        }
        if (ModConfig.hotbarHudCursor) {
            this.cursorRenderState.render(context, textRenderer, tickProgress);
        }
    }

    public void renderBackground(class_332 context, class_327 textRenderer, int x, int y, float tickProgress) {
        int backgroundColor = this.adjustColor(class_9848.method_61324((int)((int)(ModConfig.hotbarHudBackgroundOpacity * 255.0f)), (int)ModConfig.hotbarHudBackgroundColorRed, (int)ModConfig.hotbarHudBackgroundColorGreen, (int)ModConfig.hotbarHudBackgroundColorBlue));
        UltraEffectsUtil.renderRoundBox(context, x, y - 4, x + 127, y - 26, backgroundColor);
        if (this.experienceBar.isPresent()) {
            UltraEffectsUtil.renderRoundBox(context, x, y - 96, x + 127, y - 109, backgroundColor);
        }
        UltraEffectsUtil.renderRoundBox(context, x, y - 27, x + 127, y - 95, backgroundColor);
        UltraEffectsUtil.renderRoundBox(context, x + 128, y - 27, x + 146, y - 95, backgroundColor);
        int selectedColor = this.adjustColor(class_9848.method_70658((int)backgroundColor, (float)0.65f));
        int outerColor = this.adjustColor(class_9848.method_70658((int)backgroundColor, (float)0.35f));
        context.method_25294(x + 129, y - 53, x + 145, y - 54, selectedColor);
        context.method_25294(x + 129, y - 70, x + 145, y - 71, selectedColor);
        context.method_25294(x + 129, y - 38, x + 145, y - 39, outerColor);
        context.method_25294(x + 129, y - 85, x + 145, y - 86, outerColor);
        UltraEffectsUtil.renderRoundBox(context, x + 128, y - 4, x + 146, y - 26, backgroundColor);
    }

    public void renderBars(class_332 context, class_327 textRenderer, int x, int y, float tickProgress) {
        this.healthBar.render(this, context, x + 4, y - 20, tickProgress, true);
        this.absorptionBar.render(this, context, x + 4, y - 20, tickProgress, false);
        this.staminaBar.render(this, context, x + 4, y - 10, tickProgress, true);
        this.experienceBar.ifPresent(experienceBar -> experienceBar.render(this, context, x + 4, y - 103, tickProgress, true));
        if (ModConfig.hotbarHudHealthNumberDisplay != ModConfig.HotbarHudHealthNumberDisplay.NEVER) {
            class_5250 healthText = class_2561.method_43470((String)("+" + String.valueOf(ModConfig.hotbarHudHealthNumberDisplay.healthGetter.apply((Object)this.healthBar, (Object)this.absorptionBar, (Object)Float.valueOf(tickProgress)))));
            context.method_51439(textRenderer, (class_2561)healthText, x + 6, y - 24, this.adjustColor(-1), false);
        }
    }

    public void renderItems(class_332 context, class_327 textRenderer, int x, int y, float tickProgress) {
        if (this.getVisibility() < 1.0f) {
            UltraEffectsUtil.setAlphaOverride(context, this.getVisibility());
        }
        if (this.playerInventory != null) {
            class_1799 mainHandStack = this.playerInventory.method_7391();
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)(x + 31), (float)y - 92.5f);
            context.method_51448().scale(4.0f, 4.0f);
            context.method_51427(mainHandStack, 0, 0);
            context.method_51448().popMatrix();
            for (int i = -2; i <= 2; ++i) {
                context.method_51448().pushMatrix();
                context.method_51448().translate((float)(x + 129), (float)(y - 70) + 16.0f * class_3532.method_15363((float)i, (float)-1.8f, (float)1.8f));
                if (i != 0) {
                    context.method_51448().translate((float)(2 * Math.abs(i)), (float)(2 * Math.abs(i)));
                    context.method_51448().scale(1.0f - Math.abs(0.25f * (float)i), 1.0f - Math.abs(0.25f * (float)i));
                }
                context.method_51427(this.getInventorySlot(this.playerInventory, i), 0, 0);
                context.method_51431(textRenderer, this.getInventorySlot(this.playerInventory, i), 0, 0);
                context.method_51448().popMatrix();
            }
            context.method_51448().pushMatrix();
            context.method_51427(this.offHandStack, x + 129, y - 23);
            context.method_51431(textRenderer, this.offHandStack, x + 129, y - 23);
            context.method_51448().popMatrix();
            if (!mainHandStack.method_7960()) {
                int displayAlpha;
                class_5250 mutableText = class_2561.method_43473().method_10852(mainHandStack.method_7964()).method_27692(mainHandStack.method_7932().method_58413());
                if (mainHandStack.method_57826(class_9334.field_49631)) {
                    mutableText.method_27692(class_124.field_1056);
                }
                int textWidth = textRenderer.method_27525((class_5348)mutableText);
                ModConfig.HotbarHudItemNameDisplay hotbarHudItemNameDisplay = ModConfig.hotbarHudItemNameDisplay;
                int n = 0;
                switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"ALWAYS", "NEVER"}, (ModConfig.HotbarHudItemNameDisplay)hotbarHudItemNameDisplay, n)) {
                    case 0: {
                        int n2 = 255;
                        break;
                    }
                    case 1: {
                        int n2 = 0;
                        break;
                    }
                    default: {
                        int n2 = displayAlpha = Math.min(255, (int)((float)this.heldItemTooltipFade * 256.0f / 10.0f));
                    }
                }
                if (displayAlpha > 0) {
                    context.method_51448().pushMatrix();
                    context.method_51448().translate((float)(x + 64), (float)(y - 92));
                    if (textWidth > 120) {
                        context.method_51448().scale(Math.max(0.25f, 1.0f - (float)(textWidth - 120) * 0.0065f));
                    }
                    context.method_27534(textRenderer, (class_2561)mutableText, 0, 0, class_9848.method_61330((int)displayAlpha, (int)-1));
                    context.method_51448().popMatrix();
                }
            }
        }
        UltraEffectsUtil.resetAlphaOverride(context);
    }

    public class_1799 getInventorySlot(class_1661 inventory, int offset) {
        int slot = inventory.method_67532() + offset;
        if (slot < 0) {
            slot = 9 + slot;
        } else if (slot > 8) {
            slot -= 9;
        }
        return (class_1799)inventory.method_67533().get(slot);
    }

    public int adjustColor(int color) {
        return class_9848.method_61330((int)((int)(this.getVisibility() * (float)class_9848.method_61320((int)color))), (int)color);
    }

    public float getVisibility() {
        if (this.chatFocused) {
            return switch (ModConfig.hotbarHudChatFocusModification) {
                default -> throw new MatchException(null, null);
                case ModConfig.HotbarHudChatFocusModification.SHIFTED_CHAT -> 1.0f;
                case ModConfig.HotbarHudChatFocusModification.TRANSPARENT_HUD -> 0.25f;
                case ModConfig.HotbarHudChatFocusModification.HIDDEN_HUD -> 0.0f;
            };
        }
        return 1.0f;
    }

    public boolean shouldRender() {
        return ModConfig.hotbarHudEnabled && this.getVisibility() > 0.0f && !UltraEffectsUtil.isRunningDeathScreenOverhaul();
    }

    public boolean shouldShiftChat(class_310 client) {
        return this.shouldRender() && !UltraEffectsUtil.isSpectator() && client.field_1690.method_42552().method_41753() == class_1306.field_6183;
    }
}

