/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.ultraeffects.util;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;
import powercyphe.ultraeffects.util.UltraEffectsUtil;

public class ComboHelper {
    public static class_2371<ComboInstance> COMBO_TYPES = class_2371.method_10211();
    public static ComboInstance MELEE = ComboHelper.register(new ComboInstance("melee", 30, 3, true, combo -> Float.valueOf(10.0f + class_3532.method_15363((float)((float)(combo - 2) * 15.0f), (float)0.0f, (float)100.0f))));
    public static ComboInstance PROJECTILE = ComboHelper.register(new ComboInstance("projectile", 0, 1, false, combo -> Float.valueOf(10.0f + class_3532.method_15363((float)((float)(combo - 2) * 20.0f), (float)0.0f, (float)100.0f))));
    public static ComboInstance KILL = ComboHelper.register(new ComboInstance("kill", 1, 2, false, combo -> Float.valueOf(10.0f + class_3532.method_15363((float)((float)(combo - 3) * 30.0f), (float)0.0f, (float)100.0f))));

    public static ComboInstance register(ComboInstance comboInstance) {
        COMBO_TYPES.add((Object)comboInstance);
        return comboInstance;
    }

    public static void tick() {
        for (ComboInstance comboInstance : COMBO_TYPES) {
            comboInstance.tick();
        }
    }

    public static class ComboInstance {
        private int combo = 0;
        private int ticks = 0;
        private class_1297 entity;
        private final String id;
        private final int defaultTicks;
        private final int required;
        private final boolean entityBound;
        private final Function<Integer, Float> pointCalculation;

        public ComboInstance(String id, int defaultTicks, int required, boolean entityBound, Function<Integer, Float> pointCalculation) {
            this.id = id;
            this.defaultTicks = defaultTicks;
            this.required = required;
            this.entityBound = entityBound;
            this.pointCalculation = pointCalculation;
        }

        public void tick() {
            if (this.ticks > 0) {
                --this.ticks;
                if (this.entityBound && this.entity != null && !this.entity.method_5805()) {
                    this.ticks = 0;
                }
            } else if (this.combo > 0) {
                this.reset();
            }
        }

        public boolean set(int combo) {
            this.combo = combo;
            this.ticks = this.defaultTicks;
            if (this.combo >= this.required) {
                UltraEffectsUtil.addStyle((class_2561)class_2561.method_43469((String)("ultraeffects.style_meter.style.combo_" + this.id), (Object[])new Object[]{this.combo}), this.pointCalculation.apply(this.combo).floatValue());
                return true;
            }
            return false;
        }

        public boolean increase(@Nullable class_1297 entity) {
            if (entity != null && this.entityBound && this.entity != entity) {
                this.combo = 0;
                this.entity = entity;
            }
            ++this.combo;
            this.ticks = this.defaultTicks;
            if (this.combo >= this.required) {
                UltraEffectsUtil.addStyle((class_2561)class_2561.method_43469((String)("ultraeffects.style_meter.style.combo_" + this.id), (Object[])new Object[]{this.combo}), this.pointCalculation.apply(this.combo).floatValue());
                return true;
            }
            return false;
        }

        public void reset() {
            this.combo = 0;
            this.ticks = 0;
            this.entity = null;
        }
    }
}

