/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.ultraeffects.util;

import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_418;
import net.minecraft.class_5819;
import net.minecraft.class_746;
import net.minecraft.class_9848;
import org.joml.Math;
import powercyphe.ultraeffects.ModConfig;
import powercyphe.ultraeffects.UltraEffectsClient;
import powercyphe.ultraeffects.registry.EffectRegistry;
import powercyphe.ultraeffects.sound.UnstoppableSoundInstance;
import powercyphe.ultraeffects.util.AlphaOverrideAddon;

public class UltraEffectsUtil {
    public static void renderHorizontalColoredBar(class_332 context, int x, int y, float progress, int fullWidth, int height, int color, int cuts, int cutWidth) {
        if (progress > 0.0f) {
            class_2371 cutPositions = class_2371.method_10211();
            if (cuts > 0 && cuts * cutWidth * 2 <= fullWidth) {
                float spacing = (float)fullWidth / (float)(cuts + 1);
                for (int i1 = 1; i1 <= cuts; ++i1) {
                    int cutStart = x + (int)Math.ceil((float)((float)i1 * spacing - (float)cutWidth / 2.0f));
                    for (int i2 = 0; i2 < cutWidth; ++i2) {
                        cutPositions.add((Object)(cutStart + i2));
                    }
                }
            }
            int width = (int)(progress * (float)fullWidth);
            int xStart = Math.min((int)x, (int)(x + width));
            int xEnd = Math.max((int)x, (int)(x + width));
            int topHeight = (int)Math.ceil((double)((double)height / 2.0));
            int bottomHeight = (int)Math.floor((double)((double)height / 2.0));
            while (x <= xEnd) {
                if (!cutPositions.contains((Object)x)) {
                    if (x - xStart < height / 3 || xEnd - x < height / 3) {
                        int distance = height / 3 - Math.min((int)Math.abs((int)(x - xStart)), (int)Math.abs((int)(xEnd - x)));
                        context.method_25294(x, y - (bottomHeight - distance), x + 1, y + (topHeight - distance), color);
                    } else {
                        context.method_25294(x, y - bottomHeight, x + 1, y + topHeight, color);
                    }
                }
                ++x;
            }
        }
    }

    public static void renderRoundBox(class_332 context, int x1, int y1, int x2, int y2, int color) {
        if (Math.abs((int)(x2 - x1)) < 3 || Math.abs((int)(y2 - y1)) < 3) {
            context.method_25294(x1, y1, x2, y2, color);
        } else {
            int boxXMin = Math.min((int)x1, (int)x2);
            int boxXMax = Math.max((int)x1, (int)x2);
            int boxYMin = Math.min((int)y1, (int)y2);
            int boxYMax = Math.max((int)y1, (int)y2);
            context.method_25294(boxXMin + 1, boxYMin + 1, boxXMax - 1, boxYMax - 1, color);
            context.method_25294(boxXMin + 2, boxYMin, boxXMax - 2, boxYMin + 1, color);
            context.method_25294(boxXMin + 2, boxYMax, boxXMax - 2, boxYMax - 1, color);
            context.method_25294(boxXMin, boxYMin + 2, boxXMin + 1, boxYMax - 2, color);
            context.method_25294(boxXMax, boxYMin + 2, boxXMax - 1, boxYMax - 2, color);
        }
    }

    public static void renderCircleBar(class_332 context, int x, int y, float progress, int startAngle, int angleLength, int cuts, int cutWidth, int color) {
        if (progress > 0.0f) {
            class_243 vec = new class_243(0.0, 6.0, 0.0);
            vec = vec.method_31033(Math.toRadians((float)(-startAngle)));
            class_2371 cutAngles = class_2371.method_10211();
            if (cuts > 0 && cuts * cutWidth <= Math.abs((int)angleLength)) {
                float spacing = (float)Math.abs((int)angleLength) / (float)(cuts + 1);
                for (int i = 1; i <= cuts; ++i) {
                    int centerAngle = Math.round((float)((float)i * spacing));
                    int startCut = centerAngle - cutWidth / 2;
                    for (int j = 0; j < cutWidth; ++j) {
                        cutAngles.add((Object)(startCut + j));
                    }
                }
            }
            int direction = angleLength >= 0 ? 1 : -1;
            int steps = (int)Math.abs((float)((float)angleLength * progress));
            for (int i = 0; i <= steps; ++i) {
                if (!cutAngles.contains((Object)i)) {
                    float circleX = (float)vec.method_10216();
                    float circleY = (float)vec.method_10214();
                    context.method_51448().pushMatrix();
                    context.method_51448().translate((float)x + circleX - 0.5f, (float)y + circleY - 0.5f);
                    context.method_51448().scale(0.2f);
                    context.method_25294(0, 0, (int)circleX + (circleX >= 0.0f ? 1 : -1), (int)circleY + (circleY >= 0.0f ? 1 : -1), color);
                    context.method_51448().popMatrix();
                }
                vec = vec.method_31033(Math.toRadians((float)direction));
            }
        }
    }

    public static void addStyle(String id, float points) {
        EffectRegistry.STYLE_METER_EFFECT.addStyle((class_2561)class_2561.method_43471((String)("ultraeffects.style_meter.style." + id)), points);
    }

    public static void addStyle(class_2561 text, float points) {
        EffectRegistry.STYLE_METER_EFFECT.addStyle(text, points);
    }

    public static List<class_2960> stringToIdentifierList(List<String> list) {
        class_2371 available = class_2371.method_10211();
        for (String str : list) {
            available.add((Object)UltraEffectsClient.id("textures/misc/" + str + ".png"));
        }
        return available;
    }

    public static void renderOverlay(class_332 ctx, class_2960 texture, float opacity) {
        int i = class_9848.method_61317((float)opacity);
        ctx.method_25291(class_10799.field_56883, texture, 0, 0, 0.0f, 0.0f, ctx.method_51421(), ctx.method_51443(), ctx.method_51421(), ctx.method_51443(), i);
    }

    public static void setAlphaOverride(class_332 context, float alphaOverride) {
        ((AlphaOverrideAddon)context).ultraeffects$setAlphaOverride(Float.valueOf(alphaOverride));
    }

    public static void resetAlphaOverride(class_332 context) {
        ((AlphaOverrideAddon)context).ultraeffects$setAlphaOverride(null);
    }

    public static void parryEffect(class_3414 sound, boolean configCondition) {
        UltraEffectsUtil.parryEffect(sound, configCondition, false);
    }

    public static void parryEffect(class_3414 sound, boolean configCondtion, boolean disableForTick) {
        if (!configCondtion || UltraEffectsClient.PARRY_DISABLED) {
            return;
        }
        if (disableForTick) {
            UltraEffectsClient.PARRY_DISABLED = true;
        }
        UltraEffectsUtil.playSound(sound, class_3419.field_15248, 0.9f + (float)class_5819.method_43047().method_43048(4) * 0.05f, 1.0f);
        EffectRegistry.FREEZE_EFFECT.display();
        EffectRegistry.FLASH_EFFECT.display();
    }

    public static boolean isRunningDeathScreenOverhaul() {
        return class_310.method_1551().field_1755 instanceof class_418 && ModConfig.deathScreenOverhaul;
    }

    public static boolean isClientPlayer(class_1297 entity) {
        class_310 client = class_310.method_1551();
        return client != null && client.field_1724 == entity;
    }

    public static boolean isSpectator() {
        class_746 clientPlayer = UltraEffectsUtil.getClientPlayer();
        if (clientPlayer != null) {
            return clientPlayer.method_7325();
        }
        return false;
    }

    public static class_746 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    public static void playSound(class_3414 soundEvent, class_3419 soundCategory, float pitch, float volume) {
        class_310.method_1551().method_1483().method_4873((class_1113)new UnstoppableSoundInstance(soundEvent, soundCategory, pitch, volume));
    }
}

