/*
 * Decompiled with CFR 0.152.
 */
package powercyphe.ultraeffects.hud;

import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_746;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import powercyphe.ultraeffects.ModConfig;
import powercyphe.ultraeffects.UltraEffectsClient;
import powercyphe.ultraeffects.hud.state.HotbarHudBarRenderState;
import powercyphe.ultraeffects.hud.state.HotbarHudCursorRenderState;
import powercyphe.ultraeffects.hud.state.HotbarHudRenderState;
import powercyphe.ultraeffects.mixin.accessor.InGameHudAccessor;
import powercyphe.ultraeffects.util.UltraEffectsUtil;
import squeek.appleskin.client.HUDOverlayHandler;
import squeek.appleskin.helpers.ConsumableFood;
import squeek.appleskin.helpers.FoodHelper;

public class HotbarHud
implements HudElement,
ClientTickEvents.StartTick {
    private class_327 textRenderer = null;
    private final HotbarHudRenderState hotbarHudState = new HotbarHudRenderState();

    public void render(class_332 context, class_9779 renderTickCounter) {
        if (this.textRenderer != null) {
            this.hotbarHudState.render(context, this.textRenderer, renderTickCounter.method_60637(true));
        }
    }

    public void onStartTick(class_310 client) {
        class_746 clientPlayer = UltraEffectsUtil.getClientPlayer();
        if (this.textRenderer == null) {
            this.textRenderer = client.field_1772;
        }
        if (clientPlayer != null) {
            for (BarType barType : BarType.values()) {
                barType.tick(clientPlayer);
            }
        }
        this.updateRenderState(client);
    }

    public int getX(class_310 client) {
        ModConfig.HotbarHudSide hotbarHudSide = ModConfig.hotbarHudSide;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"LEFT", "RIGHT"}, (ModConfig.HotbarHudSide)hotbarHudSide, n)) {
            case 0 -> 4;
            case 1 -> client.method_22683().method_4486() - 154;
            default -> client.field_1690.method_42552().method_41753() == class_1306.field_6183 ? 4 : client.method_22683().method_4486() - 154;
        };
    }

    public static HotbarHudRenderState getRenderState() {
        return UltraEffectsClient.HOTBAR_HUD.hotbarHudState;
    }

    public void updateRenderState(class_310 client) {
        class_746 clientPlayer = UltraEffectsUtil.getClientPlayer();
        if (ModConfig.hotbarHudEnabled || ModConfig.hotbarHudCursor) {
            FoodHelper.QueriedFoodResult result;
            float extraHealth = 0.0f;
            float extraHunger = 0.0f;
            if (UltraEffectsClient.HAS_APPLEKSKIN && clientPlayer != null && (result = HUDOverlayHandler.INSTANCE.heldFood.result(this.hotbarHudState.overlayTick, (class_1657)clientPlayer)) != null) {
                extraHealth = FoodHelper.getEstimatedHealthIncrement((class_1657)clientPlayer, (ConsumableFood)new ConsumableFood(result.modifiedFoodComponent, result.consumableComponent));
                extraHunger = result.modifiedFoodComponent.comp_2491();
            }
            this.hotbarHudState.healthBar = new HotbarHudBarRenderState(BarType.HEALTH, UltraEffectsClient.HAS_APPLEKSKIN, this.hotbarHudState.overlayTick, extraHealth, 118, 8, 0, 0);
            this.hotbarHudState.absorptionBar = new HotbarHudBarRenderState(BarType.ABSORPTION, (int)(118.0f * this.hotbarHudState.healthBar.getProgress(1.0f)), 8, 0, 0);
            this.hotbarHudState.staminaBar = new HotbarHudBarRenderState(BarType.HUNGER, UltraEffectsClient.HAS_APPLEKSKIN, this.hotbarHudState.overlayTick, extraHunger, 118, 8, 2, 2);
        }
        if (ModConfig.hotbarHudEnabled) {
            this.hotbarHudState.x = this.getX(client);
            this.hotbarHudState.y = client.method_22683().method_4502();
            ++this.hotbarHudState.overlayTick;
            if (this.hotbarHudState.overlayTick >= 50) {
                this.hotbarHudState.overlayTick = 0;
            }
            this.hotbarHudState.heldItemTooltipFade = ((InGameHudAccessor)client.field_1705).ultraeffects$getHeldItemToolTipFade();
            this.hotbarHudState.chatFocused = client.field_1705.method_1743().method_1819();
            if (clientPlayer != null) {
                this.hotbarHudState.playerInventory = clientPlayer.method_31548();
                this.hotbarHudState.offHandStack = clientPlayer.method_6079();
                Optional<Object> optional = this.hotbarHudState.experienceBar = clientPlayer.method_68878() ? Optional.empty() : Optional.of(new HotbarHudBarRenderState(BarType.EXPERIENCE, 118, 9, 15, 1));
            }
        }
        if (ModConfig.hotbarHudCursor) {
            float healthFade = this.hotbarHudState.cursorRenderState.healthFade();
            healthFade = this.hotbarHudState.healthBar.smoothedPrevious() != this.hotbarHudState.healthBar.smoothedCurrent() || this.hotbarHudState.absorptionBar.smoothedPrevious() != this.hotbarHudState.absorptionBar.smoothedCurrent() ? 20.0f : (healthFade *= 0.57f);
            float staminaFade = this.hotbarHudState.cursorRenderState.staminaFade();
            staminaFade = this.hotbarHudState.staminaBar.smoothedPrevious() != this.hotbarHudState.staminaBar.smoothedCurrent() ? 20.0f : (staminaFade *= 0.57f);
            this.hotbarHudState.cursorRenderState = new HotbarHudCursorRenderState(this.hotbarHudState.healthBar, this.hotbarHudState.absorptionBar, healthFade, this.hotbarHudState.staminaBar, staminaFade);
        }
    }

    public static enum BarType {
        HEALTH(class_1309::method_6032, class_1309::method_6063, 0xFE0000, 0xFF1313, () -> class_9848.method_61323((int)ModConfig.hotbarHudHealthColorRed, (int)ModConfig.hotbarHudHealthColorGreen, (int)ModConfig.hotbarHudHealthColorBlue)),
        ABSORPTION(class_1309::method_6067, class_1309::method_52541, 65281, 13938487, () -> class_9848.method_61323((int)ModConfig.hotbarHudAbsorptionColorRed, (int)ModConfig.hotbarHudAbsorptionColorGreen, (int)ModConfig.hotbarHudAbsorptionColorBlue)),
        HUNGER(clientPlayer -> Float.valueOf(clientPlayer.method_7344().method_7586()), clientPlayer -> Float.valueOf(20.0f), 56062, 10317123, () -> class_9848.method_61323((int)ModConfig.hotbarHudHungerColorRed, (int)ModConfig.hotbarHudHungerColorGreen, (int)ModConfig.hotbarHudHungerColorBlue)),
        EXPERIENCE(clientPlayer -> Float.valueOf(clientPlayer.field_7510 * (float)clientPlayer.method_7349()), clientPlayer -> Float.valueOf(clientPlayer.method_7349()), 11793277, 11793277, () -> class_9848.method_61323((int)ModConfig.hotbarHudExperienceColorRed, (int)ModConfig.hotbarHudExperienceColorGreen, (int)ModConfig.hotbarHudExperienceColorBlue));

        private final Function<class_746, Float> currentGetter;
        private final Function<class_746, Float> maxGetter;
        private final int ultrakillColor;
        private final int vanillaColor;
        private final Supplier<Integer> customColor;
        public float current = 0.0f;
        public float max = 0.0f;
        public float smoothedCurrent = 0.0f;
        public float smoothedPrevious = 0.0f;

        private BarType(Function<class_746, Float> currentGetter, Function<class_746, Float> maxGetter, int ultrakillColor, int vanillaColor, Supplier<Integer> customColor) {
            this.currentGetter = currentGetter;
            this.maxGetter = maxGetter;
            this.ultrakillColor = ultrakillColor;
            this.vanillaColor = vanillaColor;
            this.customColor = customColor;
        }

        public void tick(@NotNull class_746 player) {
            this.smoothedPrevious = this.smoothedCurrent;
            this.smoothedCurrent = BarType.getSmoothNumber(this.current, this.smoothedCurrent);
            this.current = this.currentGetter.apply(player).floatValue();
            this.max = this.maxGetter.apply(player).floatValue() > 0.0f ? this.maxGetter.apply(player).floatValue() : this.max;
        }

        public int getColor() {
            ModConfig.HotbarHudColors hotbarHudColors = ModConfig.hotbarHudColors;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"VANILLA", "CUSTOM"}, (ModConfig.HotbarHudColors)hotbarHudColors, n)) {
                case 0 -> class_9848.method_61334((int)this.vanillaColor);
                case 1 -> class_9848.method_61334((int)this.customColor.get());
                default -> class_9848.method_61334((int)this.ultrakillColor);
            };
        }

        public static float getSmoothNumber(float current, float smoothed) {
            if ((double)Math.abs((float)(current - smoothed)) < 0.1) {
                return current;
            }
            return Math.max((float)(smoothed + (current - smoothed) / 2.0f), (float)0.0f);
        }
    }
}

