/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.boat;

import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.client.render.boat.RenderModBoat;
import com.maidarch.srpcalamity.entity.boat.EntityModBoat;
import com.maidarch.srpcalamity.muon.CalamitySound;
import com.maidarch.srpcalamity.packet.PacketHandler;
import com.maidarch.srpcalamity.packet.packs.ChestBoatUpdatePacket;
import com.maidarch.srpcalamity.packet.packs.OpenChestBoatPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class EntityModChestBoat
extends EntityModBoat
implements IEntityMultiPart,
IInteractionObject {
    public final BoatChestPart chestPart;
    public final ChestInventory chestInventory = new ChestInventory();
    private static final float offset = 0.08f;
    private static final int containerSlots = 27;

    public EntityModChestBoat(World world) {
        super(world);
        if (world.field_72995_K) {
            RenderModBoat.setChestTexture();
        }
        this.chestPart = new BoatChestPart(this);
    }

    @ParametersAreNonnullByDefault
    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player.func_70093_af() && this.func_184219_q((Entity)player)) {
            if (!this.chestInventory.hasPlayerOpenChest && this.func_184188_bt().isEmpty()) {
                player.openGui((Object)SRPCalamity.instance, 3, this.field_70170_p, this.func_145782_y(), 0, 0);
            }
            return true;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.chestPart.ChestUpdateEffect();
    }

    public void func_70106_y() {
        this.chestPart.func_70106_y();
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K && this.field_70128_L) {
            this.chestInventory.dropAllChestInventory();
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float yOffset = (float)(this.func_70042_X() + passenger.func_70033_W());
            Vec3d vec3d = new Vec3d((double)0.08f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.field_70165_t + vec3d.field_72450_a, this.field_70163_u + (double)yOffset, this.field_70161_v + vec3d.field_72449_c);
            this.func_184454_a(passenger);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagCompound chestTag = new NBTTagCompound();
        this.chestInventory.writeToNBT(chestTag);
        compound.func_74782_a("ChestItems", (NBTBase)chestTag);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("ChestItems", 10)) {
            this.chestInventory.readFromNBT(compound.func_74775_l("ChestItems"));
        }
        if (!this.field_70170_p.field_72995_K) {
            this.chestInventory.syncChestContents();
        }
    }

    public void updateHasPlayerOpenChest(boolean hasPlayerOpenChest) {
        this.chestInventory.hasPlayerOpenChest = hasPlayerOpenChest;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new OpenChestBoatPacket(this.func_145782_y(), hasPlayerOpenChest), (Entity)this);
        }
    }

    public void openServerContainer(EntityPlayer player) {
        player.openGui((Object)SRPCalamity.instance, 3, this.field_70170_p, this.func_145782_y(), 0, 0);
    }

    public ContainerChestBoat getContainerChestBoat(EntityPlayer player) {
        return new ContainerChestBoat((IInventory)player.field_71071_by, this, player);
    }

    private void playOpenSound() {
        CalamitySound.playSound(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187657_V, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private void playCloseSound() {
        CalamitySound.playSound(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187651_T, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public Entity[] func_70021_al() {
        return new Entity[]{this.chestPart};
    }

    public String func_174875_k() {
        return "srpcalamity:chest_boat_gui";
    }

    public boolean func_145818_k_() {
        return this.chestInventory.func_145818_k_();
    }

    public boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() == 0;
    }

    public String func_70005_c_() {
        return I18n.func_135052_a((String)("entity." + this.getBoatName() + ".name"), (Object[])new Object[0]);
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        return this.func_70097_a(source, damage);
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer player) {
        return new ContainerChestBoat((IInventory)playerInventory, this, player);
    }

    public class ChestInventory
    extends InventoryBasic {
        public boolean hasPlayerOpenChest;

        public ChestInventory() {
            super(!EntityModChestBoat.this.field_70170_p.field_72995_K ? "chest.boat.inventory" : I18n.func_135052_a((String)"gui.srpcalamity.chestboat.name", (Object[])new Object[0]), false, 27);
        }

        public void writeToNBT(NBTTagCompound compound) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                NBTTagCompound itemTag = new NBTTagCompound();
                itemTag.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(itemTag);
                list.func_74742_a((NBTBase)itemTag);
            }
            compound.func_74782_a("Items", (NBTBase)list);
        }

        public void readFromNBT(NBTTagCompound compound) {
            NBTTagList list = compound.func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound itemTag = list.func_150305_b(i);
                int slot = itemTag.func_74771_c("Slot") & 0xFF;
                if (slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, new ItemStack(itemTag));
            }
        }

        public void chestMarkDirty() {
            if (!EntityModChestBoat.this.field_70170_p.field_72995_K) {
                this.syncChestContents();
            } else {
                this.requestServerSync();
            }
        }

        private void syncChestContents() {
            NBTTagCompound nbt = new NBTTagCompound();
            EntityModChestBoat.this.chestInventory.writeToNBT(nbt);
            ItemStack syncStack = new ItemStack((Block)Blocks.field_150486_ae);
            syncStack.func_77982_d(nbt);
            PacketHandler.INSTANCE.sendToAllTracking((IMessage)new ChestBoatUpdatePacket(EntityModChestBoat.this.func_145782_y(), syncStack), new NetworkRegistry.TargetPoint(EntityModChestBoat.this.field_70170_p.field_73011_w.getDimension(), EntityModChestBoat.this.field_70165_t, EntityModChestBoat.this.field_70163_u, EntityModChestBoat.this.field_70161_v, 64.0));
        }

        private void requestServerSync() {
            NBTTagCompound nbt = new NBTTagCompound();
            EntityModChestBoat.this.chestInventory.writeToNBT(nbt);
            ItemStack requestStack = new ItemStack((Block)Blocks.field_150486_ae);
            requestStack.func_77982_d(nbt);
            PacketHandler.INSTANCE.sendToServer((IMessage)new ChestBoatUpdatePacket(EntityModChestBoat.this.func_145782_y(), requestStack));
        }

        public void updateChestVisuals(ItemStack stack) {
            if (EntityModChestBoat.this.field_70170_p.field_72995_K && stack.func_77978_p() != null) {
                EntityModChestBoat.this.chestInventory.readFromNBT(stack.func_77978_p());
            }
        }

        public void validateAndUpdateContents(ItemStack stack) {
            if (!EntityModChestBoat.this.field_70170_p.field_72995_K) {
                EntityModChestBoat.this.chestInventory.readFromNBT(stack.func_77978_p());
                this.syncChestContents();
            }
        }

        private void dropAllChestInventory() {
            for (int i = 0; i < EntityModChestBoat.this.chestInventory.func_70302_i_(); ++i) {
                ItemStack stack = EntityModChestBoat.this.chestInventory.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                EntityModChestBoat.this.field_70170_p.func_72838_d((Entity)new EntityItem(EntityModChestBoat.this.field_70170_p, EntityModChestBoat.this.field_70165_t, EntityModChestBoat.this.field_70163_u, EntityModChestBoat.this.field_70161_v, stack));
            }
        }
    }

    public static class ContainerChestBoat
    extends ContainerChest {
        private final EntityModChestBoat chestBoat;

        public ContainerChestBoat(IInventory playerInventory, EntityModChestBoat chestBoat, EntityPlayer player) {
            super(playerInventory, (IInventory)chestBoat.chestInventory, player);
            this.chestBoat = chestBoat;
            this.chestBoat.updateHasPlayerOpenChest(true);
        }

        public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
            return super.func_82846_b(playerIn, index);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return true;
        }

        public void func_75134_a(EntityPlayer player) {
            super.func_75134_a(player);
            this.chestBoat.updateHasPlayerOpenChest(false);
            this.chestBoat.chestInventory.chestMarkDirty();
        }
    }

    public class BoatChestPart
    extends MultiPartEntityPart {
        public float lidAngle;
        public float prevLidAngle;

        public BoatChestPart(EntityModChestBoat parentBoat) {
            super((IEntityMultiPart)parentBoat, "chest", 0.0f, 0.0f);
        }

        public void ChestUpdateEffect() {
            if (!EntityModChestBoat.this.func_184188_bt().isEmpty() && this.lidAngle == 0.0f) {
                return;
            }
            this.prevLidAngle = this.lidAngle;
            if (EntityModChestBoat.this.chestInventory.hasPlayerOpenChest) {
                if (this.lidAngle == 0.0f) {
                    EntityModChestBoat.this.playOpenSound();
                }
                this.lidAngle = this.lidAngle < 1.0f ? (this.lidAngle += 0.1f) : 1.0f;
            } else if (this.lidAngle > 0.001f) {
                this.lidAngle -= 0.1f;
                if (this.lidAngle < 0.5f && this.prevLidAngle >= 0.5f) {
                    EntityModChestBoat.this.playCloseSound();
                }
            } else {
                this.lidAngle = 0.0f;
            }
        }

        public float getLidAngle(float partialTicks) {
            return this.prevLidAngle + (this.lidAngle - this.prevLidAngle) * partialTicks;
        }

        public Vec3d getChestOffset() {
            return new Vec3d(-0.375, EntityModChestBoat.this.func_70042_X() + 0.28, 0.0).func_178785_b(-this.field_70177_z * 0.0175f - 1.5707964f);
        }

        public void func_70071_h_() {
        }
    }
}

