/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.ancient;

import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIFlightAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIFlightLimits;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPAncient;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPAttributes;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.maidarch.srpcalamity.entity.projectile.EntityBombMikan;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityMikan
extends EntityPAncient {
    protected static final DataParameter<Byte> GHAST_FLAGS = EntityDataManager.func_187226_a(EntityMikan.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityMikan(World worldIn) {
        super(worldIn);
        this.field_70765_h = new AIMoveControl(this);
        this.func_70105_a(7.4f, 8.8f);
        this.func_189654_d(true);
        if (CalamityConfigMobs.mikanMaxY != 256) {
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlightLimits((EntityParasiteBase)this, CalamityConfigMobs.mikanMaxY, true));
        }
        this.field_70728_aV = SRPAttributes.XP_ANCIENT;
        this.canD = false;
    }

    public int getParasiteIDRegister() {
        return 2289;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFlightAttack((EntityParasiteBase)this, SRPConfig.ancientFollow * 2.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIChargeAttack());
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIBomb((EntityParasiteBase)this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFlightLimits((EntityParasiteBase)this, 10, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFlightLimits((EntityParasiteBase)this, 25, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.MIKAN_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(CalamityAttributes.MIKAN_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(CalamityAttributes.MIKAN_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.MIKAN_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.ancientFollow * 2.0);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_mikan);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70122_E) {
                this.field_70765_h.func_75642_a(this.field_70165_t, this.field_70163_u + 5.0, this.field_70161_v, 0.5);
            }
            if (this.srpTicks == 10 && (this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(1)).func_177230_c() != Blocks.field_150350_a || this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(2)).func_177230_c() != Blocks.field_150350_a) && this.func_70638_az() != null) {
                this.field_70181_x = 0.5;
            }
        } else if (this.field_70146_Z.nextInt(30) == 0) {
            for (int i = 0; i <= 20; ++i) {
                if (i % 5 != 0) continue;
                this.spawnParticlesGoreMouth(SRPEnumParticle.GSPLASH, 0, -1, -1, 0.2, 0.0);
            }
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_189654_d(true);
    }

    public boolean scaryOrbEffect(EntityLivingBase in, int mobs) {
        boolean flag = super.scaryOrbEffect(in, mobs);
        if (flag) {
            ParasiteEventEntity.orbApplyEffects((EntityLivingBase)in, (EntityParasiteBase)this, (String[])CalamityConfigMobs.mikanOrbEffects, (int)mobs);
        }
        return flag;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public float func_70047_e() {
        return 2.4f;
    }

    @ParametersAreNonnullByDefault
    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GHAST_FLAGS, (Object)0);
    }

    public static void registerFixesMikan(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityMikan.class);
    }

    private boolean getGhastFlag() {
        byte i = (Byte)this.field_70180_af.func_187225_a(GHAST_FLAGS);
        return (i & 1) != 0;
    }

    private void setGhastFlag(boolean value) {
        int i = ((Byte)this.field_70180_af.func_187225_a(GHAST_FLAGS)).byteValue();
        i = value ? (i |= 1) : (i &= 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(GHAST_FLAGS, (Object)((byte)(i & 0xFF)));
    }

    public boolean isCharging() {
        return this.getGhastFlag();
    }

    public void setCharging(boolean charging) {
        this.setGhastFlag(charging);
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityMikan ghast) {
            super((EntityLiving)ghast);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityMikan.this.field_70165_t;
                double d1 = this.field_75647_c - EntityMikan.this.field_70163_u;
                double d2 = this.field_75644_d - EntityMikan.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityMikan.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityMikan var10000 = EntityMikan.this;
                    var10000.field_70159_w *= 0.5;
                    var10000.field_70181_x *= 0.5;
                    var10000.field_70179_y *= 0.5;
                } else {
                    EntityMikan var10000 = EntityMikan.this;
                    var10000.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    var10000.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    var10000.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityMikan.this.func_70638_az() == null) {
                        EntityMikan.this.field_70761_aq = EntityMikan.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityMikan.this.field_70159_w, (double)EntityMikan.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityMikan.this.func_70638_az().field_70165_t - EntityMikan.this.field_70165_t;
                        double d5 = EntityMikan.this.func_70638_az().field_70161_v - EntityMikan.this.field_70161_v;
                        EntityMikan.this.field_70761_aq = EntityMikan.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !EntityMikan.this.func_70605_aq().func_75640_a() && EntityMikan.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityMikan.this);
            int flag = 1;
            double speed = 0.1;
            if (EntityMikan.this.func_70638_az() != null) {
                if (EntityMikan.this.func_70068_e((Entity)EntityMikan.this.func_70638_az()) > 100.0) {
                    blockpos = new BlockPos((Entity)EntityMikan.this.func_70638_az());
                    flag = 2;
                    speed += 0.05;
                } else if (EntityMikan.this.func_70068_e((Entity)EntityMikan.this.func_70638_az()) < 36.0) {
                    blockpos = new BlockPos((Entity)EntityMikan.this.func_70638_az());
                    flag = 3;
                    speed += 0.05;
                }
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityMikan.this.field_70146_Z.nextInt(15) - 7, EntityMikan.this.field_70146_Z.nextInt(11) - 5, EntityMikan.this.field_70146_Z.nextInt(15) - 7);
                if (flag == 2) {
                    blockpos1 = blockpos.func_177982_a(EntityMikan.this.field_70146_Z.nextInt(6) - 2, EntityMikan.this.field_70146_Z.nextInt(7) - 2, EntityMikan.this.field_70146_Z.nextInt(6) - 2);
                } else if (flag == 3) {
                    blockpos1 = blockpos.func_177982_a(EntityMikan.this.field_70146_Z.nextInt(4) + 3, EntityMikan.this.field_70146_Z.nextInt(5) + 4, EntityMikan.this.field_70146_Z.nextInt(4) + 3);
                }
                if (!EntityMikan.this.field_70170_p.func_175623_d(blockpos1)) continue;
                EntityMikan.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 1.0, (double)blockpos1.func_177952_p() + 0.5, speed);
                if (EntityMikan.this.func_70638_az() != null) break;
                EntityMikan.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 1.0, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    class AIChargeAttack
    extends EntityAIBase {
        public AIChargeAttack() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            if (EntityMikan.this.func_70638_az() != null && EntityMikan.this.field_70146_Z.nextInt(5) == 0) {
                return EntityMikan.this.func_70068_e((Entity)EntityMikan.this.func_70638_az()) > 4.0;
            }
            return false;
        }

        public boolean func_75253_b() {
            return EntityMikan.this.func_70605_aq().func_75640_a() && EntityMikan.this.isCharging() && EntityMikan.this.func_70638_az() != null && EntityMikan.this.func_70638_az().func_70089_S();
        }

        public void func_75249_e() {
            EntityLivingBase entitylivingbase = EntityMikan.this.func_70638_az();
            Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
            EntityMikan.this.field_70765_h.func_75642_a(vec3d.field_72450_a, entitylivingbase.field_70163_u + 20.0, vec3d.field_72449_c, 0.2);
            EntityMikan.this.setCharging(true);
        }

        public void func_75251_c() {
            EntityMikan.this.setCharging(false);
        }

        public void func_75246_d() {
            EntityLivingBase entitylivingbase = EntityMikan.this.func_70638_az();
            if (entitylivingbase != null && entitylivingbase.func_70089_S()) {
                if (EntityMikan.this.func_174813_aQ().func_72326_a(entitylivingbase.func_174813_aQ())) {
                    EntityMikan.this.func_70652_k((Entity)entitylivingbase);
                    EntityMikan.this.setCharging(false);
                } else {
                    double d0 = EntityMikan.this.func_70068_e((Entity)entitylivingbase);
                    if (d0 < 9.0) {
                        Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                        EntityMikan.this.field_70765_h.func_75642_a(vec3d.field_72450_a, entitylivingbase.field_70163_u + 20.0, vec3d.field_72449_c, 1.0);
                    } else {
                        Vec3d vec3d = entitylivingbase.func_174824_e(1.0f);
                        EntityMikan.this.field_70765_h.func_75642_a(vec3d.field_72450_a, entitylivingbase.field_70163_u + 20.0, vec3d.field_72449_c, 1.1);
                    }
                }
            }
        }
    }

    static class AIBomb
    extends EntityAIBase {
        private final EntityParasiteBase parent;
        private int ccc;

        public AIBomb(EntityParasiteBase parentIn) {
            this.parent = parentIn;
            this.ccc = 0;
        }

        public boolean func_75250_a() {
            ++this.ccc;
            if (this.ccc >= 100) {
                this.ccc = 0;
                if (this.parent.func_70638_az() != null) {
                    EntityLivingBase target = this.parent.func_70638_az();
                    if (!target.field_70122_E) {
                        this.ccc = 70;
                        return false;
                    }
                    if (target.func_70092_e(this.parent.field_70165_t, target.field_70163_u, this.parent.field_70161_v) < 256.0) {
                        return true;
                    }
                }
            }
            return false;
        }

        public void func_75246_d() {
            EntityBombMikan out = new EntityBombMikan(this.parent.field_70170_p, this.parent, CalamityConfigMobs.mikanGriefing);
            if (this.parent.func_70638_az() != null) {
                boolean flag = this.parent.func_70685_l((Entity)this.parent.func_70638_az()) || this.parent.field_70170_p.field_73012_v.nextInt(3) == 0;
                out.func_82149_j((Entity)this.parent);
                out.setFuse(80);
                out.setStren(flag ? 8.0f : 16.0f);
                out.setSkin(flag ? 2 : 3);
                out.setDamage((float)this.parent.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e() * CalamityConfigMobs.mikanExplotionMult, 15);
                this.parent.field_70170_p.func_72838_d((Entity)out);
                out.updateSTR();
            }
        }
    }
}

