/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.infected;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPFeral;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPInfected;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPPotions;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerSquidG;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfSquidGHead;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityInfSquidG
extends EntityPInfected {
    private static final DataParameter<Integer> DATA_DARK_TICKS_REMAINING = EntityDataManager.func_187226_a(EntityInfSquidG.class, (DataSerializer)DataSerializers.field_187192_b);
    public float squidPitch;
    public float prevSquidPitch;
    public float squidYaw;
    public float prevSquidYaw;
    public float squidRotation;
    public float prevSquidRotation;
    private float randomMotionSpeed;
    private float rotationVelocity;
    private float rotateSpeed;
    private float randomMotionVecX;
    private float randomMotionVecY;
    private float randomMotionVecZ;

    public EntityInfSquidG(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70146_Z.setSeed(1 + this.func_145782_y());
        this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    public int getParasiteIDRegister() {
        return 2155;
    }

    public int canSpawnByIDData() {
        return CalamityConfigMobs.infsquidgCanSpawnAssimilatedNat;
    }

    public EntityPFeral getFeral() {
        return new EntityFerSquidG(this.field_70170_p);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 0;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public static void registerFixesInfSquidG(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityInfSquidG.class);
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIMoveRandomAttack(this, 2.0, SRPConfig.infectedFollow, 40));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom(this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.INFSQUIDG_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(CalamityAttributes.INFSQUIDG_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(CalamityAttributes.INFSQUIDG_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.INFSQUIDG_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.infectedFollow);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_infsquidg);
    }

    protected void selfExplode() {
        super.selfExplode();
        ParasiteEventEntity.spawnM((EntityParasiteBase)this, (String[])new String[]{CalamityConfigMobs.infsquidgmob}, (int)0, (boolean)false, (String)this.func_95999_t());
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184601_bQ(DamageSource p_getHurtSound_1_) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.growStage();
        int darkTicksRemaining = this.getDarkTicksRemaining();
        if (darkTicksRemaining > 0) {
            this.setDarkTicks(darkTicksRemaining - 1);
        }
        this.func_184589_d(MobEffects.field_188423_x);
        this.prevSquidPitch = this.squidPitch;
        this.prevSquidYaw = this.squidYaw;
        this.prevSquidRotation = this.squidRotation;
        this.squidRotation += this.rotationVelocity;
        if ((double)this.squidRotation > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.squidRotation = (float)Math.PI * 2;
            } else {
                this.squidRotation = (float)((double)this.squidRotation - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.rotationVelocity = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)this, (byte)19);
            }
        }
        if (this.field_70171_ac) {
            float f1;
            if (this.squidRotation < (float)Math.PI) {
                f1 = this.squidRotation / (float)Math.PI;
                if ((double)f1 > 0.75) {
                    this.randomMotionSpeed = 1.0f;
                    this.rotateSpeed = 1.0f;
                } else {
                    this.rotateSpeed *= 0.8f;
                }
            } else {
                this.randomMotionSpeed *= 0.9f;
                this.rotateSpeed *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = this.randomMotionVecX * this.randomMotionSpeed;
                this.field_70181_x = this.randomMotionVecY * this.randomMotionSpeed;
                this.field_70179_y = this.randomMotionVecZ * this.randomMotionSpeed;
            }
            f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.squidYaw = (float)((double)this.squidYaw + Math.PI * (double)this.rotateSpeed * 1.5);
            this.squidPitch += (-((float)MathHelper.func_181159_b((double)f1, (double)this.field_70181_x)) * 57.295776f - this.squidPitch) * 0.1f;
        } else {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70159_w = 0.0;
                this.field_70179_y = 0.0;
                if (this.func_70644_a(MobEffects.field_188424_y)) {
                    this.field_70181_x += 0.05 * (double)(Objects.requireNonNull(this.func_70660_b(MobEffects.field_188424_y)).func_76458_c() + 1) - this.field_70181_x;
                } else if (!this.func_189652_ae()) {
                    this.field_70181_x -= 0.08;
                }
                this.field_70181_x *= (double)0.98f;
            }
            this.squidPitch = (float)((double)this.squidPitch + (double)(-90.0f - this.squidPitch) * 0.02);
        }
    }

    protected void growStage() {
        if (!this.field_70170_p.field_72995_K && ParasiteEventEntity.canSpawnNext && this.killcount >= CalamityConfigMobs.feralKills) {
            ParasiteEventEntity.spawnNext((EntityParasiteBase)this, (EntityParasiteBase)new EntityFerSquidG(this.field_70170_p), (boolean)true, (boolean)true);
        }
    }

    protected void func_70609_aI() {
        super.func_70609_aI();
        if (this.field_70725_aQ == 20 && !this.field_70170_p.field_72995_K && this.field_70146_Z.nextDouble() <= CalamityAttributes.INFSQUIDG_HEADCHANCE) {
            EntityInfSquidGHead out = new EntityInfSquidGHead(this.field_70170_p);
            out.func_82149_j((Entity)this);
            out.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), null);
            out.setSkin(this.getSkin());
            out.cannotDespawn(false);
            this.field_70170_p.func_72838_d((Entity)out);
        }
    }

    public void func_191986_a(float p_travel_1_, float p_travel_2_, float p_travel_3_) {
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_DARK_TICKS_REMAINING, (Object)0);
    }

    @ParametersAreNonnullByDefault
    public boolean func_70097_a(DamageSource pSource, float pAmount) {
        boolean $$2 = super.func_70097_a(pSource, pAmount);
        if ($$2) {
            this.setDarkTicks(100);
        }
        return $$2;
    }

    private void setDarkTicks(int pDarkTicks) {
        this.field_70180_af.func_187227_b(DATA_DARK_TICKS_REMAINING, (Object)pDarkTicks);
    }

    public int getDarkTicksRemaining() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_DARK_TICKS_REMAINING);
    }

    @ParametersAreNonnullByDefault
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("DarkTicksRemaining", this.getDarkTicksRemaining());
    }

    @ParametersAreNonnullByDefault
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setDarkTicks(compound.func_74762_e("DarkTicksRemaining"));
    }

    public boolean func_70601_bi() {
        return this.field_70163_u <= (double)(this.field_70170_p.func_181545_F() - 33) && this.field_70170_p.func_175724_o(this.func_180425_c()) == 0.0f && this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() == Blocks.field_150355_j;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte b) {
        if (b == 19) {
            this.squidRotation = 0.0f;
        } else {
            super.func_70103_a(b);
        }
    }

    public void setMovementVector(float vx, float vy, float vz) {
        this.randomMotionVecX = vx;
        this.randomMotionVecY = vy;
        this.randomMotionVecZ = vz;
    }

    @ParametersAreNonnullByDefault
    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (!CalamityConfigMobs.infsquidgGlowEnabled) {
            return;
        }
        if (entityIn instanceof EntityLivingBase && !(entityIn instanceof EntityInfSquidG) && !(entityIn instanceof EntityInfSquidGHead) && !(entityIn instanceof EntityFerSquidG)) {
            SRPPotions.applyStackPotion((Potion)MobEffects.field_188423_x, (EntityLivingBase)((EntityLivingBase)entityIn), (int)20, (int)0);
        }
    }

    public boolean hasNoMovementVector() {
        return this.randomMotionVecX == 0.0f && this.randomMotionVecY == 0.0f && this.randomMotionVecZ == 0.0f;
    }

    static class AIMoveRandomAttack
    extends EntityAIBase {
        private final EntityInfSquidG squid;
        protected int attackTick;
        private final double attack;
        private final double track;
        private int cooldown;
        private final int currentCD;

        public AIMoveRandomAttack(EntityInfSquidG squidmob, double attackD, double tracking, int CD) {
            this.squid = squidmob;
            this.attack = attackD * attackD;
            this.track = tracking * tracking;
            this.cooldown = 0;
            this.currentCD = CD;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            EntityLivingBase enemy = this.squid.func_70638_az();
            if (enemy != null) {
                if (!enemy.func_70089_S()) {
                    this.squid.func_70624_b(null);
                    return;
                }
                if (!this.squid.func_70090_H()) {
                    return;
                }
                int i = this.squid.func_70654_ax();
                if (i > 100) {
                    this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
                } else if (this.squid.func_70681_au().nextInt(5) == 0 || !this.squid.field_70171_ac || this.squid.hasNoMovementVector()) {
                    float f1 = (float)MathHelper.func_181159_b((double)(enemy.field_70161_v - this.squid.field_70161_v), (double)(enemy.field_70165_t - this.squid.field_70165_t));
                    float f2 = MathHelper.func_76134_b((float)f1) * 0.4f;
                    float f3 = (float)(this.squid.field_70163_u < enemy.field_70163_u ? 1 : -1) * this.squid.func_70681_au().nextFloat() * 0.4f;
                    float f4 = MathHelper.func_76126_a((float)f1) * 0.4f;
                    this.squid.setMovementVector(f2, f3, f4);
                }
                if (++this.cooldown >= this.currentCD) {
                    this.squid.func_70671_ap().func_75651_a((Entity)enemy, 30.0f, 30.0f);
                    double d0 = this.squid.func_70092_e(enemy.field_70165_t, enemy.func_174813_aQ().field_72338_b, enemy.field_70161_v);
                    if (this.squid.func_70068_e((Entity)enemy) < this.track && this.squid.func_70685_l((Entity)enemy)) {
                        this.attackTick = Math.max(this.attackTick - 1, 0);
                        if (d0 <= this.attack && this.attackTick <= 0) {
                            this.attackTick = 20;
                            this.squid.func_70652_k((Entity)enemy);
                        }
                        if (this.cooldown > 140) {
                            this.cooldown = 0;
                        }
                    }
                }
            }
        }
    }

    static class AIMoveRandom
    extends EntityAIBase {
        private final EntityInfSquidG squid;

        public AIMoveRandom(EntityInfSquidG squidmob) {
            this.squid = squidmob;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.squid.func_70654_ax();
            if (i > 100) {
                this.squid.setMovementVector(0.0f, 0.0f, 0.0f);
            } else if (this.squid.func_70681_au().nextInt(50) == 0 || !this.squid.field_70171_ac || this.squid.hasNoMovementVector()) {
                float f1 = this.squid.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f2 = MathHelper.func_76134_b((float)f1) * 0.2f;
                float f3 = -0.1f + this.squid.func_70681_au().nextFloat() * 0.2f;
                float f4 = MathHelper.func_76126_a((float)f1) * 0.2f;
                this.squid.setMovementVector(f2, f3, f4);
            }
        }
    }
}

