/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.feature;

import com.maidarch.srpcalamity.feature.DictCtrler;
import com.maidarch.srpcalamity.feature.ExtraDrops;
import com.maidarch.srpcalamity.feature.ExtraHead;
import com.maidarch.srpcalamity.feature.Feature;
import com.maidarch.srpcalamity.feature.FeralTrans;
import com.maidarch.srpcalamity.feature.LarvaBottleCatched;
import com.maidarch.srpcalamity.feature.MobEatAspic;
import com.maidarch.srpcalamity.feature.ProbabilityBonus;
import com.maidarch.srpcalamity.feature.ReaperHeadCut;
import com.maidarch.srpcalamity.feature.WandTrans;
import com.maidarch.srpcalamity.feature.touhou.KoishiHatDrop;
import com.maidarch.srpcalamity.feature.touhou.YuyukoFanDrop;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import com.maidarch.srpcalamity.util.config.CalamityConfigTouhou;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Module {
    public static final List<Runnable> lazyOreDictRegisters = new ArrayList<Runnable>();

    public void addFeatures() {
        this.registerFeature(new LarvaBottleCatched());
        if (CalamityConfigMobs.extraLootEnabled) {
            this.registerFeature(new ExtraDrops());
        }
        this.registerFeature(new DictCtrler());
        this.registerFeature(new MobEatAspic());
        this.registerFeature(new FeralTrans());
        this.registerFeature(new ReaperHeadCut());
        this.registerFeature(new ExtraHead());
        this.registerFeature(new ProbabilityBonus());
        this.registerFeature(new WandTrans());
        if (CalamityConfigTouhou.TouhouDropsEnabled) {
            if (CalamityConfigTouhou.yuyukoEnabled) {
                this.registerFeature(new YuyukoFanDrop());
            }
            if (CalamityConfigTouhou.koishiEnabled) {
                this.registerFeature(new KoishiHatDrop());
            }
        }
    }

    public void registerFeature(Feature feature) {
        MinecraftForge.EVENT_BUS.register((Object)feature);
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onRegistered(RegistryEvent.Register<Item> event) {
            lazyOreDictRegisters.forEach(Runnable::run);
        }
    }
}

