/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.item;

import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.item.ItemSC;
import com.maidarch.srpcalamity.muon.ItemNBTHelper;
import com.maidarch.srpcalamity.muon.LinguaWord;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemParasitesCage
extends ItemSC {
    private final String name;
    private final String register;
    private final String registerWithCap;
    private final boolean isLarge;

    public ItemParasitesCage(String name, String reg, String regcap, boolean isLarge) {
        super("cage_" + name);
        this.func_77625_d(1);
        if (isLarge) {
            this.func_77642_a(CCCItems.catcher_large);
        } else {
            this.func_77642_a(CCCItems.catcher_medium);
        }
        this.name = name;
        this.register = reg;
        this.registerWithCap = regcap;
        this.isLarge = isLarge;
    }

    public ItemParasitesCage(String name, boolean isLarge) {
        this(name, name, "srparasites:" + name, isLarge);
    }

    public ItemParasitesCage(LinguaWord word, boolean isLarge) {
        this(word.getNAME().toLowerCase(), word.getREGISTERY(), word.getREGISTERYWithCap(), isLarge);
    }

    private Entity getOwnEntity(World worldIn) {
        Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.registerWithCap), (World)worldIn);
        if (entity != null) {
            return entity;
        }
        return new EntityZombie(worldIn);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = playerIn.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!playerIn.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        Entity entity = this.getOwnEntity(worldIn);
        NBTTagCompound data = ItemNBTHelper.getCompound(playerIn.func_184586_b(hand), "catch_nbt", true);
        if (data != null) {
            entity.func_70020_e(data);
        }
        playerIn.func_184609_a(hand);
        BlockPos blockpos = pos.func_177972_a(facing);
        entity.func_70107_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5);
        worldIn.func_72838_d(entity);
        playerIn.func_184611_a(hand, new ItemStack(this.isLarge ? CCCItems.catcher_large : CCCItems.catcher_medium));
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(@Nonnull ItemStack stack) {
        NBTTagCompound cmp;
        if (stack.func_77942_o() && (cmp = ItemNBTHelper.getCompound(stack, "cage_nbt", false)) != null && cmp.func_74764_b("CustomName")) {
            return I18n.func_135052_a((String)"item.srpcalamity.cage_named.name", (Object[])new Object[]{cmp.func_74779_i("CustomName")});
        }
        return I18n.func_135052_a((String)"item.srpcalamity.cage_named.name", (Object[])new Object[]{I18n.func_135052_a((String)("entity.srparasites." + this.register + ".name"), (Object[])new Object[0])});
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        tooltip.add(TextFormatting.AQUA + I18n.func_135052_a((String)("review.srpcalamity.mob." + this.name), (Object[])new Object[0]));
    }
}

