/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.item;

import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.maidarch.srpcalamity.entity.item.EntityMidgeShot;
import com.maidarch.srpcalamity.entity.monster.inborn.EntitySata;
import com.maidarch.srpcalamity.item.ItemSC;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVermin
extends ItemSC {
    private static final int FIRING_TIME = 12;

    public ItemVermin() {
        super("compact_vermin", true);
        this.field_77777_bU = 1;
        this.func_77656_e(16);
        this.func_185043_a(new ResourceLocation("srpcalamity", "alt"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                int useTime;
                if (entityIn != null && entityIn.func_184607_cu() == stack && (useTime = stack.func_77988_m() - entityIn.func_184605_cv()) >= 12 && (useTime >>> 1) % 2 == 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77952_i() >= stack.func_77958_k() - 1) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (itemstack.func_77952_i() >= itemstack.func_77958_k() || !player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150474_ac) {
            worldIn.func_175625_s(pos);
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        EntitySata entity = new EntitySata(worldIn);
        entity.func_70012_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        ((EntityLiving)entity).field_70759_as = ((EntityLiving)entity).field_70177_z;
        ((EntityLiving)entity).field_70761_aq = ((EntityLiving)entity).field_70177_z;
        entity.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
        worldIn.func_72838_d((Entity)entity);
        if (itemstack.func_82837_s()) {
            entity.func_96094_a(itemstack.func_82833_r());
        }
        ItemVermin.applyItemEntityDataToEntity(worldIn, player, itemstack, (Entity)entity);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_77972_a(1, (EntityLivingBase)player);
        }
        player.func_184602_cy();
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("EntityTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(nbttagcompound.func_74775_l("EntityTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }

    @ParametersAreNonnullByDefault
    public void func_77615_a(ItemStack stack, World world, EntityLivingBase living, int useRemaining) {
        boolean fired;
        int useTime = this.func_77626_a(stack) - useRemaining;
        if (!world.field_72995_K && useTime > 12 && stack.func_77952_i() + 1 < stack.func_77958_k() && (fired = world.func_72838_d((Entity)new EntityMidgeShot(world, living)))) {
            stack.func_77972_a(2, living);
            world.func_184148_a(null, living.field_70165_t, living.field_70163_u, living.field_70161_v, SRPSounds.IKI_HURT, living instanceof EntityPlayer ? SoundCategory.PLAYERS : SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    @ParametersAreNonnullByDefault
    public int func_77626_a(ItemStack stack) {
        return 72000;
    }
}

