/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.muon;

import com.maidarch.srpcalamity.block.BlockSC;
import com.maidarch.srpcalamity.muon.MuonTileInventory;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class MuonBlockTE<TE extends TileEntity>
extends BlockSC {
    public MuonBlockTE(String name, Material material, MapColor mapColor) {
        super(name, material, mapColor);
    }

    public abstract Class<TE> getTileEntityClass();

    public TE getTileEntity(IBlockAccess world, BlockPos pos) {
        return (TE)world.func_175625_s(pos);
    }

    public boolean validTileEntity(TE tile) {
        return tile != null && tile.getClass() == this.getTileEntityClass();
    }

    public void dropsInventory(TE tile, int inventorySize, World world, BlockPos pos) {
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.NORTH);
        if (tile instanceof MuonTileInventory) {
            ((MuonTileInventory)tile).generateLoot(null);
        }
        for (int i = 0; i < inventorySize; ++i) {
            ItemStack stack = Objects.requireNonNull(itemHandler).getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            this.doItemSpawn(stack, world, pos);
        }
    }

    public void doItemSpawn(ItemStack stack, World world, BlockPos pos) {
        EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
        world.func_72838_d((Entity)item);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, false);
    }

    @ParametersAreNonnullByDefault
    public void func_180663_b(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity tileentity = p_breakBlock_1_.func_175625_s(p_breakBlock_2_);
        if (tileentity instanceof IInventory) {
            InventoryHelper.func_180175_a((World)p_breakBlock_1_, (BlockPos)p_breakBlock_2_, (IInventory)((IInventory)tileentity));
            p_breakBlock_1_.func_175666_e(p_breakBlock_2_, (Block)this);
        }
        super.func_180663_b(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @ParametersAreNonnullByDefault
    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        world.func_175698_g(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public abstract TE createTileEntity(World var1, IBlockState var2);

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        int out = 0;
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof MuonTileInventory) {
            out = ((MuonTileInventory)tile).getComparatorOutput();
        }
        return out;
    }
}

