/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.proxy;

import com.maidarch.srpcalamity.packet.PacketHandler;
import com.maidarch.srpcalamity.particle.CherryParticle;
import com.maidarch.srpcalamity.particle.ModParticle;
import com.maidarch.srpcalamity.proxy.CommonProxy;
import com.maidarch.srpcalamity.util.RegistryHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientProxy
extends CommonProxy {
    @SideOnly(value=Side.CLIENT)
    private static List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        RegistryHandler.preInitRegistries();
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(Objects.requireNonNull(item.getRegistryName()), id));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerParticle() {
        Minecraft MC = Minecraft.func_71410_x();
        MC.field_71452_i.func_178929_a(18432, (IParticleFactory)new CherryParticle.CherryParticleFactory());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addRegisterTextures() {
        ModParticle.registerParticleTexture();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void register() {
        PacketHandler.registerClientPackets();
        this.registerGui();
        ClientProxy.registerParticle();
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation addRegisterTextures(ResourceLocation textures) {
        TEXTURES.add(textures);
        return textures;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        for (ResourceLocation textures : TEXTURES) {
            event.getMap().func_174942_a(textures);
        }
    }
}

