/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.block;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;

public class ModelUtils {
    public static void registerToState(Block b, int itemMeta, IBlockState state) {
        ModelUtils.registerToState(b, itemMeta, state, (IStateMapper)new DefaultStateMapper());
    }

    public static void registerToState(Block b, int itemMeta, IBlockState state, IStateMapper stateMapper) {
        ModelResourceLocation mrl = (ModelResourceLocation)stateMapper.func_178130_a(state.func_177230_c()).get(state);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)b), (int)itemMeta, (ModelResourceLocation)mrl);
    }

    public static <T extends Comparable<T>> void registerToStateSingleVariant(Block b, IProperty<T> variant) {
        ModelUtils.registerToStateSingleVariant(b, variant, (IStateMapper)new DefaultStateMapper());
    }

    public static <T extends Comparable<T>> void registerToStateSingleVariant(Block b, IProperty<T> variant, IStateMapper stateMapper) {
        ArrayList variants = new ArrayList(variant.func_177700_c());
        for (int i = 0; i < variants.size(); ++i) {
            ModelUtils.registerToState(b, i, b.func_176223_P().func_177226_a(variant, (Comparable)variants.get(i)), stateMapper);
        }
    }

    public static void registerIncludingItemModels(Block b, String inventoryPrefix, IProperty<?> ... blockIgnorables) {
        ModelUtils.registerIncludingItemModels(b, inventoryPrefix, blockIgnorables, new IProperty[0]);
    }

    public static void registerIncludingItemModels(Block b, String inventoryPrefix, IProperty<?>[] blockIgnorables, IProperty<?>[] itemIgnorables) {
        HashSet properties = new HashSet(b.func_176194_O().func_177623_d());
        Item item = Item.func_150898_a((Block)b);
        ModelLoader.setCustomStateMapper((Block)b, (IStateMapper)new StateMap.Builder().func_178442_a(blockIgnorables).func_178441_a());
        if (item != Items.field_190931_a) {
            if (itemIgnorables.length > 0) {
                for (IProperty<?> ignore : itemIgnorables) {
                    properties.remove(ignore);
                }
                HashSet<IBlockState> states = new HashSet<IBlockState>();
                IBlockState defaultState = b.func_176223_P();
                states.add(defaultState);
                for (IProperty prop : properties) {
                    ImmutableSet.Builder statesIn = ImmutableSet.builder();
                    statesIn.addAll(states);
                    ModelUtils.swizzleStatesWithPropertyKey(defaultState, states, (ImmutableCollection<IBlockState>)statesIn.build(), prop);
                }
                ResourceLocation rl = item.getRegistryName();
                if (rl != null) {
                    for (IBlockState state : states) {
                        int meta = b.func_176201_c(state);
                        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(rl, inventoryPrefix + "_" + meta));
                    }
                }
            } else {
                ResourceLocation rl = item.getRegistryName();
                if (rl != null) {
                    ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(rl, inventoryPrefix));
                }
            }
        }
    }

    private static <T extends Comparable<T>> void swizzleStatesWithPropertyKey(IBlockState defaultState, Collection<IBlockState> target, ImmutableCollection<IBlockState> statesIn, IProperty<T> property) {
        HashSet values = new HashSet(property.func_177700_c());
        values.remove(defaultState.func_177229_b(property));
        for (Comparable value : values) {
            for (IBlockState state : statesIn) {
                target.add(state.func_177226_a(property, value));
            }
        }
    }
}

