/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.block.furniture;

import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.block.BlockSCPlanks;
import com.maidarch.srpcalamity.muon.CalamitySound;
import com.maidarch.srpcalamity.muon.CalamityTabs;
import com.maidarch.srpcalamity.muon.MuonBlockTE;
import com.maidarch.srpcalamity.tile.TileBarrel;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBarrel
extends MuonBlockTE<TileBarrel> {
    public static final PropertyDirection FACING = BlockDirectional.field_176387_N;

    public BlockBarrel(BlockSCPlanks.PlankEnum plankEnum) {
        super(plankEnum.func_176610_l() + "_barrel", Material.field_151575_d, plankEnum.getMapColor());
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149647_a(CalamityTabs.CalamityTab);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP));
    }

    @ParametersAreNonnullByDefault
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileBarrel barrel = (TileBarrel)this.getTileEntity((IBlockAccess)worldIn, pos);
        if (this.validTileEntity(barrel)) {
            EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            barrel.setFacing(facing);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    @ParametersAreNonnullByDefault
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            TileBarrel barrel = (TileBarrel)this.getTileEntity((IBlockAccess)worldIn, pos);
            if (!this.validTileEntity(barrel)) {
                return false;
            }
            if (playerIn.func_70093_af()) {
                return false;
            }
            if (barrel.hasLootTable()) {
                barrel.generateLoot(playerIn);
            }
            playerIn.openGui((Object)SRPCalamity.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        if (worldIn.field_72995_K && !playerIn.func_70093_af()) {
            playerIn.func_184185_a(CalamitySound.WOOD_OPEN, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    @ParametersAreNonnullByDefault
    public void func_180663_b(World world, BlockPos pos, IBlockState p_breakBlock_3_) {
        TileBarrel barrel = (TileBarrel)this.getTileEntity((IBlockAccess)world, pos);
        if (this.validTileEntity(barrel)) {
            this.dropsInventory(barrel, 27, world, pos);
        }
        super.func_180663_b(world, pos, p_breakBlock_3_);
    }

    @ParametersAreNonnullByDefault
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Block)this, 1, 0));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    @Override
    public Class<TileBarrel> getTileEntityClass() {
        return TileBarrel.class;
    }

    @Override
    @Nullable
    public TileBarrel createTileEntity(World world, IBlockState state) {
        return new TileBarrel();
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirrorIn.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @ParametersAreNonnullByDefault
    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileBarrel barrel = (TileBarrel)worldIn.func_175625_s(pos);
        if (barrel != null && this.validTileEntity(barrel)) {
            EnumFacing facing = barrel.getFacing();
            if (facing.func_176740_k() == EnumFacing.Axis.Y) {
                facing = EnumFacing.UP;
            }
            state = state.func_177226_a((IProperty)FACING, (Comparable)facing);
        }
        return state;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, 0);
    }
}

