/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.block.furniture;

import com.maidarch.srpcalamity.block.BlockSC;
import com.maidarch.srpcalamity.muon.CalamitySound;
import com.maidarch.srpcalamity.muon.CalamitySoundType;
import com.maidarch.srpcalamity.muon.CalamityTabs;
import com.maidarch.srpcalamity.util.config.CalamityConfigRules;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLantern
extends BlockSC {
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");

    public BlockLantern(String variant) {
        super("lantern_" + variant, Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(4.0f);
        this.func_149715_a(1.0f);
        this.func_149672_a(CalamitySoundType.LANTERN);
        this.func_149647_a(CalamityTabs.CalamityTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float hpad = 0.3125f;
        float vpad = 0.4375f;
        float voff = 0.06f;
        AxisAlignedBB aabb = (Boolean)state.func_177229_b((IProperty)HANGING) != false ? new AxisAlignedBB((double)hpad, (double)voff, (double)hpad, (double)(1.0f - hpad), (double)(1.0f - vpad + voff), (double)(1.0f - hpad)) : new AxisAlignedBB((double)hpad, 0.0, (double)hpad, (double)(1.0f - hpad), (double)(1.0f - vpad), (double)(1.0f - hpad));
        return aabb;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (rand.nextFloat() <= 0.04f) {
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, CalamitySound.LITTLE_FIRE, SoundCategory.BLOCKS, 0.24f, 1.0f, false);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (CalamityConfigRules.lanternFalling) {
            this.checkFallable(worldIn, pos);
        }
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        boolean hanging = (Boolean)worldIn.func_180495_p(pos).func_177229_b((IProperty)HANGING);
        if (hanging && !worldIn.func_175623_d(pos.func_177984_a())) {
            return;
        }
        if (!hanging && !worldIn.func_175623_d(pos.func_177977_b())) {
            return;
        }
        if ((worldIn.func_175623_d(pos.func_177977_b()) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!BlockFalling.field_149832_M && worldIn.func_175707_a(pos.func_177982_a(-i, -i, -i), pos.func_177982_a(i, i, i))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                IBlockState state = worldIn.func_180495_p(pos);
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((worldIn.func_175623_d(blockpos) || BlockFalling.func_185759_i((IBlockState)worldIn.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)HANGING) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HANGING});
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.equals((Object)EnumFacing.DOWN)) {
            return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(true));
        }
        return this.func_176223_P().func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return side.equals((Object)EnumFacing.DOWN) || side.equals((Object)EnumFacing.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.CENTER;
    }
}

