/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.client.render.boat;

import com.maidarch.srpcalamity.client.render.boat.ModelRaft;
import com.maidarch.srpcalamity.entity.boat.EntityModBoat;
import com.maidarch.srpcalamity.entity.boat.EntityModChestBoat;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderBoat;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class RenderModBoat
extends RenderBoat {
    private static final ModelRaft RAFT_MODEL = new ModelRaft();
    private static final ModelChest CHEST_MODEL = new ModelChest();
    private static ResourceLocation chesTexture;
    private static final Minecraft MC;
    private static final ResourceLocation chestDefaultTexture;
    private static final ResourceLocation chestChristmasTexture;

    public RenderModBoat(RenderManager renderManager) {
        super(renderManager);
    }

    public void func_76986_a(EntityBoat entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (((EntityModBoat)entity).isRaft()) {
            this.renderRaft(entity, x, y, z, entityYaw, partialTicks);
        } else {
            super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
        }
        if (entity instanceof EntityModChestBoat) {
            EntityModChestBoat boat = (EntityModChestBoat)entity;
            if (boat.func_145782_y() != entity.func_145782_y()) {
                return;
            }
            GlStateManager.func_179094_E();
            this.func_188309_a(x, y, z);
            this.func_188311_a(boat, entityYaw, partialTicks);
            Vec3d offset = boat.chestPart.getChestOffset();
            GlStateManager.func_179137_b((double)offset.field_72450_a, (double)(-offset.field_72448_b), (double)offset.field_72449_c);
            this.renderChest(boat, partialTicks);
            GlStateManager.func_179121_F();
        }
    }

    private void renderRaft(EntityBoat entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.func_179094_E();
        this.func_188309_a(x, y, z);
        this.func_188311_a(entity, entityYaw, partialTicks);
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.func_179142_g();
            GlStateManager.func_187431_e((int)this.func_188298_c((Entity)entity));
        }
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RAFT_MODEL.func_78088_a((Entity)entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (this.field_188301_f) {
            GlStateManager.func_187417_n();
            GlStateManager.func_179119_h();
        }
        GlStateManager.func_179121_F();
        if (!this.field_188301_f) {
            this.func_177067_a((Entity)entity, x, y, z);
        }
    }

    private void renderChest(EntityModChestBoat boat, float partialTicks) {
        MC.func_110434_K().func_110577_a(chesTexture);
        GlStateManager.func_179139_a((double)0.875, (double)0.875, (double)0.875);
        GlStateManager.func_179137_b((double)-0.5, (double)(boat.isRaft() ? -0.56 : -0.59), (double)0.46);
        float lidAngle = boat.chestPart.getLidAngle(partialTicks);
        float adjustedLidAngle = lidAngle > 0.0f ? 1.0f - (float)Math.pow(1.0f - lidAngle, 3.0) : 0.0f;
        RenderModBoat.CHEST_MODEL.field_78234_a.field_78795_f = -(adjustedLidAngle * 1.5707964f);
        CHEST_MODEL.func_78231_a();
    }

    public void func_188300_b(EntityBoat boat, double x, double y, double z, float yaw, float partialTicks) {
        if (!((EntityModBoat)boat).isRaft()) {
            super.func_188300_b(boat, x, y, z, yaw, partialTicks);
        }
    }

    protected ResourceLocation func_110775_a(EntityBoat boat) {
        return ((EntityModBoat)boat).getTexture();
    }

    public static void setChestTexture() {
        Calendar calendar = Calendar.getInstance();
        boolean isChristmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        chesTexture = isChristmas ? chestChristmasTexture : chestDefaultTexture;
    }

    static {
        MC = Minecraft.func_71410_x();
        chestDefaultTexture = new ResourceLocation("textures/entity/chest/normal.png");
        chestChristmasTexture = new ResourceLocation("textures/entity/chest/christmas.png");
    }
}

