/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.crude;

import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIParasiteFollow;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.maidarch.srpcalamity.util.CalamityEventEntity;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCuleS
extends EntityParasiteBase {
    private int noLegs;
    private int noTimes;
    private float tSize;
    private float aSize;
    private int delay;
    private boolean st1;
    private float tSpeed;
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityCuleS.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityCuleS(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.noLegs = (1 + this.field_70146_Z.nextInt(2)) * 2;
        this.noTimes = 1;
        this.st1 = false;
        this.tSize = 1.0f;
        this.aSize = 1.0f;
        this.fuseTime = 70;
        this.killcount = -10.0;
        this.type = (byte)100;
        this.field_70728_aV = 0;
        this.field_70765_h = new AIMoveControl(this);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
    }

    public int getParasiteIDRegister() {
        return 2308;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIParasiteFollow((EntityParasiteBase)this, 1.3, 10.0, 2.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAICuoCombine(this, 1.1));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityCuleS.class, false, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, entity -> !(entity instanceof EntityCreeper) && !(entity instanceof EntityParasiteBase) && !(entity instanceof EntityAnimal), 8.0f, 1.0, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom());
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(this.tSize));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.adaptedFollow);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public void setMotion(double xSpeedIn, double ySpeedIn, double zSpeedIn, double capX, double capY) {
        xSpeedIn = Math.min(xSpeedIn, capX);
        ySpeedIn = Math.min(ySpeedIn, capY);
        zSpeedIn = Math.min(zSpeedIn, capX);
        this.field_70159_w = xSpeedIn * (Math.random() * 2.0 - 1.0);
        this.field_70181_x = ySpeedIn;
        this.field_70179_y = zSpeedIn * (Math.random() * 2.0 - 1.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.func_175446_cd()) {
            this.liquidLeap = 0;
            super.func_70636_d();
            this.func_189654_d(this.field_70171_ac);
            this.liquidLeap = 0;
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70638_az() != null) {
                    this.setParasiteStatus(1);
                }
                if (this.field_70173_aa % 20 == 0) {
                    // empty if block
                }
            }
        }
        if (this.func_70638_az() != null && this.field_70173_aa % 20 == 0) {
            if (!this.func_70638_az().func_70089_S()) {
                this.func_70624_b(null);
            }
            if (this.func_70638_az() instanceof EntityCuleS) {
                EntityCuleS meh = (EntityCuleS)this.func_70638_az();
                if (this.getTimes() + meh.getTimes() > 8) {
                    this.func_70624_b(null);
                }
            }
        }
        if (this.gettSize() > this.getaSize()) {
            this.setaSize(0.01f);
            this.func_70105_a(0.5f + (this.getaSize() - 1.0f), 0.5f + (this.getaSize() - 1.0f));
        }
        if (this.getTimes() >= 8 && this.field_70173_aa % 20 == 0) {
            ++this.delay;
            this.st1 = true;
        }
        if (this.delay >= 4 && this.st1) {
            this.setSelfeState(1);
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70606_j(this.func_110143_aJ() + 0.007f);
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            this.dyingBurst(false, 2);
        }
        super.func_70071_h_();
    }

    protected void dyingBurst(boolean fromDeath, int value) {
        int i = this.getSelfeState();
        if (i > 0 && this.timeSinceIgnited == 0) {
            this.func_184185_a(SRPSounds.FLESH_GROW, 10.0f, 1.0f);
        }
        this.timeSinceIgnited += i * value;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.selfExplode();
        }
    }

    protected void selfExplode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70729_aU = true;
            this.func_70106_y();
            this.spawnPrimitive(this, this.noLegs);
            this.func_184185_a(SRPSounds.FLESH_PRIMITIVE, 1.0f, 1.0f);
        } else {
            this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
        }
    }

    public int getLegs() {
        return this.noLegs;
    }

    public void setLegs(int i, boolean plus) {
        this.noLegs = plus ? (this.noLegs += i) : i;
    }

    @ParametersAreNonnullByDefault
    public boolean func_70652_k(Entity entityIn) {
        if (!(entityIn instanceof EntityCuleS)) {
            return true;
        }
        ++this.delay;
        if (this.delay >= 3) {
            EntityCuleS meh = (EntityCuleS)entityIn;
            if (this.getaSize() >= meh.getaSize()) {
                this.func_95999_t();
                this.setLegs(meh.getLegs(), true);
                this.setTimes(meh.getTimes());
                meh.particleStatus((byte)6);
                meh.func_70106_y();
                this.func_184185_a(SRPSounds.FLESH_EAT, 1.0f, 1.0f);
                this.settSize(0.3f);
                this.resetDelay();
                this.settSpeed((float)(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() - 0.01));
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.tSpeed);
                this.particleStatus((byte)5);
                this.func_184185_a(SRPSounds.FLESH_GROW, 10.0f, 1.0f);
            }
        }
        return true;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (!this.func_175446_cd()) {
            if (this.func_70089_S() && !this.func_70090_H()) {
                this.func_70050_g(--i);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public int getTimes() {
        return this.noTimes;
    }

    public void setTimes(int in) {
        this.noTimes += in;
    }

    public float func_70047_e() {
        return 0.3f;
    }

    public float gettSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void settSize(float in) {
        this.tSize += in;
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(this.tSize));
    }

    public void settSpeed(float in) {
        this.tSpeed = in;
    }

    public float getaSize() {
        return this.aSize;
    }

    public void setaSize(float in) {
        this.aSize += in;
    }

    public void resetDelay() {
        this.delay = 0;
    }

    public static void registerFixesCuoS(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityCuleS.class);
    }

    protected SoundEvent func_184639_G() {
        return SRPSounds.FLESH_GROWL;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SRPSounds.FLESH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.FLESH_DEATH;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 0;
    }

    public boolean func_70692_ba() {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("cuostotalsize", this.tSize);
        compound.func_74776_a("cuosactualsize", this.aSize);
        compound.func_74768_a("cuoslegs", this.noLegs);
        compound.func_74768_a("cuostimes", this.noTimes);
        compound.func_74776_a("cuosspeed", this.tSpeed);
    }

    @ParametersAreNonnullByDefault
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("cuostotalsize", 99)) {
            this.tSize = compound.func_74760_g("cuostotalsize");
            this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(compound.func_74760_g("cuostotalsize")));
        }
        if (compound.func_150297_b("cuoslegs", 99)) {
            this.noLegs = compound.func_74762_e("cuoslegs");
        }
        if (compound.func_150297_b("cuostimes", 99)) {
            this.noTimes = compound.func_74762_e("cuostimes");
        }
        if (compound.func_150297_b("cuosspeed", 99)) {
            this.tSpeed = compound.func_74760_g("cuosspeed");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getSelfeFlashIntensityS() {
        return this.aSize;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.tSize += 0.3f;
        } else {
            super.func_70103_a(id);
        }
    }

    private void spawnPrimitive(EntityCuleS host, int code) {
        host.func_70106_y();
        CalamityEventEntity.mergeAQ(this, code, this.func_95999_t());
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityCuleS vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityCuleS.this.field_70165_t;
                double d1 = this.field_75647_c - EntityCuleS.this.field_70163_u;
                double d2 = this.field_75644_d - EntityCuleS.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityCuleS.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityCuleS.this.field_70159_w *= 0.5;
                    EntityCuleS.this.field_70181_x *= 0.5;
                    EntityCuleS.this.field_70179_y *= 0.5;
                } else {
                    EntityCuleS.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityCuleS.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityCuleS.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityCuleS.this.func_70638_az() == null) {
                        EntityCuleS.this.field_70761_aq = EntityCuleS.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityCuleS.this.field_70159_w, (double)EntityCuleS.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityCuleS.this.func_70638_az().field_70165_t - EntityCuleS.this.field_70165_t;
                        double d5 = EntityCuleS.this.func_70638_az().field_70161_v - EntityCuleS.this.field_70161_v;
                        EntityCuleS.this.field_70761_aq = EntityCuleS.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return EntityCuleS.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityCuleS.this);
            int flag = 1;
            double speed = 0.19;
            if (EntityCuleS.this.func_70638_az() != null) {
                if (EntityCuleS.this.func_70068_e((Entity)EntityCuleS.this.func_70638_az()) > 100.0) {
                    blockpos = new BlockPos((Entity)EntityCuleS.this.func_70638_az());
                    flag = 2;
                } else if (EntityCuleS.this.func_70068_e((Entity)EntityCuleS.this.func_70638_az()) < 36.0) {
                    blockpos = new BlockPos((Entity)EntityCuleS.this.func_70638_az());
                    flag = 3;
                }
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityCuleS.this.field_70146_Z.nextInt(15) - 7, EntityCuleS.this.field_70146_Z.nextInt(11) - 5, EntityCuleS.this.field_70146_Z.nextInt(15) - 7);
                if (flag == 2) {
                    blockpos1 = blockpos.func_177982_a(EntityCuleS.this.field_70146_Z.nextInt(6) - 2, EntityCuleS.this.field_70146_Z.nextInt(7) - 2, EntityCuleS.this.field_70146_Z.nextInt(6) - 2);
                } else if (flag == 3) {
                    blockpos1 = blockpos.func_177982_a(EntityCuleS.this.field_70146_Z.nextInt(4) + 3, EntityCuleS.this.field_70146_Z.nextInt(5) + 4, EntityCuleS.this.field_70146_Z.nextInt(4) + 3);
                }
                if (EntityCuleS.this.field_70170_p.func_180495_p(blockpos1).func_185904_a() != Material.field_151586_h) continue;
                EntityCuleS.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, speed);
                if (EntityCuleS.this.func_70638_az() != null) break;
                EntityCuleS.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }

    static class EntityAICuoCombine
    extends EntityAIBase {
        private final EntityCuleS parent;

        public EntityAICuoCombine(EntityCuleS animal, double speedIn) {
            this.parent = animal;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.parent.func_70638_az();
            if (target == null) {
                return true;
            }
            return !target.func_70089_S();
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            if (this.parent.field_70173_aa % 20 == 0) {
                EntityCuleS mob;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.parent.field_70165_t, this.parent.field_70163_u, this.parent.field_70161_v, this.parent.field_70165_t + 1.0, this.parent.field_70163_u + 1.0, this.parent.field_70161_v + 1.0).func_186662_g(this.parent.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e());
                List moblist = this.parent.field_70170_p.func_72872_a(EntityCuleS.class, axisalignedbb);
                Iterator var3 = moblist.iterator();
                do {
                    if (var3.hasNext()) continue;
                    return;
                } while ((mob = (EntityCuleS)((Object)var3.next())) == this.parent || !this.parent.func_70685_l((Entity)mob) || !mob.func_70089_S() || mob.func_94060_bK() != null || mob.getTimes() + this.parent.getTimes() > 8);
                this.parent.func_70624_b((EntityLivingBase)mob);
                mob.func_70624_b((EntityLivingBase)this.parent);
            }
        }
    }
}

