/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.crude;

import com.dhanantry.scapeandrunparasites.client.particle.SRPEnumParticle;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIParasiteFollow;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.maidarch.srpcalamity.util.CalamityEventEntity;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityFesh
extends EntityParasiteBase {
    private int noLegs;
    private int noTimes;
    private float tSize;
    private float aSize;
    private int delay;
    private boolean st1;
    private float tSpeed;
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(EntityFesh.class, (DataSerializer)DataSerializers.field_187193_c);

    public EntityFesh(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.5f);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.noLegs = (1 + this.field_70146_Z.nextInt(2)) * 2;
        this.noTimes = 1;
        this.st1 = false;
        this.tSize = 1.0f;
        this.aSize = 1.0f;
        this.fuseTime = 70;
        this.killcount = -10.0;
        this.type = (byte)100;
    }

    public int getParasiteIDRegister() {
        return 3200;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIParasiteFollow((EntityParasiteBase)this, 1.3, 10.0, 2.0, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFeshCombine(this, 1.1));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityFesh.class, false, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, entity -> !(entity instanceof EntityWaterMob) && !(entity instanceof EntityCreeper) && !(entity instanceof EntityParasiteBase) && !(entity instanceof EntityAnimal), 8.0f, 1.0, 1.0));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(this.tSize));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.adaptedFollow);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null && this.field_70173_aa % 20 == 0) {
            if (!this.func_70638_az().func_70089_S()) {
                this.func_70624_b(null);
            }
            if (this.func_70638_az() instanceof EntityFesh) {
                EntityFesh meh = (EntityFesh)this.func_70638_az();
                if (this.getTimes() + meh.getTimes() > 4) {
                    this.func_70624_b(null);
                }
            }
        }
        if (this.gettSize() > this.getaSize()) {
            this.setaSize(0.01f);
            this.func_70105_a(0.7f + (this.getaSize() - 1.0f), 0.5f + (this.getaSize() - 1.0f));
        }
        if (this.getTimes() >= 4 && this.field_70173_aa % 20 == 0) {
            ++this.delay;
            this.st1 = true;
        }
        if (this.delay >= 4 && this.st1) {
            this.setSelfeState(1);
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L && this.func_110143_aJ() > 0.0f && this.func_110143_aJ() < this.func_110138_aP()) {
            this.func_70606_j(this.func_110143_aJ() + 0.007f);
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            this.lastActiveTime = this.timeSinceIgnited;
            this.dyingBurst(false, 2);
        }
        super.func_70071_h_();
    }

    protected void dyingBurst(boolean fromDeath, int value) {
        int i = this.getSelfeState();
        if (i > 0 && this.timeSinceIgnited == 0) {
            this.func_184185_a(SRPSounds.FLESH_GROW, 10.0f, 1.0f);
        }
        this.timeSinceIgnited += i * value;
        if (this.timeSinceIgnited < 0) {
            this.timeSinceIgnited = 0;
        }
        if (this.timeSinceIgnited >= this.fuseTime) {
            this.timeSinceIgnited = this.fuseTime;
            this.selfExplode();
        }
    }

    protected void selfExplode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70729_aU = true;
            this.func_70106_y();
            this.spawnPrimitive(this, this.noLegs);
            this.func_184185_a(SRPSounds.FLESH_PRIMITIVE, 1.0f, 1.0f);
        } else {
            this.spawnParticles(SRPEnumParticle.GCLOUD, 127, 0, 0);
        }
    }

    public int getLegs() {
        return this.noLegs;
    }

    public void setLegs(int i, boolean plus) {
        this.noLegs = plus ? (this.noLegs += i) : i;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (!(entityIn instanceof EntityFesh)) {
            return true;
        }
        ++this.delay;
        if (this.delay >= 3) {
            EntityFesh meh = (EntityFesh)entityIn;
            if (this.getaSize() >= meh.getaSize()) {
                if (this.func_95999_t() == null) {
                    meh.func_95999_t();
                }
                this.setLegs(meh.getLegs(), true);
                this.setTimes(meh.getTimes());
                meh.particleStatus((byte)6);
                meh.func_70106_y();
                this.func_184185_a(SRPSounds.FLESH_EAT, 1.0f, 1.0f);
                this.settSize(0.3f);
                this.resetDelay();
                this.settSpeed((float)(this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() - 0.01));
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)this.tSpeed);
                this.particleStatus((byte)5);
                this.func_184185_a(SRPSounds.FLESH_GROW, 10.0f, 1.0f);
            }
        }
        return true;
    }

    public int getTimes() {
        return this.noTimes;
    }

    public void setTimes(int in) {
        this.noTimes += in;
    }

    public float func_70047_e() {
        return 0.3f;
    }

    public float gettSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public void settSize(float in) {
        this.tSize += in;
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(this.tSize));
    }

    public void settSpeed(float in) {
        this.tSpeed = in;
    }

    public float getaSize() {
        return this.aSize;
    }

    public void setaSize(float in) {
        this.aSize += in;
    }

    public void resetDelay() {
        this.delay = 0;
    }

    public static void registerFixesFesh(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityFesh.class);
    }

    protected SoundEvent func_184639_G() {
        return SRPSounds.FLESH_GROWL;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SRPSounds.FLESH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.FLESH_DEATH;
    }

    @ParametersAreNonnullByDefault
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("feshtotalsize", this.tSize);
        compound.func_74776_a("feshactualsize", this.aSize);
        compound.func_74768_a("feshlegs", this.noLegs);
        compound.func_74768_a("feshtimes", this.noTimes);
        compound.func_74776_a("feshspeed", this.tSpeed);
    }

    @ParametersAreNonnullByDefault
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("feshtotalsize", 99)) {
            this.tSize = compound.func_74760_g("feshtotalsize");
            this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(compound.func_74760_g("feshtotalsize")));
        }
        if (compound.func_150297_b("feshlegs", 99)) {
            this.noLegs = compound.func_74762_e("feshlegs");
        }
        if (compound.func_150297_b("feshtimes", 99)) {
            this.noTimes = compound.func_74762_e("feshtimes");
        }
        if (compound.func_150297_b("feshspeed", 99)) {
            this.tSpeed = compound.func_74760_g("feshspeed");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getSelfeFlashIntensityS() {
        return this.aSize;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.tSize += 0.3f;
        } else {
            super.func_70103_a(id);
        }
    }

    private void spawnPrimitive(EntityFesh host, int code) {
        host.func_70106_y();
        CalamityEventEntity.mergeTF(this, code, this.func_95999_t());
    }

    static class EntityAIFeshCombine
    extends EntityAIBase {
        private final EntityFesh parent;

        public EntityAIFeshCombine(EntityFesh animal, double speedIn) {
            this.parent = animal;
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.parent.func_70638_az();
            if (target == null) {
                return true;
            }
            return !target.func_70089_S();
        }

        public void func_75251_c() {
        }

        public void func_75246_d() {
            if (this.parent.field_70173_aa % 20 == 0) {
                EntityFesh mob;
                AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.parent.field_70165_t, this.parent.field_70163_u, this.parent.field_70161_v, this.parent.field_70165_t + 1.0, this.parent.field_70163_u + 1.0, this.parent.field_70161_v + 1.0).func_186662_g(this.parent.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e());
                List moblist = this.parent.field_70170_p.func_72872_a(EntityFesh.class, axisalignedbb);
                Iterator var3 = moblist.iterator();
                do {
                    if (var3.hasNext()) continue;
                    return;
                } while ((mob = (EntityFesh)((Object)var3.next())) == this.parent || !this.parent.func_70685_l((Entity)mob) || !mob.func_70089_S() || mob.func_94060_bK() != null || mob.getTimes() + this.parent.getTimes() > 4);
                this.parent.func_70624_b((EntityLivingBase)mob);
                mob.func_70624_b((EntityLivingBase)this.parent);
            }
        }
    }
}

