/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.feral;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeNotGround;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCanFly;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCutomAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPFeral;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityFerSquid
extends EntityPFeral
implements EntityCanFly,
EntityCutomAttack {
    protected static final DataParameter<Byte> VEX_FLAGS = EntityDataManager.func_187226_a(EntityFerSquid.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityFerSquid(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.9f, 0.9f);
        this.field_70765_h = new AIMoveControl(this);
        this.canModRender = 0;
        this.type = (byte)15;
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
    }

    public int getParasiteIDRegister() {
        return 2135;
    }

    public int getIDSpawn() {
        return 307;
    }

    public int canSpawnByIDData() {
        return SRPConfigMobs.infsquidCanSpawnAssimilatedNat;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMeleeNotGround((EntityParasiteBase)this, 4.0, SRPConfig.primitiveFollow, 0.05, false, 0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.FERSQUID_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(CalamityAttributes.FERSQUID_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(CalamityAttributes.FERSQUID_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.FERSQUID_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.feralFollow);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_fersquid);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public void func_70636_d() {
        if (!this.func_175446_cd()) {
            this.liquidLeap = 0;
            super.func_70636_d();
            this.func_189654_d(this.field_70171_ac);
            this.liquidLeap = 0;
        }
    }

    protected void selfExplode() {
        super.selfExplode();
        ParasiteEventEntity.spawnM((EntityParasiteBase)this, (String[])new String[]{CalamityConfigMobs.fersquidmob}, (int)0, (boolean)false, (String)this.func_95999_t());
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    public static void registerFixesFerSquid(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityFerSquid.class);
    }

    @ParametersAreNonnullByDefault
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SRPSounds.MOBSILENCE, 0.15f, 1.0f);
    }

    public boolean attackEntityAsMobAOE(Entity entityIn) {
        return this.func_70652_k(entityIn);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 0;
    }

    public boolean func_70692_ba() {
        return true;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (!this.func_175446_cd()) {
            if (this.func_70089_S() && !this.func_70090_H()) {
                this.func_70050_g(--i);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VEX_FLAGS, (Object)0);
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityFerSquid squid) {
            super((EntityLiving)squid);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityFerSquid.this.field_70165_t;
                double d1 = this.field_75647_c - EntityFerSquid.this.field_70163_u;
                double d2 = this.field_75644_d - EntityFerSquid.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityFerSquid.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityFerSquid var10000 = EntityFerSquid.this;
                    var10000.field_70159_w *= 0.5;
                    var10000.field_70181_x *= 0.5;
                    var10000.field_70179_y *= 0.5;
                } else {
                    EntityFerSquid var10000 = EntityFerSquid.this;
                    var10000.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    var10000.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    var10000.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityFerSquid.this.func_70638_az() == null) {
                        EntityFerSquid.this.field_70761_aq = EntityFerSquid.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityFerSquid.this.field_70159_w, (double)EntityFerSquid.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityFerSquid.this.func_70638_az().field_70165_t - EntityFerSquid.this.field_70165_t;
                        double d5 = EntityFerSquid.this.func_70638_az().field_70161_v - EntityFerSquid.this.field_70161_v;
                        EntityFerSquid.this.field_70761_aq = EntityFerSquid.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return EntityFerSquid.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityFerSquid.this);
            int flag = 1;
            double speed = 0.13;
            if (EntityFerSquid.this.func_70638_az() != null) {
                if (EntityFerSquid.this.func_70068_e((Entity)EntityFerSquid.this.func_70638_az()) > 100.0) {
                    blockpos = new BlockPos((Entity)EntityFerSquid.this.func_70638_az());
                    flag = 2;
                } else if (EntityFerSquid.this.func_70068_e((Entity)EntityFerSquid.this.func_70638_az()) < 36.0) {
                    blockpos = new BlockPos((Entity)EntityFerSquid.this.func_70638_az());
                    flag = 3;
                }
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityFerSquid.this.field_70146_Z.nextInt(15) - 7, EntityFerSquid.this.field_70146_Z.nextInt(11) - 5, EntityFerSquid.this.field_70146_Z.nextInt(15) - 7);
                if (flag == 2) {
                    blockpos1 = blockpos.func_177982_a(EntityFerSquid.this.field_70146_Z.nextInt(6) - 2, EntityFerSquid.this.field_70146_Z.nextInt(7) - 2, EntityFerSquid.this.field_70146_Z.nextInt(6) - 2);
                } else if (flag == 3) {
                    blockpos1 = blockpos.func_177982_a(EntityFerSquid.this.field_70146_Z.nextInt(4) + 3, EntityFerSquid.this.field_70146_Z.nextInt(5) + 4, EntityFerSquid.this.field_70146_Z.nextInt(4) + 3);
                }
                if (EntityFerSquid.this.field_70170_p.func_180495_p(blockpos1).func_185904_a() != Material.field_151586_h) continue;
                EntityFerSquid.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, speed);
                if (EntityFerSquid.this.func_70638_az() != null) break;
                EntityFerSquid.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

