/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.hijacked;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPHijacked;
import com.google.common.base.Optional;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityBodyHelper;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHiShulker
extends EntityPHijacked {
    private static final UUID COVERED_ARMOR_BONUS_ID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_BONUS_MODIFIER = new AttributeModifier(COVERED_ARMOR_BONUS_ID, "Covered armor bonus", 20.0, 0).func_111168_a(false);
    protected static final DataParameter<EnumFacing> ATTACHED_FACE = EntityDataManager.func_187226_a(EntityHiShulker.class, (DataSerializer)DataSerializers.field_187202_l);
    protected static final DataParameter<Optional<BlockPos>> ATTACHED_BLOCK_POS = EntityDataManager.func_187226_a(EntityHiShulker.class, (DataSerializer)DataSerializers.field_187201_k);
    protected static final DataParameter<Byte> PEEK_TICK = EntityDataManager.func_187226_a(EntityHiShulker.class, (DataSerializer)DataSerializers.field_187191_a);
    protected static final DataParameter<Byte> COLOR = EntityDataManager.func_187226_a(EntityHiShulker.class, (DataSerializer)DataSerializers.field_187191_a);
    public static final EnumDyeColor DEFAULT_COLOR = EnumDyeColor.RED;
    private float prevPeekAmount;
    private float peekAmount;
    private BlockPos currentAttachmentPosition;
    private int clientSideTeleportInterpolation;

    public EntityHiShulker(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70178_ae = true;
        this.currentAttachmentPosition = null;
        this.field_70728_aV = 5;
    }

    public int canSpawnByIDData() {
        return CalamityConfigMobs.hishulkerCanSpawnAssimilatedNat;
    }

    public int getParasiteIDRegister() {
        return 2149;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData data) {
        this.field_70761_aq = 180.0f;
        this.field_70760_ar = 180.0f;
        this.field_70177_z = 180.0f;
        this.field_70126_B = 180.0f;
        this.field_70759_as = 180.0f;
        this.field_70758_at = 180.0f;
        return super.func_180482_a(difficulty, data);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIAttack());
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIPeek());
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AIAttackNearest(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new AIDefenseAttack(this));
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187773_eO;
    }

    public void func_70642_aH() {
        if (!this.isClosed()) {
            super.func_70642_aH();
        }
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187781_eS;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return this.isClosed() ? SoundEvents.field_187785_eU : SoundEvents.field_187783_eT;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ATTACHED_FACE, (Object)EnumFacing.DOWN);
        this.field_70180_af.func_187214_a(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PEEK_TICK, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)((byte)DEFAULT_COLOR.func_176765_a()));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.HISHULKER_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(CalamityAttributes.HISHULKER_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.HISHULKER_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(CalamityAttributes.HISHULKER_KD_RESISTANCE);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_hishulker);
    }

    protected EntityBodyHelper func_184650_s() {
        return new BodyHelper((EntityLivingBase)this);
    }

    public static void registerFixesHiShulker(DataFixer dataFixer) {
        EntityLiving.func_189752_a((DataFixer)dataFixer, EntityHiShulker.class);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)EnumFacing.func_82600_a((int)compound.func_74771_c("AttachFace")));
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)compound.func_74771_c("Peek"));
        this.field_70180_af.func_187227_b(COLOR, (Object)compound.func_74771_c("Color"));
        if (compound.func_74764_b("APX")) {
            int i = compound.func_74762_e("APX");
            int j = compound.func_74762_e("APY");
            int k = compound.func_74762_e("APZ");
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)new BlockPos(i, j, k)));
        } else {
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.absent());
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("AttachFace", (byte)((EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE)).func_176745_a());
        compound.func_74774_a("Peek", ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue());
        compound.func_74774_a("Color", ((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue());
        BlockPos blockpos = this.getAttachmentPos();
        if (blockpos != null) {
            compound.func_74768_a("APX", blockpos.func_177958_n());
            compound.func_74768_a("APY", blockpos.func_177956_o());
            compound.func_74768_a("APZ", blockpos.func_177952_p());
        }
    }

    public void func_70071_h_() {
        float f1;
        super.func_70071_h_();
        BlockPos blockpos = (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull();
        if (blockpos == null && !this.field_70170_p.field_72995_K) {
            blockpos = new BlockPos((Entity)this);
            this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
        }
        if (this.func_184218_aH()) {
            blockpos = null;
            this.field_70177_z = f1 = this.func_184187_bx().field_70177_z;
            this.field_70761_aq = f1;
            this.field_70760_ar = f1;
            this.clientSideTeleportInterpolation = 0;
        } else if (!this.field_70170_p.field_72995_K) {
            BlockPos blockpos2;
            BlockPos blockpos1;
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                EnumFacing enumfacing3;
                if (iblockstate.func_177230_c() == Blocks.field_180384_M) {
                    enumfacing3 = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockPistonBase.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(enumfacing3))) {
                        blockpos = blockpos.func_177972_a(enumfacing3);
                        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
                    } else {
                        this.tryTeleportToNewPosition();
                    }
                } else if (iblockstate.func_177230_c() == Blocks.field_150332_K) {
                    enumfacing3 = (EnumFacing)iblockstate.func_177229_b((IProperty)BlockPistonExtension.field_176387_N);
                    if (this.field_70170_p.func_175623_d(blockpos.func_177972_a(enumfacing3))) {
                        blockpos = blockpos.func_177972_a(enumfacing3);
                        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos));
                    } else {
                        this.tryTeleportToNewPosition();
                    }
                } else {
                    this.tryTeleportToNewPosition();
                }
            }
            if (!this.field_70170_p.func_175677_d(blockpos1 = blockpos.func_177972_a(this.getAttachmentFacing()), false)) {
                EnumFacing[] var5;
                boolean flag = false;
                for (EnumFacing enumfacing1 : var5 = EnumFacing.values()) {
                    blockpos1 = blockpos.func_177972_a(enumfacing1);
                    if (!this.field_70170_p.func_175677_d(blockpos1, false)) continue;
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)enumfacing1);
                    flag = true;
                    break;
                }
                if (!flag) {
                    this.tryTeleportToNewPosition();
                }
            }
            if (this.field_70170_p.func_175677_d(blockpos2 = blockpos.func_177972_a(this.getAttachmentFacing().func_176734_d()), false)) {
                this.tryTeleportToNewPosition();
            }
        }
        f1 = (float)this.getPeekTick() * 0.01f;
        this.prevPeekAmount = this.peekAmount;
        if (this.peekAmount > f1) {
            this.peekAmount = MathHelper.func_76131_a((float)(this.peekAmount - 0.05f), (float)f1, (float)1.0f);
        } else if (this.peekAmount < f1) {
            this.peekAmount = MathHelper.func_76131_a((float)(this.peekAmount + 0.05f), (float)0.0f, (float)f1);
        }
        if (blockpos != null) {
            List list;
            if (this.field_70170_p.field_72995_K) {
                if (this.clientSideTeleportInterpolation > 0 && this.currentAttachmentPosition != null) {
                    --this.clientSideTeleportInterpolation;
                } else {
                    this.currentAttachmentPosition = blockpos;
                }
            }
            this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
            this.field_70163_u = blockpos.func_177956_o();
            this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
            if (this.isAddedToWorld() && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_72866_a((Entity)this, false);
            }
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
            double d3 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.peekAmount) * (float)Math.PI)) * 0.5;
            double d4 = 0.5 - (double)MathHelper.func_76126_a((float)((0.5f + this.prevPeekAmount) * (float)Math.PI)) * 0.5;
            double d5 = d3 - d4;
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            EnumFacing enumfacing2 = this.getAttachmentFacing();
            switch (enumfacing2) {
                case DOWN: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0 + d3, this.field_70161_v + 0.5));
                    d1 = d5;
                    break;
                }
                case UP: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u - d3, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d1 = -d5;
                    break;
                }
                case NORTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5 + d3));
                    d2 = d5;
                    break;
                }
                case SOUTH: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5 - d3, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d2 = -d5;
                    break;
                }
                case WEST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5 + d3, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d0 = d5;
                    break;
                }
                case EAST: {
                    this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5 - d3, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + 1.0, this.field_70161_v + 0.5));
                    d0 = -d5;
                }
            }
            if (d5 > 0.0 && !(list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ())).isEmpty()) {
                for (Entity entity : list) {
                    if (entity instanceof EntityHiShulker || entity.field_70145_X) continue;
                    entity.func_70091_d(MoverType.SHULKER, d0, d1, d2);
                }
            }
        }
    }

    public void func_70091_d(MoverType moverType, double p_move_2_, double p_move_4_, double p_move_6_) {
        if (moverType == MoverType.SHULKER_BOX) {
            this.tryTeleportToNewPosition();
        } else {
            super.func_70091_d(moverType, p_move_2_, p_move_4_, p_move_6_);
        }
    }

    public void func_70107_b(double p_setPosition_1_, double p_setPosition_3_, double p_setPosition_5_) {
        super.func_70107_b(p_setPosition_1_, p_setPosition_3_, p_setPosition_5_);
        if (this.field_70180_af != null && this.field_70173_aa != 0) {
            Optional optional = (Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS);
            Optional optional1 = Optional.of((Object)new BlockPos(p_setPosition_1_, p_setPosition_3_, p_setPosition_5_));
            if (!optional1.equals((Object)optional)) {
                this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)optional1);
                this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
                this.field_70160_al = true;
            }
        }
    }

    protected boolean tryTeleportToNewPosition() {
        if (!this.func_175446_cd() && this.func_70089_S()) {
            BlockPos blockpos = new BlockPos((Entity)this);
            for (int i = 0; i < 5; ++i) {
                EnumFacing[] var5;
                BlockPos blockpos1 = blockpos.func_177982_a(8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17), 8 - this.field_70146_Z.nextInt(17));
                if (blockpos1.func_177956_o() <= 0 || !this.field_70170_p.func_175623_d(blockpos1) || !this.field_70170_p.func_191503_g((Entity)this) || !this.field_70170_p.func_184144_a((Entity)this, new AxisAlignedBB(blockpos1)).isEmpty()) continue;
                boolean flag = false;
                for (EnumFacing enumfacing : var5 = EnumFacing.values()) {
                    if (!this.field_70170_p.func_175677_d(blockpos1.func_177972_a(enumfacing), false)) continue;
                    this.field_70180_af.func_187227_b(ATTACHED_FACE, (Object)enumfacing);
                    flag = true;
                    break;
                }
                if (flag) {
                    EnderTeleportEvent event = new EnderTeleportEvent((EntityLivingBase)this, (double)blockpos1.func_177958_n(), (double)blockpos1.func_177956_o(), (double)blockpos1.func_177952_p(), 0.0f);
                    if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                        flag = false;
                    }
                    blockpos1 = new BlockPos(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                }
                if (!flag) continue;
                this.func_184185_a(SoundEvents.field_187791_eX, 1.0f, 1.0f);
                this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.of((Object)blockpos1));
                this.field_70180_af.func_187227_b(PEEK_TICK, (Object)0);
                this.func_70624_b(null);
                return true;
            }
            return false;
        }
        return true;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70760_ar = 180.0f;
        this.field_70761_aq = 180.0f;
        this.field_70177_z = 180.0f;
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        BlockPos blockpos;
        if (ATTACHED_BLOCK_POS.equals(dataParameter) && this.field_70170_p.field_72995_K && !this.func_184218_aH() && (blockpos = this.getAttachmentPos()) != null) {
            if (this.currentAttachmentPosition == null) {
                this.currentAttachmentPosition = blockpos;
            } else {
                this.clientSideTeleportInterpolation = 6;
            }
            this.field_70165_t = (double)blockpos.func_177958_n() + 0.5;
            this.field_70163_u = blockpos.func_177956_o();
            this.field_70161_v = (double)blockpos.func_177952_p() + 0.5;
            this.field_70169_q = this.field_70165_t;
            this.field_70167_r = this.field_70163_u;
            this.field_70166_s = this.field_70161_v;
            this.field_70142_S = this.field_70165_t;
            this.field_70137_T = this.field_70163_u;
            this.field_70136_U = this.field_70161_v;
        }
        super.func_184206_a(dataParameter);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double p_setPositionAndRotationDirect_1_, double p_setPositionAndRotationDirect_3_, double p_setPositionAndRotationDirect_5_, float p_setPositionAndRotationDirect_7_, float p_setPositionAndRotationDirect_8_, int p_setPositionAndRotationDirect_9_, boolean p_setPositionAndRotationDirect_10_) {
        this.field_70716_bi = 0;
    }

    public boolean func_70097_a(DamageSource source, float p_attackEntityFrom_2_) {
        Entity entity;
        if (this.isClosed() && (entity = source.func_76364_f()) instanceof EntityArrow) {
            return false;
        }
        if (super.func_70097_a(source, p_attackEntityFrom_2_)) {
            if ((double)this.func_110143_aJ() < (double)this.func_110138_aP() * 0.5 && this.field_70146_Z.nextInt(4) == 0) {
                this.tryTeleportToNewPosition();
            }
            return true;
        }
        return false;
    }

    private boolean isClosed() {
        return this.getPeekTick() == 0;
    }

    @Nullable
    public AxisAlignedBB func_70046_E() {
        return this.func_70089_S() ? this.func_174813_aQ() : null;
    }

    public EnumFacing getAttachmentFacing() {
        return (EnumFacing)this.field_70180_af.func_187225_a(ATTACHED_FACE);
    }

    @Nullable
    public BlockPos getAttachmentPos() {
        return (BlockPos)((Optional)this.field_70180_af.func_187225_a(ATTACHED_BLOCK_POS)).orNull();
    }

    public void setAttachmentPos(@Nullable BlockPos p_setAttachmentPos_1_) {
        this.field_70180_af.func_187227_b(ATTACHED_BLOCK_POS, (Object)Optional.fromNullable((Object)p_setAttachmentPos_1_));
    }

    public int getPeekTick() {
        return ((Byte)this.field_70180_af.func_187225_a(PEEK_TICK)).byteValue();
    }

    public void updateArmorModifier(int p_updateArmorModifier_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(COVERED_ARMOR_BONUS_MODIFIER);
            if (p_updateArmorModifier_1_ == 0) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(COVERED_ARMOR_BONUS_MODIFIER);
                this.func_184185_a(SoundEvents.field_187779_eR, 1.0f, 1.0f);
            } else {
                this.func_184185_a(SoundEvents.field_187787_eV, 1.0f, 1.0f);
            }
        }
        this.field_70180_af.func_187227_b(PEEK_TICK, (Object)((byte)p_updateArmorModifier_1_));
    }

    @SideOnly(value=Side.CLIENT)
    public float getClientPeekAmount(float p_getClientPeekAmount_1_) {
        return this.prevPeekAmount + (this.peekAmount - this.prevPeekAmount) * p_getClientPeekAmount_1_;
    }

    @SideOnly(value=Side.CLIENT)
    public int getClientTeleportInterp() {
        return this.clientSideTeleportInterpolation;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockPos getOldAttachPos() {
        return this.currentAttachmentPosition;
    }

    public float func_70047_e() {
        return 0.5f;
    }

    public int func_70646_bf() {
        return 180;
    }

    public int func_184649_cE() {
        return 180;
    }

    public void func_70108_f(Entity p_applyEntityCollision_1_) {
    }

    public float func_70111_Y() {
        return 0.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isAttachedToBlock() {
        return this.currentAttachmentPosition != null && this.getAttachmentPos() != null;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186442_x;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumDyeColor getColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(COLOR)).byteValue());
    }

    class AIAttack
    extends EntityAIBase {
        private int attackTime;

        public AIAttack() {
            this.func_75248_a(3);
        }

        public boolean func_75250_a() {
            EntityLivingBase entitylivingbase = EntityHiShulker.this.func_70638_az();
            if (entitylivingbase != null && entitylivingbase.func_70089_S()) {
                return EntityHiShulker.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL;
            }
            return false;
        }

        public void func_75249_e() {
            this.attackTime = 20;
            EntityHiShulker.this.updateArmorModifier(100);
        }

        public void func_75251_c() {
            EntityHiShulker.this.updateArmorModifier(0);
        }

        public void func_75246_d() {
            if (EntityHiShulker.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL) {
                --this.attackTime;
                EntityLivingBase entitylivingbase = EntityHiShulker.this.func_70638_az();
                EntityHiShulker.this.func_70671_ap().func_75651_a((Entity)entitylivingbase, 180.0f, 180.0f);
                double d0 = EntityHiShulker.this.func_70068_e((Entity)entitylivingbase);
                if (d0 < 400.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20 + EntityHiShulker.this.field_70146_Z.nextInt(10) * 20 / 2;
                        EntityShulkerBullet entityshulkerbullet = new EntityShulkerBullet(EntityHiShulker.this.field_70170_p, (EntityLivingBase)EntityHiShulker.this, (Entity)entitylivingbase, EntityHiShulker.this.getAttachmentFacing().func_176740_k());
                        EntityHiShulker.this.field_70170_p.func_72838_d((Entity)entityshulkerbullet);
                        EntityHiShulker.this.func_184185_a(SoundEvents.field_187789_eW, 2.0f, (EntityHiShulker.this.field_70146_Z.nextFloat() - EntityHiShulker.this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
                    }
                } else {
                    EntityHiShulker.this.func_70624_b(null);
                }
                super.func_75246_d();
            }
        }
    }

    class AIAttackNearest
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackNearest(EntityHiShulker p_i47060_2_) {
            super((EntityCreature)p_i47060_2_, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return EntityHiShulker.this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && super.func_75250_a();
        }

        protected AxisAlignedBB func_188511_a(double p_getTargetableArea_1_) {
            EnumFacing enumfacing = ((EntityHiShulker)this.field_75299_d).getAttachmentFacing();
            if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, p_getTargetableArea_1_, p_getTargetableArea_1_);
            }
            return enumfacing.func_176740_k() == EnumFacing.Axis.Z ? this.field_75299_d.func_174813_aQ().func_72314_b(p_getTargetableArea_1_, p_getTargetableArea_1_, 4.0) : this.field_75299_d.func_174813_aQ().func_72314_b(p_getTargetableArea_1_, 4.0, p_getTargetableArea_1_);
        }
    }

    static class AIDefenseAttack
    extends EntityAINearestAttackableTarget<EntityLivingBase> {
        public AIDefenseAttack(EntityHiShulker shulker) {
            super((EntityCreature)shulker, EntityLivingBase.class, 10, true, false, Objects::nonNull);
        }

        public boolean func_75250_a() {
            return this.field_75299_d.func_96124_cp() != null && super.func_75250_a();
        }

        protected AxisAlignedBB func_188511_a(double p_getTargetableArea_1_) {
            EnumFacing enumfacing = ((EntityHiShulker)this.field_75299_d).getAttachmentFacing();
            if (enumfacing.func_176740_k() == EnumFacing.Axis.X) {
                return this.field_75299_d.func_174813_aQ().func_72314_b(4.0, p_getTargetableArea_1_, p_getTargetableArea_1_);
            }
            return enumfacing.func_176740_k() == EnumFacing.Axis.Z ? this.field_75299_d.func_174813_aQ().func_72314_b(p_getTargetableArea_1_, p_getTargetableArea_1_, 4.0) : this.field_75299_d.func_174813_aQ().func_72314_b(p_getTargetableArea_1_, 4.0, p_getTargetableArea_1_);
        }
    }

    class AIPeek
    extends EntityAIBase {
        private int peekTime;

        private AIPeek() {
        }

        public boolean func_75250_a() {
            return EntityHiShulker.this.func_70638_az() == null && EntityHiShulker.this.field_70146_Z.nextInt(40) == 0;
        }

        public boolean func_75253_b() {
            return EntityHiShulker.this.func_70638_az() == null && this.peekTime > 0;
        }

        public void func_75249_e() {
            this.peekTime = 20 * (1 + EntityHiShulker.this.field_70146_Z.nextInt(3));
            EntityHiShulker.this.updateArmorModifier(30);
        }

        public void func_75251_c() {
            if (EntityHiShulker.this.func_70638_az() == null) {
                EntityHiShulker.this.updateArmorModifier(0);
            }
        }

        public void func_75246_d() {
            --this.peekTime;
        }
    }

    class BodyHelper
    extends EntityBodyHelper {
        public BodyHelper(EntityLivingBase base) {
            super(base);
        }

        public void func_75664_a() {
        }
    }
}

