/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.inborn;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityAta;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPAttributes;
import com.dhanantry.scapeandrunparasites.world.SRPSaveData;
import com.maidarch.srpcalamity.entity.monster.inborn.EntityUlta;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import com.maidarch.srpcalamity.muon.CalamitySound;
import com.maidarch.srpcalamity.util.config.CalamityConfigSystems;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWaterMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySata
extends EntityParasiteBase {
    private final int totalGrowtime;
    private int actualGrowtime = 0;
    protected double buried;
    private static final String GROW = "gnatgrow";

    public EntitySata(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.4f);
        this.field_70728_aV = SRPAttributes.XP_LiTTLE;
        this.totalGrowtime = this.field_70146_Z.nextInt(30) + 30;
        this.killcount = -10.0;
        this.type = 1;
        this.buried = -1.0;
    }

    public int getParasiteIDRegister() {
        return 2112;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityLivingBase.class, entity -> !(entity instanceof EntityWaterMob) && !(entity instanceof EntityCreeper) && !(entity instanceof EntityParasiteBase) && !(entity instanceof EntityAnimal), 8.0f, 1.0, 1.0));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.SATA_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(CalamityAttributes.SATA_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.SATA_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(CalamityAttributes.SATA_KD_RESISTANCE);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_sata);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.growTimer();
        this.growStage();
        this.buried();
    }

    public boolean buried() {
        if (!(this.buried >= 0.0)) {
            if (this.getParasiteStatus() == 3) {
                this.setParasiteStatus(0);
            }
            return false;
        }
        this.func_70661_as().func_75499_g();
        this.field_70165_t = this.field_70169_q;
        this.field_70161_v = this.field_70166_s;
        int id = Block.func_176210_f((IBlockState)this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_177977_b()));
        this.buried -= 0.02;
        for (int i = 1; i <= 2; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_CRACK, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, new int[]{id});
        }
        return true;
    }

    protected void growStage() {
        if (!this.field_70170_p.field_72995_K && (this.actualGrowtime > this.totalGrowtime && ParasiteEventEntity.canSpawnNext || this.killcount > 1000.0)) {
            this.func_184185_a(SRPSounds.LODO_MUDO, 1.0f, 1.0f);
            ParasiteEventEntity.spawnNext((EntityParasiteBase)this, (EntityParasiteBase)this.getAdult(SRPSaveData.get((World)this.field_70170_p).getEvolutionPhase(this.field_70170_p.field_73011_w.getDimension())), (boolean)true, (boolean)false);
        }
    }

    private EntityParasiteBase getAdult(int phase) {
        switch (phase) {
            case 0: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSO ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 1: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSI ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 2: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSII ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 3: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSIII ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 4: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSIV ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 5: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSV ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 6: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSVI ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 7: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSVII ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 8: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSVIII ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 9: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSIX ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
            case 10: {
                return this.field_70146_Z.nextDouble() < (double)CalamityConfigSystems.sataGrowSX ? new EntityUlta(this.field_70170_p) : new EntityAta(this.field_70170_p);
            }
        }
        return new EntityAta(this.field_70170_p);
    }

    protected void growTimer() {
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0) {
            ++this.actualGrowtime;
        }
    }

    @ParametersAreNonnullByDefault
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        return super.func_184645_a(player, hand);
    }

    public float func_70047_e() {
        return 0.3f;
    }

    public static void registerFixesSata(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntitySata.class);
    }

    protected SoundEvent func_184639_G() {
        return CalamitySound.SATA_GROWL;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return CalamitySound.SATA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return CalamitySound.SATA_DEATH;
    }

    @ParametersAreNonnullByDefault
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a(GROW, this.actualGrowtime);
    }

    @ParametersAreNonnullByDefault
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b(GROW, 99)) {
            this.actualGrowtime = compound.func_74762_e(GROW);
        }
    }

    public void setFloorTimer() {
        this.buried = 1.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double getFloorTimer() {
        return this.buried;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 50) {
            this.buried = 1.0;
        } else {
            super.func_70103_a(id);
        }
    }
}

