/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.infected.head;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAvoidEntityStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAvoidOrAttack;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPInfected;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.crude.EntityInhooM;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import com.maidarch.srpcalamity.entity.ai.EntityAISkillOnlyGround;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfSquidG;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityInfSquidGHead
extends EntityPInfected {
    boolean searchingForLand;
    protected final PathNavigateSwimmer waterNavigation;
    protected final PathNavigate groundNavigation;

    public EntityInfSquidGHead(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.7f, 0.95f);
        this.killcount = -10.0;
        this.field_70765_h = new DrownedMoveHelper(this);
        this.func_184644_a(PathNodeType.WATER, 1.0f);
        this.waterNavigation = new PathNavigateSwimmer((EntityLiving)this, worldIn);
        this.groundNavigation = new PathNavigateGround((EntityLiving)this, worldIn);
    }

    public int getParasiteIDRegister() {
        return 2134;
    }

    public int canSpawnByIDData() {
        return SRPConfigMobs.infsquidCanSpawnAssimilatedNat;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISkillOnlyGround((EntityParasiteBase)this, 40, 100, 3, true, 14));
        this.setskillLeapValues(0.7f, 1.5, 0);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new DrownedGoToWaterTarget((EntityCreature)this, 10.3));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new DrownedGoToBeachGoal(this, 1.3));
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new DrownedSwimUpTarget(this, 1.3, this.field_70170_p.func_181545_F()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMeleeStatus((EntityParasiteBase)this, 1.3, false, -1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAvoidOrAttack((EntityParasiteBase)this, 0.5f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIAvoidEntityStatus((EntityParasiteBase)this, EntityLivingBase.class, entity -> !(entity instanceof EntityCreeper) && !(entity instanceof EntityParasiteBase) && !(entity instanceof EntityAnimal), 8.0f, 1.3));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityInhooM.class, true));
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_infsquidghead);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.INFSQUIDG_HEADHEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.INFSQUIDG_HEADDAMAGE);
    }

    public boolean func_70648_aU() {
        return true;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (this.func_70089_S() && !this.func_70090_H()) {
            this.func_70050_g(--i);
            if (this.func_70086_ai() == -20) {
                this.func_70050_g(0);
                this.func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        } else {
            this.func_70050_g(300);
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    public float func_70599_aP() {
        return 0.3f;
    }

    @ParametersAreNonnullByDefault
    public boolean func_70652_k(Entity entityIn) {
        if (entityIn instanceof EntityInhooM && entityIn.func_70089_S() && this.func_70089_S()) {
            ParasiteEventEntity.spawnNext((EntityParasiteBase)this, (EntityParasiteBase)new EntityInfSquidG(this.field_70170_p), (boolean)true, (boolean)false);
            ((EntityParasiteBase)entityIn).particleStatus((byte)7);
            entityIn.func_70106_y();
            return true;
        }
        return super.func_70652_k(entityIn);
    }

    @ParametersAreNonnullByDefault
    public boolean func_70686_a(Class<? extends EntityLivingBase> cls) {
        if (cls != EntityPlayer.class && cls != EntityPlayerMP.class) {
            String name;
            try {
                name = Objects.requireNonNull(EntityList.func_191306_a(cls)).toString();
            }
            catch (Exception var4) {
                return true;
            }
            if (name.contains("srparasites") && cls != EntityInhooM.class) {
                return false;
            }
            return !SRPConfig.mobAttackingFull || !ParasiteEventEntity.checkName((String)name, (String[])SRPConfig.mobattackingBlackList, (boolean)SRPConfig.mobattackingBlackListWhite);
        }
        return true;
    }

    public static void registerFixesInfSquidGHead(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityInfSquidGHead.class);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier * 0.3f);
    }

    protected SoundEvent func_184639_G() {
        return this.getParasiteStatus() != 0 ? SRPSounds.MOBSILENCE : SRPSounds.INFECTEDHEAD_GROWL;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SRPSounds.INFECTEDHEAD_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SRPSounds.INFECTEDHEAD_DEATH;
    }

    @ParametersAreNonnullByDefault
    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(this.getStepSound(), this.func_70599_aP(), this.func_70647_i());
    }

    protected SoundEvent getStepSound() {
        return SRPSounds.SMALL_STEPS;
    }

    public void setSearchingForLand(boolean pSearchingForLand) {
        this.searchingForLand = pSearchingForLand;
    }

    boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        EntityLivingBase entity = this.func_70638_az();
        return entity != null && entity.func_70090_H();
    }

    protected float rotlerp(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
        float f1;
        float f = MathHelper.func_76142_g((float)(pTargetAngle - pSourceAngle));
        if (f > pMaximumChange) {
            f = pMaximumChange;
        }
        if (f < -pMaximumChange) {
            f = -pMaximumChange;
        }
        if ((f1 = pSourceAngle + f) < 0.0f) {
            f1 += 360.0f;
        } else if (f1 > 360.0f) {
            f1 -= 360.0f;
        }
        return f1;
    }

    protected boolean closeToNextPos() {
        Path path = this.func_70661_as().func_75505_d();
        if (path != null && path.func_189964_i() != null) {
            BlockPos pos = new BlockPos(path.func_189964_i().field_75839_a, path.func_189964_i().field_75837_b, path.func_189964_i().field_75838_c);
            return this.func_70011_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < 4.0;
        }
        return false;
    }

    public static float lerp(float pDelta, float pStart, float pEnd) {
        return pStart + pDelta * (pEnd - pStart);
    }

    static class DrownedSwimUpTarget
    extends EntityAITarget {
        private final EntityInfSquidGHead drowned;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public DrownedSwimUpTarget(EntityInfSquidGHead pDrowned, double pSpeedModifier, int pSeaLevel) {
            super((EntityCreature)pDrowned, false);
            this.drowned = pDrowned;
            this.speedModifier = pSpeedModifier;
            this.seaLevel = pSeaLevel;
        }

        public boolean func_75250_a() {
            return !this.drowned.field_70170_p.func_72935_r() && this.drowned.func_70090_H() && this.drowned.field_70163_u < (double)(this.seaLevel - 2);
        }

        public boolean func_75253_b() {
            return this.func_75250_a() && !this.stuck;
        }

        public void func_75251_c() {
            Path currentPath = this.drowned.func_70661_as().func_75505_d();
            if (currentPath == null || currentPath.func_189964_i() == null) {
                this.stuck = true;
                return;
            }
            if (this.drowned.field_70163_u < (double)(this.seaLevel - 1) && (!this.drowned.func_70605_aq().func_75640_a() || this.drowned.closeToNextPos())) {
                Vec3d $$0 = RandomPositionGenerator.func_75464_a((EntityCreature)this.drowned, (int)4, (int)8, (Vec3d)new Vec3d(this.drowned.field_70165_t, (double)(this.seaLevel - 1), this.drowned.field_70161_v));
                if ($$0 == null) {
                    this.stuck = true;
                    return;
                }
                this.drowned.func_70605_aq().func_75642_a($$0.field_72450_a, $$0.field_72448_b, $$0.field_72449_c, this.speedModifier);
            }
        }

        public void func_75249_e() {
            this.drowned.setSearchingForLand(true);
            if (this.drowned.groundNavigation != null) {
                this.drowned.groundNavigation.func_75499_g();
            }
            this.drowned.field_70699_by = (PathNavigate)this.drowned.waterNavigation;
            this.stuck = false;
        }
    }

    private static class DrownedGoToBeachGoal
    extends EntityAIMoveToBlock {
        private final EntityInfSquidGHead drowned;

        public DrownedGoToBeachGoal(EntityInfSquidGHead pDrowned, double pSpeedModifier) {
            super((EntityCreature)pDrowned, pSpeedModifier, 8);
            this.drowned = pDrowned;
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !this.drowned.field_70170_p.func_72935_r() && this.drowned.func_70090_H() && this.drowned.field_70163_u >= (double)(this.drowned.field_70170_p.func_181545_F() - 3);
        }

        public boolean func_75253_b() {
            return super.func_75253_b();
        }

        protected boolean func_179488_a(World world, BlockPos pPos) {
            BlockPos upPos = pPos.func_177984_a();
            return world.func_175623_d(upPos) && world.func_175623_d(upPos.func_177984_a()) && world.func_180495_p(pPos).func_185917_h();
        }

        public void func_75249_e() {
            this.drowned.setSearchingForLand(false);
            this.drowned.field_70699_by = this.drowned.groundNavigation;
            super.func_75249_e();
        }
    }

    private static class DrownedGoToWaterTarget
    extends EntityAITarget {
        private final EntityCreature mob;
        private double wantedX;
        private double wantedY;
        private double wantedZ;
        private final double speedModifier;
        private final World level;

        public DrownedGoToWaterTarget(EntityCreature pMob, double pSpeedModifier) {
            super(pMob, false);
            this.mob = pMob;
            this.speedModifier = pSpeedModifier;
            this.level = pMob.func_130014_f_();
        }

        public boolean func_75250_a() {
            if (this.mob.func_70090_H() || this.mob.func_70086_ai() > 200) {
                return false;
            }
            Vec3d $$0 = this.getWaterPos();
            if ($$0 == null) {
                return false;
            }
            this.wantedX = $$0.field_72450_a;
            this.wantedY = $$0.field_72448_b;
            this.wantedZ = $$0.field_72449_c;
            return true;
        }

        public boolean func_75253_b() {
            return this.mob.func_70605_aq().func_75640_a();
        }

        public void func_75249_e() {
            this.mob.func_70605_aq().func_75642_a(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        @Nullable
        private Vec3d getWaterPos() {
            Random random = this.mob.func_70681_au();
            BlockPos prePos = this.mob.func_180425_c();
            for (int i = 0; i < 10; ++i) {
                BlockPos pos = prePos.func_177982_a(random.nextInt(20) - 10, 2 - random.nextInt(8), random.nextInt(20) - 10);
                if (this.level.func_180495_p(pos).func_177230_c() != Blocks.field_150355_j) continue;
                return new Vec3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
            }
            return null;
        }
    }

    private class DrownedMoveHelper
    extends EntityMoveHelper {
        private final EntityInfSquidGHead drowned;

        public DrownedMoveHelper(EntityInfSquidGHead pDrowned) {
            super((EntityLiving)pDrowned);
            this.drowned = pDrowned;
        }

        public void func_75641_c() {
            EntityLivingBase enermy = this.drowned.func_70638_az();
            if (this.drowned.wantsToSwim() && this.drowned.func_70090_H()) {
                if (enermy != null && enermy.field_70163_u > this.drowned.field_70163_u || this.drowned.searchingForLand) {
                    EntityInfSquidGHead.this.field_70181_x += 0.02;
                }
                if (this.field_188491_h != EntityMoveHelper.Action.MOVE_TO || !this.drowned.func_70605_aq().func_75640_a()) {
                    this.drowned.func_70657_f(0.0f);
                    return;
                }
                double d0 = this.field_75646_b - this.drowned.field_70165_t;
                double d1 = this.field_75647_c - this.drowned.field_70163_u;
                double d2 = this.field_75644_d - this.drowned.field_70161_v;
                double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                d1 /= d3;
                float $$5 = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.drowned.func_70034_d(this.func_75639_a(this.drowned.func_70079_am(), $$5, 90.0f));
                this.drowned.field_70177_z = this.drowned.func_70079_am();
                float maxV = (float)(this.field_75645_e * this.drowned.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b());
                float rot = EntityInfSquidGHead.this.rotlerp(0.125f, this.drowned.func_70646_bf(), maxV);
                this.drowned.func_70657_f(rot);
                EntityInfSquidGHead.this.field_70159_w = (double)rot * d0 * 0.005;
                EntityInfSquidGHead.this.field_70181_x = (double)rot * d1 * 0.1;
                EntityInfSquidGHead.this.field_70179_y = (double)rot * d2 * 0.005;
            } else {
                if (!this.drowned.field_70122_E) {
                    EntityInfSquidGHead.this.field_70181_x -= 0.008;
                }
                super.func_75641_c();
            }
        }
    }
}

