/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.entity.monster.primitive;

import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIAttackMeleeStatus;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAIEvade;
import com.dhanantry.scapeandrunparasites.entity.ai.EntityAISkill;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityCanSummon;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityPPrimitive;
import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.init.SRPSounds;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfig;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigSystems;
import com.maidarch.srpcalamity.entity.monster.crude.EntityCuleL;
import com.maidarch.srpcalamity.entity.monster.crude.EntityCuleS;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamityAttributes;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateSwimmer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityAira
extends EntityPPrimitive
implements EntityCanSummon {
    private int totalP = CalamityConfigMobs.airaTotalActiveMobs;
    private int actualP = 0;
    private int[] mobID = new int[this.totalP + CalamityConfigMobs.airaLimit];
    private int[] mobPT = new int[this.totalP + CalamityConfigMobs.airaLimit];
    private int limit;
    private int border;
    private boolean skillSummon;

    public EntityAira(World worldIn) {
        super(worldIn);
        this.func_70105_a(1.5f, 1.2f);
        Arrays.fill(this.mobID, -777);
        this.skillSummon = false;
        this.field_70765_h = new AIMoveControl(this);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.folow);
        this.field_70714_bg.func_85156_a((EntityAIBase)this.aiWander);
    }

    public int getParasiteIDRegister() {
        return 2228;
    }

    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAISkill((EntityParasiteBase)this, 20 * CalamityConfigMobs.airaSummoningCooldown, 16, true, 1));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMeleeStatus((EntityParasiteBase)this, 1.3, false, 4.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new AIMoveRandom());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIEvade((EntityParasiteBase)this, 55, 10, 4));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(CalamityAttributes.AIRA_HEALTH);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(CalamityAttributes.AIRA_ARMOR);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(CalamityAttributes.AIRA_ATTACK_DAMAGE);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(CalamityAttributes.AIRA_KD_RESISTANCE);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(SRPConfig.primitiveFollow);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack getPickedResult(RayTraceResult rayTraceResult) {
        return new ItemStack(CCCItems.itemmobspawner_aira);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateSwimmer((EntityLiving)this, worldIn);
    }

    public void func_70636_d() {
        if (!this.func_175446_cd()) {
            this.liquidLeap = 0;
            super.func_70636_d();
            this.func_189654_d(this.field_70171_ac);
            this.liquidLeap = 0;
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70638_az() != null) {
                    this.setParasiteStatus(1);
                }
                if (this.field_70173_aa % 20 == 0) {
                    // empty if block
                }
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 20 == 0 && this.field_70146_Z.nextInt(2) == 0 && this.field_70173_aa % 60 == 0) {
            boolean flag = false;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0).func_186662_g(16.0);
            List moblist = this.field_70170_p.func_72872_a(EntityCuleL.class, axisalignedbb);
            for (EntityCuleL mob : moblist) {
                if (mob.getActive()) continue;
                mob.setPlus(CalamityConfigMobs.airaVacuolePlus);
                mob.func_70606_j(CalamityConfigMobs.airaVacuoleHealth);
                flag = true;
            }
            if (flag) {
                this.func_184185_a(SRPSounds.CANRA_SPECIAL, 3.0f, 1.0f);
                this.particleStatus((byte)8);
            }
        }
    }

    @ParametersAreNonnullByDefault
    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, amount);
    }

    @ParametersAreNonnullByDefault
    public boolean func_70652_k(Entity entityIn) {
        boolean flag = super.func_70652_k(entityIn);
        if (flag) {
            // empty if block
        }
        return flag;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.5f;
    }

    @ParametersAreNonnullByDefault
    public void func_70074_a(EntityLivingBase entityLivingIn) {
        super.func_70074_a(entityLivingIn);
    }

    protected void spawnGore() {
        EntityCuleL nnn = new EntityCuleL(this.field_70170_p);
        nnn.func_70012_b((double)this.func_180425_c().func_177958_n() + 0.5, this.func_180425_c().func_177956_o(), (double)this.func_180425_c().func_177952_p() + 0.5, 0.0f, 0.0f);
        nnn.setParasite(Objects.requireNonNull(EntityList.func_191301_a((Entity)this)).toString());
        nnn.setDeadSkin((byte)this.getSkin());
        nnn.setSkin(2);
        nnn.setGoal(20 * SRPConfig.infectedRemainValue);
        this.field_70170_p.func_72838_d((Entity)nnn);
        for (int i = 0; i < 3 && SRPConfig.paraGore; ++i) {
            double d0 = (float)this.field_70165_t + this.field_70170_p.field_73012_v.nextFloat();
            double d1 = (float)this.field_70163_u + this.field_70170_p.field_73012_v.nextFloat();
            double d2 = (float)this.field_70161_v + this.field_70170_p.field_73012_v.nextFloat();
            double d3 = d0 - this.field_70165_t;
            double d4 = d1 - this.field_70163_u;
            double d5 = d2 - this.field_70161_v;
            double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
            d3 /= d6;
            d4 /= d6;
            d5 /= d6;
            double d7 = 0.5 / (d6 / 4.0 + 0.1);
            d4 = d4 * d7 * 2.0;
            EntityCuleS bomb = new EntityCuleS(this.field_70170_p);
            bomb.setSkin(2);
            bomb.func_82149_j((Entity)this);
            bomb.setMotion(d3 *= (d7 *= (double)(this.field_70170_p.field_73012_v.nextFloat() * this.field_70170_p.field_73012_v.nextFloat() + 0.3f)), d4, d5 *= d7, 0.1, 0.5);
            this.field_70170_p.func_72838_d((Entity)bomb);
        }
    }

    public boolean scaryOrbEffect(EntityLivingBase in, int mobs) {
        boolean flag = super.scaryOrbEffect(in, mobs);
        if (flag) {
            ParasiteEventEntity.orbApplyEffects((EntityLivingBase)in, (EntityParasiteBase)this, (String[])CalamityConfigMobs.airaOrbEffects, (int)mobs);
        }
        return flag;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184639_G() {
        return this.getParasiteStatus() != 0 ? SRPSounds.MOBSILENCE : SRPSounds.LUM_GROWL;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.field_70146_Z.nextBoolean() && this.getHitStatus() > 0 ? SRPSounds.MOBSILENCE : SRPSounds.LUM_HURT;
    }

    @ParametersAreNonnullByDefault
    protected SoundEvent func_184615_bR() {
        return SRPSounds.LUM_DEATH;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70601_bi() {
        return true;
    }

    public boolean func_70058_J() {
        return this.field_70170_p.func_72917_a(this.func_174813_aQ(), (Entity)this);
    }

    public int func_70627_aG() {
        return 0;
    }

    public boolean func_70692_ba() {
        return true;
    }

    public void func_70030_z() {
        int i = this.func_70086_ai();
        super.func_70030_z();
        if (!this.func_175446_cd()) {
            if (this.func_70089_S() && !this.func_70090_H()) {
                this.func_70050_g(--i);
                if (this.func_70086_ai() == -20) {
                    this.func_70050_g(0);
                    this.func_70097_a(DamageSource.field_76369_e, 2.0f);
                }
            } else {
                this.func_70050_g(300);
            }
        }
    }

    public boolean func_96092_aw() {
        return false;
    }

    @ParametersAreNonnullByDefault
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData floo = super.func_180482_a(difficulty, livingdata);
        if (this.field_70146_Z.nextDouble() < SRPConfig.variantChance || this.phaseCreated >= SRPConfigSystems.evolutionParasiteAlwaysVariant || this.canChangeVariant) {
            switch (this.field_70146_Z.nextInt(1)) {
                case 0: {
                    this.setSkin(7);
                }
            }
        }
        return floo;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        this.func_145775_I();
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public static void registerFixesAira(DataFixer fixer) {
        EntityLiving.func_189752_a((DataFixer)fixer, EntityAira.class);
    }

    public boolean getFinished(byte attID) {
        switch (attID) {
            case 1: {
                return this.skillSummon;
            }
        }
        return super.getFinished(attID);
    }

    public void setFinished(byte attID, boolean in) {
        switch (attID) {
            case 1: {
                this.skillSummon = in;
                return;
            }
        }
        super.setFinished(attID, in);
    }

    public void doSpecialSkill(byte id) {
        switch (id) {
            case 1: {
                this.summon();
                return;
            }
        }
        super.doSpecialSkill(id);
    }

    private void summon() {
        this.setParasiteStatus(10);
        this.func_70661_as().func_75499_g();
        if (this.field_70173_aa % 20 == 0) {
            ++this.border;
            if (this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockLiquid) {
                this.skillSummon = true;
                this.setParasiteStatus(0);
                this.border = 0;
                this.limit = 0;
            } else {
                this.checkID();
                if (this.getActualParasites() < this.getTotalParasites() && this.limit < CalamityConfigMobs.airaLimit) {
                    this.func_184185_a(SRPSounds.CANRA_SPECIAL, 3.0f, 1.0f);
                    if (ParasiteEventEntity.spawnBiomassFromVomit((EntityParasiteBase)this, (String[])CalamityConfigMobs.airaMobList, (EntityLivingBase)this.func_70638_az())) {
                        ++this.limit;
                        --this.border;
                        this.particleStatus((byte)8);
                    }
                } else {
                    ++this.border;
                }
                if (this.limit >= CalamityConfigMobs.airaLimit || this.border > 4) {
                    this.skillSummon = true;
                    this.setParasiteStatus(0);
                    this.border = 0;
                    this.limit = 0;
                }
            }
        }
    }

    public int getTotalParasites() {
        return this.totalP;
    }

    public int getActualParasites() {
        return this.actualP;
    }

    public void setActualParasites(int i) {
        this.actualP += i;
    }

    public void addID(int id, int points) {
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            this.mobID[i] = id;
            this.mobPT[i] = points;
            return;
        }
    }

    public int IDable() {
        int flag = 0;
        for (int i = 0; i < this.mobID.length; ++i) {
            if (this.mobID[i] != -777) continue;
            ++flag;
        }
        if (flag > this.totalP) {
            flag = this.totalP;
        }
        return flag;
    }

    public void checkID() {
        for (int i = 0; i < this.mobID.length; ++i) {
            Entity flag;
            if (this.mobID[i] <= 0 || (flag = this.field_70170_p.func_73045_a(this.mobID[i])) != null) continue;
            this.mobID[i] = -777;
            int negative = this.mobPT[i] * -1;
            this.setActualParasites(negative);
        }
    }

    public int[] getIDList() {
        return null;
    }

    public int[] getPointList() {
        return null;
    }

    class AIMoveControl
    extends EntityMoveHelper {
        public AIMoveControl(EntityAira vex) {
            super((EntityLiving)vex);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                double d0 = this.field_75646_b - EntityAira.this.field_70165_t;
                double d1 = this.field_75647_c - EntityAira.this.field_70163_u;
                double d2 = this.field_75644_d - EntityAira.this.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if ((d3 = (double)MathHelper.func_76133_a((double)d3)) < EntityAira.this.func_174813_aQ().func_72320_b()) {
                    this.field_188491_h = EntityMoveHelper.Action.WAIT;
                    EntityAira.this.field_70159_w *= 0.5;
                    EntityAira.this.field_70181_x *= 0.5;
                    EntityAira.this.field_70179_y *= 0.5;
                } else {
                    EntityAira.this.field_70159_w += d0 / d3 * 0.05 * this.field_75645_e;
                    EntityAira.this.field_70181_x += d1 / d3 * 0.05 * this.field_75645_e;
                    EntityAira.this.field_70179_y += d2 / d3 * 0.05 * this.field_75645_e;
                    if (EntityAira.this.func_70638_az() == null) {
                        EntityAira.this.field_70761_aq = EntityAira.this.field_70177_z = -((float)MathHelper.func_181159_b((double)EntityAira.this.field_70159_w, (double)EntityAira.this.field_70179_y)) * 57.295776f;
                    } else {
                        double d4 = EntityAira.this.func_70638_az().field_70165_t - EntityAira.this.field_70165_t;
                        double d5 = EntityAira.this.func_70638_az().field_70161_v - EntityAira.this.field_70161_v;
                        EntityAira.this.field_70761_aq = EntityAira.this.field_70177_z = -((float)MathHelper.func_181159_b((double)d4, (double)d5)) * 57.295776f;
                    }
                }
            }
        }
    }

    class AIMoveRandom
    extends EntityAIBase {
        public AIMoveRandom() {
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return EntityAira.this.field_70146_Z.nextInt(7) == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            BlockPos blockpos = new BlockPos((Entity)EntityAira.this);
            int flag = 1;
            double speed = 0.19;
            if (EntityAira.this.func_70638_az() != null) {
                if (EntityAira.this.func_70068_e((Entity)EntityAira.this.func_70638_az()) > 100.0) {
                    blockpos = new BlockPos((Entity)EntityAira.this.func_70638_az());
                    flag = 2;
                } else if (EntityAira.this.func_70068_e((Entity)EntityAira.this.func_70638_az()) < 36.0) {
                    blockpos = new BlockPos((Entity)EntityAira.this.func_70638_az());
                    flag = 3;
                }
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos blockpos1 = blockpos.func_177982_a(EntityAira.this.field_70146_Z.nextInt(15) - 7, EntityAira.this.field_70146_Z.nextInt(11) - 5, EntityAira.this.field_70146_Z.nextInt(15) - 7);
                if (flag == 2) {
                    blockpos1 = blockpos.func_177982_a(EntityAira.this.field_70146_Z.nextInt(6) - 2, EntityAira.this.field_70146_Z.nextInt(7) - 2, EntityAira.this.field_70146_Z.nextInt(6) - 2);
                } else if (flag == 3) {
                    blockpos1 = blockpos.func_177982_a(EntityAira.this.field_70146_Z.nextInt(4) + 3, EntityAira.this.field_70146_Z.nextInt(5) + 4, EntityAira.this.field_70146_Z.nextInt(4) + 3);
                }
                if (EntityAira.this.field_70170_p.func_180495_p(blockpos1).func_185904_a() != Material.field_151586_h) continue;
                EntityAira.this.field_70765_h.func_75642_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, speed);
                if (EntityAira.this.func_70638_az() != null) break;
                EntityAira.this.func_70671_ap().func_75650_a((double)blockpos1.func_177958_n() + 0.5, (double)blockpos1.func_177956_o() + 0.5, (double)blockpos1.func_177952_p() + 0.5, 180.0f, 20.0f);
                break;
            }
        }
    }
}

