/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.item;

import com.dhanantry.scapeandrunparasites.entity.ai.misc.EntityParasiteBase;
import com.dhanantry.scapeandrunparasites.entity.monster.EntityBiomass;
import com.dhanantry.scapeandrunparasites.entity.monster.EntityTendril;
import com.dhanantry.scapeandrunparasites.entity.monster.ancient.EntityOroncoTen;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityDodT;
import com.dhanantry.scapeandrunparasites.entity.monster.deterrent.EntityRof;
import com.dhanantry.scapeandrunparasites.entity.monster.feral.EntityFerWolf;
import com.dhanantry.scapeandrunparasites.entity.monster.hijacked.EntityHiBlaze;
import com.dhanantry.scapeandrunparasites.entity.monster.hijacked.EntityHiSkeleton;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityAta;
import com.dhanantry.scapeandrunparasites.entity.monster.inborn.EntityKol;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityAlafha;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.EntityOmboo;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.preeminent.EntityFlam;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.preeminent.EntityJinjo;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.preeminent.EntitySoo;
import com.dhanantry.scapeandrunparasites.entity.monster.pure.preeminent.EntityTenn;
import com.dhanantry.scapeandrunparasites.entity.projectile.EntityBomb;
import com.dhanantry.scapeandrunparasites.util.ParasiteEventEntity;
import com.dhanantry.scapeandrunparasites.util.SRPAttributes;
import com.dhanantry.scapeandrunparasites.util.config.SRPConfigMobs;
import com.maidarch.srpcalamity.entity.monster.adapted.EntityXezoguAdapted;
import com.maidarch.srpcalamity.entity.monster.ancient.EntityMikan;
import com.maidarch.srpcalamity.entity.monster.crude.EntityCuleS;
import com.maidarch.srpcalamity.entity.monster.crude.EntityMuje;
import com.maidarch.srpcalamity.entity.monster.crude.EntityVolk;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerDonkey;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerFox;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerLlama;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerMule;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerPillager;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerSquid;
import com.maidarch.srpcalamity.entity.monster.feral.EntityFerSquidG;
import com.maidarch.srpcalamity.entity.monster.feral.EntityForla;
import com.maidarch.srpcalamity.entity.monster.hijacked.EntityHiShulker;
import com.maidarch.srpcalamity.entity.monster.hijacked.EntityHiSnow;
import com.maidarch.srpcalamity.entity.monster.hijacked.EntityHiWitherBone;
import com.maidarch.srpcalamity.entity.monster.inborn.EntityLoli;
import com.maidarch.srpcalamity.entity.monster.inborn.EntityPithol;
import com.maidarch.srpcalamity.entity.monster.inborn.EntitySata;
import com.maidarch.srpcalamity.entity.monster.inborn.EntityShol;
import com.maidarch.srpcalamity.entity.monster.inborn.EntityUlta;
import com.maidarch.srpcalamity.entity.monster.inborn.EntityXor;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfDonkey;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfFox;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfLlama;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfMule;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfPillager;
import com.maidarch.srpcalamity.entity.monster.infected.EntityInfSquidG;
import com.maidarch.srpcalamity.entity.monster.infected.TTF.EntityInfBoar;
import com.maidarch.srpcalamity.entity.monster.infected.TTF.head.EntityInfBoarHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityDorpaHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfBearHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfDonkeyHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfFoxHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfLlamaHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfMuleHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfPillagerHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfSquidGHead;
import com.maidarch.srpcalamity.entity.monster.infected.head.EntityInfSquidHead;
import com.maidarch.srpcalamity.entity.monster.primitive.EntityAira;
import com.maidarch.srpcalamity.entity.monster.primitive.EntityKucum;
import com.maidarch.srpcalamity.entity.monster.primitive.EntityVaz;
import com.maidarch.srpcalamity.entity.monster.primitive.EntityXezogu;
import com.maidarch.srpcalamity.entity.projectile.EntityBombMikan;
import com.maidarch.srpcalamity.item.ItemSC;
import com.maidarch.srpcalamity.util.config.CalamityConfigMobs;
import com.maidarch.srpcalamity.util.config.CalamityTFConfigMobs;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMobSpawner
extends ItemSC {
    private final String name;

    public ItemMobSpawner(String name) {
        super("itemmobspawner_" + name);
        this.name = name;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (worldIn.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (!player.func_175151_a(pos.func_177972_a(facing), facing, itemstack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (block == Blocks.field_150474_ac) {
            worldIn.func_175625_s(pos);
        }
        BlockPos blockpos = pos.func_177972_a(facing);
        double d0 = this.getYOffset(worldIn, blockpos);
        Entity entity = this.spawnEntity(worldIn, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + d0, (double)blockpos.func_177952_p() + 0.5, player);
        if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
            entity.func_96094_a(itemstack.func_82833_r());
        }
        ItemMobSpawner.applyItemEntityDataToEntity(worldIn, player, itemstack, entity);
        if (!player.field_71075_bZ.field_75098_d) {
            itemstack.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    protected double getYOffset(World world, BlockPos pos) {
        AxisAlignedBB axisalignedbb = new AxisAlignedBB(pos).func_72321_a(0.0, -1.0, 0.0);
        List list = world.func_184144_a(null, axisalignedbb);
        if (list.isEmpty()) {
            return 0.0;
        }
        double d0 = axisalignedbb.field_72338_b;
        for (AxisAlignedBB axisalignedbb1 : list) {
            d0 = Math.max(axisalignedbb1.field_72337_e, d0);
        }
        return d0 - (double)pos.func_177956_o();
    }

    public static void applyItemEntityDataToEntity(World entityWorld, @Nullable EntityPlayer player, ItemStack stack, @Nullable Entity targetEntity) {
        NBTTagCompound nbttagcompound;
        MinecraftServer minecraftserver = entityWorld.func_73046_m();
        if (minecraftserver != null && targetEntity != null && (nbttagcompound = stack.func_77978_p()) != null && nbttagcompound.func_150297_b("EntityTag", 10)) {
            if (!(entityWorld.field_72995_K || !targetEntity.func_184213_bq() || player != null && minecraftserver.func_184103_al().func_152596_g(player.func_146103_bH()))) {
                return;
            }
            NBTTagCompound nbttagcompound1 = targetEntity.func_189511_e(new NBTTagCompound());
            UUID uuid = targetEntity.func_110124_au();
            nbttagcompound1.func_179237_a(nbttagcompound.func_74775_l("EntityTag"));
            targetEntity.func_184221_a(uuid);
            targetEntity.func_70020_e(nbttagcompound1);
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (worldIn.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
        }
        RayTraceResult raytraceresult = this.func_77621_a(worldIn, playerIn, true);
        if (raytraceresult.field_72313_a == RayTraceResult.Type.BLOCK) {
            BlockPos blockpos = raytraceresult.func_178782_a();
            if (!(worldIn.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid)) {
                return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
            }
            if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos, raytraceresult.field_178784_b, itemstack)) {
                Entity entity = this.spawnEntity(worldIn, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, playerIn);
                if (entity instanceof EntityLivingBase && itemstack.func_82837_s()) {
                    entity.func_96094_a(itemstack.func_82833_r());
                }
                ItemMobSpawner.applyItemEntityDataToEntity(worldIn, playerIn, itemstack, entity);
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                playerIn.func_71029_a(Objects.requireNonNull(StatList.func_188057_b((Item)this)));
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)itemstack);
    }

    private Entity spawnEntity(World worldIn, double x, double y, double z, EntityPlayer playerIn) {
        Object entity = new EntityZombie(worldIn);
        if (this.name.equals("sata") && CalamityConfigMobs.sataEnabled) {
            entity = new EntitySata(worldIn);
        } else if (this.name.equals("ata") && SRPConfigMobs.ataEnabled) {
            entity = new EntityAta(worldIn);
        } else if (this.name.equals("ulta") && CalamityConfigMobs.ultaEnabled) {
            entity = new EntityUlta(worldIn);
        } else if (this.name.equals("loli") && CalamityConfigMobs.loliEnabled) {
            entity = new EntityLoli(worldIn);
        } else if (this.name.equals("kol") && SRPConfigMobs.kolEnabled) {
            entity = new EntityKol(worldIn);
        } else if (this.name.equals("shol") && CalamityConfigMobs.sholEnabled) {
            entity = new EntityShol(worldIn);
        } else if (this.name.equals("xorlodo") && SRPConfigMobs.lodoEnabled) {
            entity = new EntityXor(worldIn);
            ((EntityParasiteBase)entity).setSkin(0);
        } else if (this.name.equals("xorsata") && CalamityConfigMobs.sataEnabled) {
            entity = new EntityXor(worldIn);
            ((EntityParasiteBase)entity).setSkin(1);
        } else if (this.name.equals("xorloli") && CalamityConfigMobs.loliEnabled) {
            entity = new EntityXor(worldIn);
            ((EntityParasiteBase)entity).setSkin(2);
        } else if (this.name.equals("pithol") && CalamityConfigMobs.pitholEnabled) {
            entity = new EntityPithol(worldIn);
        } else if (this.name.equals("dorpahead") && SRPConfigMobs.dorpaEnabled) {
            entity = new EntityDorpaHead(worldIn);
        } else if (this.name.equals("infdonkey") && CalamityConfigMobs.infdonkeyEnabled) {
            entity = new EntityInfDonkey(worldIn);
        } else if (this.name.equals("infdonkeyhead") && CalamityConfigMobs.infdonkeyEnabled) {
            entity = new EntityInfDonkeyHead(worldIn);
        } else if (this.name.equals("ferdonkey") && CalamityConfigMobs.ferdonkeyEnabled) {
            entity = new EntityFerDonkey(worldIn);
        } else if (this.name.equals("infmule") && CalamityConfigMobs.inffoxEnabled) {
            entity = new EntityInfMule(worldIn);
        } else if (this.name.equals("infmulehead") && CalamityConfigMobs.infmuleEnabled) {
            entity = new EntityInfMuleHead(worldIn);
        } else if (this.name.equals("infbearhead") && SRPConfigMobs.infbearEnabled) {
            entity = new EntityInfBearHead(worldIn);
        } else if (this.name.equals("inffox") && CalamityConfigMobs.inffoxEnabled) {
            entity = new EntityInfFox(worldIn);
        } else if (this.name.equals("inffoxhead") && CalamityConfigMobs.inffoxEnabled) {
            entity = new EntityInfFoxHead(worldIn);
        } else if (this.name.equals("infllama") && CalamityConfigMobs.infllamaEnabled) {
            entity = new EntityInfLlama(worldIn);
        } else if (this.name.equals("infllamahead") && CalamityConfigMobs.infllamaEnabled) {
            entity = new EntityInfLlamaHead(worldIn);
        } else if (this.name.equals("infsquidhead") && SRPConfigMobs.infsquidEnabled) {
            entity = new EntityInfSquidHead(worldIn);
        } else if (this.name.equals("infsquidg") && CalamityConfigMobs.infsquidgEnabled) {
            entity = new EntityInfSquidG(worldIn);
        } else if (this.name.equals("infsquidghead") && CalamityConfigMobs.infsquidgEnabled) {
            entity = new EntityInfSquidGHead(worldIn);
        } else if (this.name.equals("infpillager") && CalamityConfigMobs.infpillagerEnabled) {
            entity = new EntityInfPillager(worldIn);
        } else if (this.name.equals("infpillagerhead") && CalamityConfigMobs.infpillagerEnabled) {
            entity = new EntityInfPillagerHead(worldIn);
        } else if (this.name.equals("infboar") && Loader.isModLoaded((String)"twilightforest") && CalamityTFConfigMobs.infboarEnabled) {
            entity = new EntityInfBoar(worldIn);
        } else if (this.name.equals("infboarhead") && Loader.isModLoaded((String)"twilightforest") && CalamityTFConfigMobs.infboarEnabled) {
            entity = new EntityInfBoarHead(worldIn);
        } else if (this.name.equals("forla") && CalamityConfigMobs.forlaEnabled) {
            entity = new EntityForla(worldIn);
        } else if (this.name.equals("ferwolf") && SRPConfigMobs.ferwolfEnabled) {
            entity = new EntityFerWolf(worldIn);
        } else if (this.name.equals("fermule") && CalamityConfigMobs.fermuleEnabled) {
            entity = new EntityFerMule(worldIn);
        } else if (this.name.equals("ferfox") && CalamityConfigMobs.ferfoxEnabled) {
            entity = new EntityFerFox(worldIn);
        } else if (this.name.equals("ferllama") && CalamityConfigMobs.ferllamaEnabled) {
            entity = new EntityFerLlama(worldIn);
        } else if (this.name.equals("fersquid") && CalamityConfigMobs.fersquidEnabled) {
            entity = new EntityFerSquid(worldIn);
        } else if (this.name.equals("fersquidg") && CalamityConfigMobs.fersquidgEnabled) {
            entity = new EntityFerSquidG(worldIn);
        } else if (this.name.equals("ferpillager") && CalamityConfigMobs.ferpillagerEnabled) {
            entity = new EntityFerPillager(worldIn);
        } else if (this.name.equals("hisnow") && CalamityConfigMobs.hisnowEnabled) {
            entity = new EntityHiSnow(worldIn);
        } else if (this.name.equals("hishulker") && CalamityConfigMobs.hishulkerEnabled) {
            entity = new EntityHiShulker(worldIn);
        } else if (this.name.equals("hiskeleton") && SRPConfigMobs.hiskeletonEnabled) {
            entity = new EntityHiSkeleton(worldIn);
        } else if (this.name.equals("hiwitherbone") && SRPConfigMobs.hiskeletonEnabled) {
            entity = new EntityHiWitherBone(worldIn);
        } else if (this.name.equals("hiblaze") && SRPConfigMobs.hiblazeEnabled) {
            entity = new EntityHiBlaze(worldIn);
        } else if (this.name.equals("cules")) {
            entity = new EntityCuleS(worldIn);
        } else if (this.name.equals("muje") && CalamityConfigMobs.mujeEnabled) {
            entity = new EntityMuje(worldIn);
        } else {
            if (this.name.equals("volk") && CalamityConfigMobs.folkEnabled) {
                return this.spawnVolk(worldIn, x, y, z, playerIn);
            }
            if (this.name.equals("vaz") && CalamityConfigMobs.vazEnabled) {
                entity = new EntityVaz(worldIn);
            } else if (this.name.equals("kucum") && CalamityConfigMobs.kucumEnabled) {
                entity = new EntityKucum(worldIn);
            } else if (this.name.equals("aira") && CalamityConfigMobs.airaEnabled) {
                entity = new EntityAira(worldIn);
            } else if (this.name.equals("xezogu") && CalamityConfigMobs.kucumEnabled) {
                entity = new EntityXezogu(worldIn);
            } else if (this.name.equals("xezoguadapted") && CalamityConfigMobs.kucumEnabled) {
                entity = new EntityXezoguAdapted(worldIn);
            } else if (this.name.equals("flam") && SRPConfigMobs.flamEnabled) {
                entity = new EntityFlam(worldIn);
            } else if (this.name.equals("soo")) {
                entity = new EntitySoo(worldIn);
            } else if (this.name.equals("tenn")) {
                entity = new EntityTenn(worldIn);
            } else if (this.name.equals("dodt")) {
                entity = new EntityDodT(worldIn);
            } else if (this.name.equals("rof")) {
                entity = new EntityRof(worldIn);
            } else if (this.name.equals("mikan")) {
                entity = new EntityMikan(worldIn);
            } else if (this.name.equals("bomb")) {
                EntityBomb bomb = new EntityBomb(worldIn);
                bomb.setSkin(1);
                entity = bomb;
            } else if (this.name.equals("biomass")) {
                EntityBiomass biomass = new EntityBiomass(worldIn);
                biomass.setSkin(1);
                entity = biomass;
            } else if (this.name.equals("biomassii")) {
                EntityBiomass biomass = new EntityBiomass(worldIn);
                biomass.setSkin(2);
                entity = biomass;
            } else if (this.name.equals("biomassiii")) {
                EntityBiomass biomass = new EntityBiomass(worldIn);
                biomass.setSkin(3);
                entity = biomass;
            } else if (this.name.equals("biomasscanra")) {
                EntityBiomass biomass = new EntityBiomass(worldIn);
                biomass.setSkin(4);
                entity = biomass;
            } else if (this.name.equals("biomasscanraadpated")) {
                EntityBiomass biomass = new EntityBiomass(worldIn);
                biomass.setSkin(5);
                entity = biomass;
            } else if (this.name.equals("biomassalafha")) {
                entity = new EntityAlafha(worldIn);
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
                ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
                ((EntityLiving)entity).func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
                ParasiteEventEntity.spawnBiomassFromProjectile((EntityParasiteBase)((EntityAlafha)entity), (String[])SRPConfigMobs.alafhaMobList, null);
                EntityBiomass biomass = new EntityBiomass(worldIn);
                biomass.setSkin(6);
                entity = biomass;
            } else if (this.name.equals("bombo")) {
                entity = new EntityOmboo(worldIn);
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
                ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
                EntityBomb bomb = new EntityBomb(worldIn, (EntityParasiteBase)((EntityOmboo)entity), SRPConfigMobs.ombooGriefing);
                bomb.setFuse(80);
                bomb.setStren(1.0f);
                bomb.setSkin(0);
                bomb.setDamage((float)SRPAttributes.OMBOO_BOMBDAMAGE, 4);
                bomb.updateSTR();
                entity = bomb;
            } else if (this.name.equals("bombj")) {
                entity = new EntityJinjo(worldIn);
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
                ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
                EntityBomb bomb = new EntityBomb(worldIn, (EntityParasiteBase)((EntityJinjo)entity), SRPConfigMobs.jinjoEnabled);
                bomb.setFuse(80);
                bomb.setStren(8.0f);
                bomb.setSkin(2);
                bomb.setDamage(SRPConfigMobs.jinjoDamage * SRPConfigMobs.jinjoExplotionMult, 7);
                bomb.updateSTR();
                entity = bomb;
            } else if (this.name.equals("bombm")) {
                entity = new EntityMikan(worldIn);
                entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
                ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
                EntityBombMikan bomb = new EntityBombMikan(worldIn, (EntityParasiteBase)((EntityMikan)((Object)entity)), CalamityConfigMobs.mikanGriefing);
                bomb.setFuse(80);
                bomb.setStren(16.0f);
                bomb.setDamage(CalamityConfigMobs.mikanDamage * CalamityConfigMobs.mikanExplotionMult, 15);
                bomb.updateSTR();
                entity = bomb;
            } else if (this.name.equals("shycoten") && SRPConfigMobs.shycoEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(1);
                entity = tendril;
            } else if (this.name.equals("noglaten") && SRPConfigMobs.noglaEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(2);
                entity = tendril;
            } else if (this.name.equals("canraten") && SRPConfigMobs.canraEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(3);
                entity = tendril;
            } else if (this.name.equals("zetmoten") && SRPConfigMobs.zetmoEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(4);
                entity = tendril;
            } else if (this.name.equals("angedten") && SRPConfigMobs.angedEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(6);
                entity = tendril;
            } else if (this.name.equals("esorten") && SRPConfigMobs.esorEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(5);
                entity = tendril;
            } else if (this.name.equals("gelnolten") && CalamityConfigMobs.gelnoEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(7);
                entity = tendril;
            } else if (this.name.equals("gelnorten") && CalamityConfigMobs.gelnoEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(8);
                entity = tendril;
            } else if (this.name.equals("belmolten") && CalamityConfigMobs.belmoEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(7);
                entity = tendril;
            } else if (this.name.equals("belmorten") && CalamityConfigMobs.belmoEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(8);
                entity = tendril;
            } else if (this.name.equals("infdragonelw") && SRPConfigMobs.infdragoneEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(7);
                entity = tendril;
            } else if (this.name.equals("infdragonerw") && SRPConfigMobs.infdragoneEnabled) {
                EntityTendril tendril = new EntityTendril(worldIn);
                tendril.setSkin(8);
                entity = tendril;
            } else if (this.name.equals("oroncoten") && SRPConfigMobs.oroncoEnabled) {
                entity = new EntityOroncoTen(worldIn);
                ((EntityOroncoTen)entity).setSkin(worldIn.field_73012_v.nextInt(2));
            } else if (this.name.equals("mikanten") && CalamityConfigMobs.mikanEnabled) {
                entity = new EntityOroncoTen(worldIn);
                ((EntityOroncoTen)entity).setSkin(worldIn.field_73012_v.nextInt(2));
            }
        }
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        if (entity instanceof EntityLiving) {
            ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
            ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
            ((EntityLiving)entity).func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
        }
        worldIn.func_72838_d((Entity)entity);
        return entity;
    }

    private Entity spawnVolk(World worldIn, double x, double y, double z, EntityPlayer playerIn) {
        EntityVolk entity = new EntityVolk(worldIn);
        entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70761_aq = entity.field_70177_z;
        entity.func_180482_a(worldIn.func_175649_E(new BlockPos((Entity)entity)), null);
        entity.func_96094_a(playerIn.func_70005_c_());
        entity.func_174805_g(true);
        worldIn.func_72838_d((Entity)entity);
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    @ParametersAreNonnullByDefault
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        if (this.name.equals("vaz") || this.name.equals("vazadapted") || this.name.equals("vazten") || this.name.equals("vazumb") || this.name.equals("vasco") || this.name.equals("vascoten") || this.name.equals("vascoumb") || this.name.equals("vazkii") || this.name.equals("moonv")) {
            tooltip.add(TextFormatting.BLUE + "Thanks " + TextFormatting.YELLOW + "For " + TextFormatting.RED + "Vazkii");
        } else if (this.name.equals("hiwitherbone") || this.name.equals("hibogged") || this.name.equals("hidruid")) {
            tooltip.add(TextFormatting.UNDERLINE + I18n.func_135052_a((String)"tooltip.srpcalamity.skeletonwarning", (Object[])new Object[0]));
        }
    }
}

