/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.item;

import com.dhanantry.scapeandrunparasites.SRPMain;
import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.block.building.BlockSCSlab;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamitySound;
import com.maidarch.srpcalamity.muon.CalamityTabs;
import com.maidarch.srpcalamity.util.config.CalamityConfig;
import com.maidarch.srpcalamity.util.ideal.IHasModel;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ItemSCSlab
extends ItemSlab
implements IHasModel {
    private final IBlockState slabState;

    public ItemSCSlab(String name, BlockSCSlab block, BlockSCSlab blockDouble) {
        super((Block)block, (BlockSlab)block, (BlockSlab)blockDouble);
        this.slabState = this.field_150939_a.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM);
        this.setRegistryName(name + "_slab");
        this.func_77655_b("srpcalamity." + name + "_slab");
        this.func_77637_a((CreativeTabs)(CalamityConfig.creativeTabType == 2 ? SRPMain.SRP_CREATIVETAB : CalamityTabs.CalamityTab));
        block.setItem((Item)this);
        blockDouble.setItem((Item)this);
        CCCItems.ITEM_LIST.add((Item)this);
    }

    @ParametersAreNonnullByDefault
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos clickPos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        boolean canPlace;
        EnumActionResult tryPlace = super.func_180614_a(player, world, clickPos, hand, facing, hitX, hitY, hitZ);
        if (tryPlace == EnumActionResult.SUCCESS) {
            if (world.func_180495_p(clickPos).func_177230_c().func_176200_f((IBlockAccess)world, clickPos) && world.func_175656_a(clickPos, this.slabState)) {
                player.func_184586_b(hand).func_190918_g(1);
                CalamitySound.playSound(world, clickPos, "block.wood.place");
                return EnumActionResult.SUCCESS;
            }
            return tryPlace;
        }
        BlockPos placePos = this.getPlacementPosition(world, clickPos, facing);
        double belowBlockTop = placePos.func_177956_o();
        if (player.field_70163_u >= belowBlockTop + 0.5) {
            float pitch = player.field_70125_A;
            if (pitch < 0.0f) {
                return EnumActionResult.FAIL;
            }
        } else {
            return EnumActionResult.FAIL;
        }
        double playerFeetY = player.field_70163_u;
        BlockPos belowPos = placePos.func_177977_b();
        belowBlockTop = (double)belowPos.func_177956_o() + 1.0;
        boolean bl = canPlace = playerFeetY >= belowBlockTop + 0.5 && (world.func_175623_d(placePos) || world.func_180495_p(placePos).func_177230_c().func_176200_f((IBlockAccess)world, placePos));
        if (canPlace && world.func_175656_a(placePos, this.slabState)) {
            player.func_184586_b(hand).func_190918_g(1);
            CalamitySound.playSound(world, placePos, "block.wood.place");
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private BlockPos getPlacementPosition(World world, BlockPos clickPos, EnumFacing facing) {
        IBlockState clickedState = world.func_180495_p(clickPos);
        return clickedState.func_177230_c().func_176200_f((IBlockAccess)world, clickPos) ? clickPos : clickPos.func_177972_a(facing);
    }

    public int getItemBurnTime(ItemStack itemStack) {
        return 150;
    }

    @Override
    public void registerModels() {
        SRPCalamity.proxy.registerItemRenderer((Item)this, 0, "inventory");
    }
}

