/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.packet.packs;

import com.maidarch.srpcalamity.entity.boat.EntityModChestBoat;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ChestBoatUpdatePacket
implements IMessage {
    private int entityID;
    private ItemStack stack = ItemStack.field_190927_a;

    public ChestBoatUpdatePacket() {
    }

    public ChestBoatUpdatePacket(int entityID, ItemStack stack) {
        this.entityID = entityID;
        this.stack = stack;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
    }

    public static class ServerHandler
    implements IMessageHandler<ChestBoatUpdatePacket, IMessage> {
        public IMessage onMessage(ChestBoatUpdatePacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            ((WorldServer)world).func_152344_a(() -> {
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof EntityModChestBoat) {
                    ((EntityModChestBoat)entity).chestInventory.validateAndUpdateContents(message.stack);
                }
            });
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<ChestBoatUpdatePacket, IMessage> {
        public IMessage onMessage(ChestBoatUpdatePacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof EntityModChestBoat) {
                    ((EntityModChestBoat)entity).chestInventory.updateChestVisuals(message.stack);
                }
            });
            return null;
        }
    }
}

