/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.packet.packs;

import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.entity.boat.EntityModChestBoat;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpenChestBoatPacket
implements IMessage {
    private int entityID;
    private boolean hasPlayerOpenChest;

    public OpenChestBoatPacket() {
    }

    public OpenChestBoatPacket(int entityID) {
        this.entityID = entityID;
    }

    public OpenChestBoatPacket(int entityID, boolean hasPlayerOpenChest) {
        this.entityID = entityID;
        this.hasPlayerOpenChest = hasPlayerOpenChest;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeBoolean(this.hasPlayerOpenChest);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.hasPlayerOpenChest = buf.readBoolean();
    }

    public static class ServerHandler
    implements IMessageHandler<OpenChestBoatPacket, IMessage> {
        public IMessage onMessage(OpenChestBoatPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            World world = player.field_70170_p;
            ((WorldServer)world).func_152344_a(() -> {
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof EntityModChestBoat) {
                    player.openGui((Object)SRPCalamity.instance, 3, world, entity.func_145782_y(), 0, 0);
                }
            });
            return null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientHandler
    implements IMessageHandler<OpenChestBoatPacket, IMessage> {
        public IMessage onMessage(OpenChestBoatPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                WorldClient world = Minecraft.func_71410_x().field_71441_e;
                if (world == null) {
                    return;
                }
                Entity entity = world.func_73045_a(message.entityID);
                if (entity instanceof EntityModChestBoat) {
                    ((EntityModChestBoat)entity).chestInventory.hasPlayerOpenChest = message.hasPlayerOpenChest;
                }
            });
            return null;
        }
    }
}

