/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.particle;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CherryParticle
extends Particle {
    public static final Minecraft MC = Minecraft.func_71410_x();
    private static final int maxAge = 300;
    private static final float GRAVITY = 7.5E-4f;
    private boolean isStopped;
    private final float phase;
    public static final List<ResourceLocation> TEXTURES = new ArrayList<ResourceLocation>();
    private static final Random random = new Random();

    private CherryParticle(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_187115_a(0.1f, 0.1f);
        this.field_190017_n = false;
        this.field_70547_e = 300;
        this.field_82339_as = 1.0f;
        this.phase = this.field_187136_p.nextFloat();
        this.field_70544_f = 0.55f + this.field_187136_p.nextFloat() * 0.05f;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_70545_g = 7.5E-4f;
        TextureAtlasSprite sprite = MC.func_147117_R().func_110572_b(TEXTURES.get(random.nextInt(TEXTURES.size())).toString());
        this.func_187117_a(sprite);
    }

    public void func_189213_a() {
        AxisAlignedBB box;
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        IBlockState posBlockState = this.field_187122_b.func_180495_p(new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h));
        Block posBlock = posBlockState.func_177230_c();
        if (posBlockState.func_185914_p()) {
            this.func_187112_i();
            return;
        }
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
            return;
        }
        BlockPos supportPos = new BlockPos(MathHelper.func_76128_c((double)this.field_187126_f), MathHelper.func_76128_c((double)(this.field_187127_g - 0.1)), MathHelper.func_76128_c((double)this.field_187128_h));
        IBlockState supportState = this.field_187122_b.func_180495_p(supportPos);
        Block supportBlock = supportState.func_177230_c();
        if (this.isStopped) {
            BlockPos pos = new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            if (!this.field_187122_b.func_180495_p(pos.func_177977_b()).func_185917_h()) {
                this.isStopped = false;
                this.field_187129_i = 0.0;
                this.field_187131_k = 0.0;
                this.field_187130_j = -0.05;
            } else {
                return;
            }
        }
        if (!(posBlock instanceof BlockLeaves) && (supportBlock instanceof BlockGlass || supportState.func_185917_h()) && (box = supportState.func_185900_c((IBlockAccess)this.field_187122_b, supportPos)) != null && box.field_72337_e > 0.0) {
            this.field_187131_k = 0.0;
            this.field_187130_j = 0.0;
            this.field_187129_i = 0.0;
            this.func_187109_b(this.field_187126_f, this.field_187127_g, this.field_187128_h);
            this.isStopped = true;
            return;
        }
        float lifeProgress = (float)this.field_70546_d / 300.0f;
        lifeProgress = Math.min(lifeProgress, 1.0f);
        double offsetX = Math.cos(Math.toRadians(this.phase * 60.0f)) * 2.0 * Math.pow(lifeProgress, 1.25);
        double offsetZ = Math.sin(Math.toRadians(this.phase * 60.0f)) * 2.0 * Math.pow(lifeProgress, 1.25);
        this.field_187129_i += offsetX * 0.0025;
        this.field_187131_k += offsetZ * 0.0025;
        this.field_187130_j -= (double)this.field_70545_g;
        this.func_187110_a(this.field_187129_i, this.field_187130_j, this.field_187131_k);
    }

    public int func_70537_b() {
        return 1;
    }

    public static void spawnParticle(World world, BlockPos pos) {
        double x = (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5);
        double y = (double)pos.func_177956_o() - 0.01;
        double z = (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5);
        CherryParticle.MC.field_71452_i.func_78873_a((Particle)new CherryParticle(world, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public static class CherryParticleFactory
    implements IParticleFactory {
        public Particle func_178902_a(int particleID, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
            return new CherryParticle(world, x, y, z);
        }
    }
}

