/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.util;

import com.maidarch.srpcalamity.feature.FurnaceForge;
import com.maidarch.srpcalamity.init.CCCBlocks;
import com.maidarch.srpcalamity.init.CCCItems;
import com.maidarch.srpcalamity.muon.CalamitySound;
import com.maidarch.srpcalamity.muon.CalamityTouHouMusic;
import com.maidarch.srpcalamity.util.RenderHandler;
import com.maidarch.srpcalamity.util.ideal.IHasModel;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])CCCItems.ITEM_LIST.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onBlockRegister(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])CCCBlocks.BLOCK_LIST.toArray(new Block[0]));
    }

    @SubscribeEvent
    public static void onSoundRegister(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])CalamityTouHouMusic.MUSIC_LIST.toArray(new SoundEvent[0]));
        event.getRegistry().registerAll((IForgeRegistryEntry[])CalamitySound.SOUND_LIST.toArray(new SoundEvent[0]));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        FurnaceForge.setFurnaceForge();
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent event) {
        for (Item item : CCCItems.ITEM_LIST) {
            if (!(item instanceof IHasModel)) continue;
            ((IHasModel)item).registerModels();
        }
        for (Block block : CCCBlocks.BLOCK_LIST) {
            if (!(block instanceof IHasModel)) continue;
            ((IHasModel)block).registerModels();
        }
    }

    public static void preInitRegistries() {
        RenderHandler.registerEntityRenders();
    }
}

