/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.util.config;

import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.proxy.CommonProxy;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class CalamityConfig {
    public static boolean complementItemMobSpawnerEnable = true;
    public static boolean easterEggs = true;
    public static double volkNameTagChance = 1.0;
    public static double foxSnowNameTagChance = 0.005;
    public static String[] ZetaParasiteGriefingBlackList = new String[]{"srpcalamity"};
    public static String[] mobattackingFriendlyBlackList = new String[]{"minecraft:creeper"};
    public static boolean mobattackingFriendlyBlackListWhite = false;
    public static boolean mobFriendlyAttackingFull = false;
    public static float piousSeniorPointRed = 0.2f;
    public static int piousSeniorPointCap = 5;
    public static int piousSeniorPointDamCap = 20;
    public static double piousSeniorChanceLe = 1.0;
    public static double piousSeniorChanceLeFire = 0.3;
    public static double piousFollow = 32.0;
    public static double piousSeniorFollow = 80.0;
    public static int piousCap = 5;
    public static int piousSeniorCap = 15;
    public static boolean piousdespawn = true;
    public static boolean piousSeniordespawn = true;
    public static float piousMinDamage = 1.0f;
    public static float piousSeniorMinDamage = 4.0f;
    public static float piousSeniorRegen = 0.3f;
    public static int piousOneMindDeathV = 15;
    public static int piousSeniorOneMindDeathV;
    public static int piousXPValue;
    public static int piousSeniorXPValue;
    public static int piousRemainValue;
    public static int piousSeniorRemainValue;
    public static int piousLoosingEPValue;
    public static int piousSeniorLoosingEPValue;
    public static float piousFoodSteal;
    public static float piousSeniorFoodSteal;
    public static int piousSeniorExpSteal;
    public static int piousSeniorItemOrbCooldown;
    public static int piousSeniorFlamTotal;
    public static double piousSeniorFoodChance;
    public static int piousSeniorFoodAmount;
    public static double piousSneakPen;
    public static double piousSeniorSneakPen;
    public static float piousInviPen;
    public static float piousSeniorInviPen;
    public static boolean piousSeniorWalls;
    public static int creativeTabType;

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("configuration_general", "General configuration \nVersion:0.3.0\n\n ");
        easterEggs = cfg.getBoolean("Mod Easter Eggs", "configuration_general", easterEggs, "Set to false if you want to disable Easter Eggs.");
        volkNameTagChance = cfg.getFloat("Mod Easter Egg (Nametags)", "configuration_general", (float)volkNameTagChance, 0.0f, 1.0f, "Chance to spawn a Folk with such nametags.");
        foxSnowNameTagChance = cfg.getFloat("Mod Easter Egg (Foxes Nametags)", "configuration_general", (float)foxSnowNameTagChance, 0.0f, 1.0f, "Chance to spawn a Assimilated Snow Fox with a Foxy nametags.");
    }

    private static void initPropertiesConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("parasite_properties", "Parasite Properties");
        ZetaParasiteGriefingBlackList = cfg.getStringList("Mobs with Griefing Task Blacklist", "parasite_properties", ZetaParasiteGriefingBlackList, "List of block that can't be broken by the griefing task, Ex: \"minecraft:stonebrick\" or just \"minecraft\" for a whole mod");
    }

    private static void initCreativeTab(Configuration cfg) {
        creativeTabType = cfg.getInt("Type of CreativeTabType", "creativeTab", creativeTabType, 0, 2, "Decide the type of Creative Tab,[0]vanilla[1]Calamity[2]SRP");
    }

    private static void initPropertiesConfigPious(Configuration cfg) {
        piousCap = cfg.getInt("Version Pious Damage Cap\n\n", "parasite_properties_pious", piousCap, 1, 100, "Minimum number of hits required to kill Pious versions.");
        piousdespawn = cfg.getBoolean("Version Pious Despawn\n\n", "parasite_properties_pious", piousdespawn, "Set to true for Pious versions to despawn.");
        piousFollow = cfg.getFloat("Version Pious Follow Range\n\n", "parasite_properties_pious", (float)piousFollow, 0.0f, 128.0f, "Follow range.");
        piousMinDamage = cfg.getFloat("Version Pious Minimum Damage\n\n", "parasite_properties_pious", piousMinDamage, 0.0f, 1024.0f, "Minimum Damage for Pious versions.");
        piousOneMindDeathV = cfg.getInt("Version Pious Scent Death Value\n\n", "parasite_properties_pious", piousOneMindDeathV, 1, 1000, "Death value set in EntityParasiticScent, used if parasite_collective_consciousness is enabled.");
        piousXPValue = cfg.getInt("Version Pious XP Value\n\n", "parasite_properties_pious", piousXPValue, 1, 50000, "XP value.");
        piousRemainValue = cfg.getInt("Version Pious Remain Value\n\n", "parasite_properties_pious", piousRemainValue, 1, 50000, "Life points required to be rebuilt.");
        piousLoosingEPValue = cfg.getInt("Version Pious Death Penalty Evolution Value\n\n", "parasite_properties_pious", piousLoosingEPValue, 0, 1000000000, "How many points parasites will lose when it is killed.");
        piousSneakPen = cfg.getFloat("Version Pious Sneak Penalty\n\n", "parasite_properties_pious", (float)piousSneakPen, 0.0f, 1.0f, "Penalty for parasites when someone is sneaking, the lower the value the higher the chance of not being seen, vanilla value is 0.800000011920929.");
        piousInviPen = cfg.getFloat("Version Pious Invisible Penalty\n\n", "parasite_properties_pious", piousInviPen, 0.0f, 1.0f, "Penalty for parasites when someone is invisible, the lower the value the higher the chance of not being seen, vanilla value is 0.7.");
    }

    public static void initConfig(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        CommonProxy.config = new Configuration(new File(directory.getPath(), "SRPCalamity/SRPCalamity.cfg"));
        CalamityConfig.readConfig();
    }

    public static boolean readConfig() {
        Configuration cfgM = CommonProxy.config;
        try {
            cfgM.load();
            CalamityConfig.initGeneralConfig(cfgM);
            CalamityConfig.initPropertiesConfig(cfgM);
            CalamityConfig.initCreativeTab(cfgM);
            CalamityConfig.initPropertiesConfigPious(cfgM);
            boolean bl = true;
            return bl;
        }
        catch (Exception exc) {
            SRPCalamity.logger.log(Level.ERROR, "Problem loading configuration file", (Throwable)exc);
        }
        finally {
            if (cfgM.hasChanged()) {
                cfgM.save();
            }
        }
        return false;
    }

    static {
        piousXPValue = 32;
        piousSeniorXPValue = 200;
        piousRemainValue = 12;
        piousSeniorRemainValue = 25;
        piousLoosingEPValue = 15;
        piousSeniorLoosingEPValue = 30000;
        piousFoodSteal = 1.0f;
        piousSeniorFoodSteal = 5.0f;
        piousSeniorExpSteal = 340;
        piousSeniorItemOrbCooldown = 30;
        piousSeniorFlamTotal = 3;
        piousSeniorFoodChance = 0.4;
        piousSeniorFoodAmount = 12;
        piousSneakPen = 1.0;
        piousSeniorSneakPen = 1.0;
        piousInviPen = 1.0f;
        piousSeniorInviPen = 1.0f;
        piousSeniorWalls = false;
        creativeTabType = 1;
    }
}

