/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.util.config;

import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.muon.LinguaFranca;
import com.maidarch.srpcalamity.muon.LinguaWord;
import com.maidarch.srpcalamity.proxy.CommonProxy;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class CalamityConfigRules {
    public static boolean visceraFalling = true;
    public static boolean lanternFalling = true;
    public static boolean hiBlockAtaEnabled = true;
    public static boolean hiPlateCrackedEnabled = true;
    public static int hiPlateChance = 12;
    public static boolean simenderPearlEnabled = true;
    public static boolean callingFruitEnabled = true;
    public static boolean simenderPearlThunderEnabled = true;
    public static int simenderRadius = 128;
    public static boolean catchMobsEnabled = true;
    public static boolean catchLodoEnabled = true;
    public static boolean catchMudoEnabled = true;
    public static float catchMudoChance = 1.0f;
    public static boolean catchNuuhEnabled = true;
    public static float catchNuuhChance = 0.9f;
    public static boolean catchSataEnabled = true;
    public static boolean catchAtaEnabled = true;
    public static float catchAtaChance = 1.0f;
    public static boolean catchUltaEnabled = true;
    public static float catchUltaChance = 0.9f;
    public static boolean catchLoliEnabled = true;
    public static boolean catchKolEnabled = true;
    public static float catchKolChance = 1.0f;
    public static boolean catchSholEnabled = true;
    public static float catchSholChance = 0.9f;
    public static boolean catchPitholEnabled = true;
    public static float catchPitholChance = 1.0f;
    public static boolean catchGotholEnabled = true;
    public static float catchGotholChance = 1.0f;
    public static boolean catchButholEnabled = true;
    public static float catchButholChance = 1.0f;
    public static boolean catchKetholEnabled = true;
    public static float catchKetholChance = 1.0f;
    public static boolean catchWolfEnabled = true;
    public static float catchWolfChance = 1.0f;
    public static boolean catchFoxEnabled = true;
    public static float catchFoxChance = 1.0f;
    public static boolean catchHeadEnabled = true;
    public static float catchHeadChance = 1.0f;
    public static boolean catchLeshEnabled = true;
    public static float catchLeshChance = 1.0f;
    public static boolean catchMujeEnabled = true;
    public static float catchMujeChance = 1.0f;
    public static boolean catchInhoosEnabled = true;
    public static float catchInhoosChance = 1.0f;
    public static boolean catchInhoomEnabled = true;
    public static float catchInhoomChance = 1.0f;
    public static boolean catchFlogEnabled = true;
    public static float catchFlogChance = 0.75f;
    public static boolean colorfulSheepEnabled = true;

    private static void initGeneralRulesConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("configuration_systems", "Systems configuration \nVersion:0.3.0\n ");
    }

    private static void initPhysicsConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("physics", "Physics");
        visceraFalling = cfg.getBoolean("Rupter Viscera Block Falling", "physics", visceraFalling, "Set to false if you do not want to Rupter Viscera Block falling.\n\u88c2\u517d\u5185\u810f\u5757\u4e0b\u843d\u3002\n");
        lanternFalling = cfg.getBoolean("Lantern Falling", "physics", lanternFalling, "Set to false if you do not want to Lantern falling.\n\u706f\u7b3c\u4e0b\u843d\u3002\n");
    }

    private static void initBlockSpawnsConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("blockspawn", "Block Spawns");
        hiBlockAtaEnabled = cfg.getBoolean("Break Hijacked Block to Spawn Gnats", "blockspawn", hiBlockAtaEnabled, "Break Hijacked Blocks without Silk Harvest to spawn Gnats\n\u5728\u4e0d\u4f7f\u7528\u91c7\u96c6\u7cbe\u51c6\u7684\u60c5\u51b5\u4e0b\uff0c\u88ab\u52ab\u6301\u7684\u65b9\u5757\u5c06\u4ea7\u751f\u72c2\u75ab\u868b\u3002");
        hiPlateCrackedEnabled = cfg.getBoolean("Hijacked Iron Pressure Plate can be cracked to Spawn Gnats", "blockspawn", hiPlateCrackedEnabled, "If you set true last & this,Hijacked Iron Pressure Plate will be cracked and release Plenty of Gnats while being pressed\n\u5728\u5141\u8bb8\u4e0a\u4e00\u6761\u7684\u524d\u63d0\u4e0b\uff0c\u8e29\u8e0f\u88ab\u52ab\u6301\u7684\u94c1\u538b\u529b\u677f\u6709\u51e0\u7387\u7206\u88c2\uff0c\u5e76\u4ea7\u751f\u72c2\u75ab\u868b\u3002\n\u524d\u306e\u3082\u306e\u304c\u8a31\u53ef\u3055\u308c\u3066\u3044\u308b\u5834\u5408\u3001\u30cf\u30a4\u30b8\u30e3\u30c3\u30af\u3055\u308c\u305f\u9244\u306e\u611f\u5727\u677f\u3092\u8e0f\u3080\u3068\u3001\u7834\u88c2\u3057\u3066\u30d6\u30e8\u3092\u751f\u6210\u3059\u308b\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059\u3002");
        hiPlateChance = cfg.getInt("Hijacked Iron Pressure Plate ", "blockspawn", hiPlateChance, 0, 10000, "Chance(1 = 0.01%).\n\u7206\u88c2\u51e0\u7387\uff08\u5355\u4f4d\uff1a\u4e07\u5206\u4e4b\u4e00(\u2031)\uff09\n\u78ba\u7387\uff08\u5358\u4f4d\uff1a10,000\u5206\u306e1(\u2031)\uff09");
    }

    private static void initSimenderConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("simender", "ABOUT Assimilatender");
        simenderPearlEnabled = cfg.getBoolean("Assimilatender Pearl Enabled", "simender", simenderPearlEnabled, "Set to false if you want to disable Assimilatender Pearl.\n\u542f\u7528\u5bc4\u5f71\u73cd\u73e0\u3002\n");
        simenderPearlThunderEnabled = cfg.getBoolean("Assimilatender Pearl Thunder Enabled", "simender", simenderPearlThunderEnabled, "Set to false if you want to disable Assimilatender Pearl with Thunder.\n\u542f\u7528\u5bc4\u5f71\u73cd\u73e0\u843d\u96f7\u306e\u7279\u5fb4\u3002\n");
        callingFruitEnabled = cfg.getBoolean("Calling Fruit Enabled", "simender", callingFruitEnabled, "Set to false if you want to disable Callinig Fruit.\n\u542f\u7528\u8d64\u5524\u679c\u3002");
        simenderRadius = cfg.getInt("Assimilatender Transport Radius", "simender", simenderRadius, 0, 256, "Transport Radius for Assimilatednder.\n\u8bbe\u7f6e\u5bc4\u5f71\u4f20\u9001\u7684\u534a\u5f84\u3002");
    }

    private static void initColorfulSheepConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("colorful_sheep", "Colorful Assimilated Sheep");
        colorfulSheepEnabled = cfg.getBoolean("Colorful Assimilated Sheep Enabled", "colorful_sheep", simenderPearlEnabled, "Assimilated Sheep will spawn with colorful wool,Set to false if you want to disable Colorful Assimilated Sheep.\n\u542f\u7528\u591a\u5f69\u540c\u5316\u7f8a\u3002\n");
    }

    public static boolean setCatchEnabled(Configuration cfg, LinguaWord word, boolean whoEnabled) {
        return cfg.getBoolean("Catch " + word.EN_US + " Enabled", "catch", whoEnabled, "Set to false if you want to disable Catch " + word.EN_US + ". \n" + word.ZH_CN + "\u53ef\u88ab\u6293\u83b7\u3002 \n\u6355\u307e\u3048\u308b\u3053\u3068\u3092\u8a31\u53ef\u3059\u308b" + word.JA_JP + "\u3002");
    }

    public static float setCatchChance(Configuration cfg, LinguaWord word, float whoChance) {
        return cfg.getFloat("Catch " + word.EN_US + " Chance", "catch", whoChance, 1.0E-4f, 1.0f, "The chance of catching " + word.EN_US + ". \n" + word.ZH_CN + "\u6bcf\u6b21\u6293\u83b7\u7684\u6210\u529f\u7387\u3002 \n" + word.JA_JP + "\u3092\u6355\u307e\u3048\u308b\u6210\u529f\u7387\u3002");
    }

    private static void initCatchConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("catch", "Catch Mobs");
        catchMobsEnabled = cfg.getBoolean("Catch Mobs Enabled", "catch", catchMobsEnabled, "Set to false if you want to disable Catch Parasites.\n\u5bc4\u751f\u4f53\u53ef\u88ab\u6293\u83b7\u3002");
        catchLodoEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Lodo, catchLodoEnabled);
        catchMudoEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Mudo, catchMudoEnabled);
        catchMudoChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Mudo, catchMudoChance);
        catchNuuhEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Nuuh, catchNuuhEnabled);
        catchNuuhChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Nuuh, catchNuuhChance);
        catchSataEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Sata, catchSataEnabled);
        catchAtaEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Ata, catchAtaEnabled);
        catchAtaChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Ata, catchAtaChance);
        catchUltaEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Ulta, catchUltaEnabled);
        catchUltaChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Ulta, catchUltaChance);
        catchLoliEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Loli, catchLoliEnabled);
        catchKolEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Kol, catchKolEnabled);
        catchKolChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Kol, catchKolChance);
        catchSholEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Shol, catchSholEnabled);
        catchSholChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Shol, catchSholChance);
        catchPitholEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Pithol, catchPitholEnabled);
        catchPitholChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Pithol, catchPitholChance);
        catchGotholEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Gothol, catchGotholEnabled);
        catchGotholChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Gothol, catchGotholChance);
        catchButholEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Buthol, catchButholEnabled);
        catchButholChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Buthol, catchButholChance);
        catchKetholEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Kethol, catchKetholEnabled);
        catchKetholChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Kethol, catchKetholChance);
        catchWolfEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.InfWolf, catchWolfEnabled);
        catchWolfChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.InfWolf, catchWolfChance);
        catchFoxEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.InfFox, catchFoxEnabled);
        catchFoxChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.InfFox, catchFoxChance);
        catchHeadEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.InfHead, catchHeadEnabled);
        catchHeadChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.InfHead, catchHeadChance);
        catchLeshEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Lesh, catchLeshEnabled);
        catchLeshChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Lesh, catchLeshChance);
        catchMujeEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Muje, catchMujeEnabled);
        catchMujeChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Muje, catchMujeChance);
        catchInhoosEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.InhooS, catchInhoosEnabled);
        catchInhoosChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.InhooS, catchInhoosChance);
        catchInhoomEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.InhooM, catchInhoomEnabled);
        catchInhoomChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.InhooM, catchInhoomChance);
        catchFlogEnabled = CalamityConfigRules.setCatchEnabled(cfg, LinguaFranca.Flog, catchFlogEnabled);
        catchFlogChance = CalamityConfigRules.setCatchChance(cfg, LinguaFranca.Flog, catchFlogChance);
    }

    public static void initConfig(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        CommonProxy.configRules = new Configuration(new File(directory.getPath(), "SRPCalamity/SRPCalamityRules.cfg"));
        CalamityConfigRules.readConfig();
    }

    public static boolean readConfig() {
        Configuration cfgM = CommonProxy.configRules;
        try {
            cfgM.load();
            CalamityConfigRules.initGeneralRulesConfig(cfgM);
            CalamityConfigRules.initPhysicsConfig(cfgM);
            CalamityConfigRules.initBlockSpawnsConfig(cfgM);
            CalamityConfigRules.initSimenderConfig(cfgM);
            CalamityConfigRules.initColorfulSheepConfig(cfgM);
            CalamityConfigRules.initCatchConfig(cfgM);
            boolean bl = true;
            return bl;
        }
        catch (Exception exc) {
            SRPCalamity.logger.log(Level.ERROR, "Problem loading configuration file", (Throwable)exc);
        }
        finally {
            if (cfgM.hasChanged()) {
                cfgM.save();
            }
        }
        return false;
    }
}

