/*
 * Decompiled with CFR 0.152.
 */
package com.maidarch.srpcalamity.util.config;

import com.maidarch.srpcalamity.SRPCalamity;
import com.maidarch.srpcalamity.proxy.CommonProxy;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public class CalamityTFConfigSystems {
    public static boolean mergeRandom = true;
    public static int valueMerge = 10;
    public static double mergeHealth = 0.5;
    public static String[] mergeMobTable = new String[]{"srparasites:pri_chilopoda;0", "srparasites:pri_klimater;0"};
    public static String[] mergeInfValues = new String[]{"srparasites:sim_deer;1", "srparasites:sim_bighorn;1", "srparasites:sim_boar;1", "srparasites:sim_mistwolf;1", "srparasites:sim_winterwolf;1", "srparasites:sim_kobold;1", "srparasites:sim_endermanforest;1"};

    private static void initTFGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment("configuration_tf_systems_general", "[Scape&Run-Parasites : Twilight Forest] General configuration \nVersion:0.3.0\n\n ");
    }

    private static void initevolutionConfig(Configuration cfg) {
        String evolutionDescription = " \n If Evolution Phases is true, the current phase will dictate if a parasite can spawn naturally \n in the world and by reaching some phases, they will unlock some bonuses\n *Spawnrates are not affected by the Phases\n  \n -> Phase 0:\n    -Buglins spawn naturally\n  \n -> Phase 1:\n    -Rupters spawn naturally, with a hit and run behavior\n    -Animals and mobs infected with COTH will not mutate unless forced to low health\n    \n -> Phase 2:\n    -Assimilated versions spawn naturally\n    -Rupters will now attack as normal\n    \n -> Phase 3:\n    -Reinforcement system is unlocked\n    -Beckons will slowly grow to Stage II and beyond\n    -The passive point gaining is now active\n \t -Mobs with COTH will stop dropping loot\n    \n -> Phase 4:\n    -Primitive versions spawn naturally\n    -Normal growth to Beckons Stage II, but will slowly grow to Stage III\n    -Passive point gaining recieves a buff to the number gaining\n    -Reinforcement system chance increased\n    -Colonies now unlocked\n \t -Buglins will stop spawning naturally\n\t -No more fishing\n    \n -> Phase 5:\n    -Passive point gaining recieves a buff to the number gaining\n    -Players sleep penalty points increased\n    -Normal growth to Beckons Stage III but will slowly grow  to Stage IV\n    -Feral versions spawn naturally\n    -Nodes now unlocked\n    -COTH hidden mobs are now dropping their disguise\n    -Beckons will ignore summoning cooldown when spawning\n    -Reinforcement system chance increased\n    \n -> Phase 6:\n    -Normal growth to Beckons Stage IV\n    -Passive point gaining recieves a buff to the number gaining\n    -Assimilated versions and lower tier parasites will stop spawning naturally\n    -Adapted versions spawn naturally\n    -Mobs have a chance to spawn with COTH now\n    -Crop growth is now partially stunted\n    -Reinforcement system chance increased\n    \n -> Phase 7:\n    -Primitive versions and lower tier parasites will stop spawning naturally\n    -Pure versions spawn naturally\n    -Chance for a mob to spawn with COTH increased\n    -Passive point gaining recieves a buff to the number gaining\n    -Crop growth is now partially stunted\n    -Reinforcement system chance increased\n    -Parasites will ignore sunlight when spawning naturally\n    \n -> Phase 8:\n    -Passive point gaining recieves a buff to the number gaining\n    -Chance for a mob to spawn with COTH increased\n    -Crop growth is now partially stunted\n    -Reinforcement system chance increased\n    \n    \n \n To reduce their evolution phase you need to craft Lure Blocks";
        cfg.addCustomCategoryComment("parasite_evolution_phases", "Evolution Phases" + evolutionDescription);
        valueMerge = cfg.getInt("Value for Merging", "parasite_evolution_phases", valueMerge, 0, 1000000, "Number of Points gained when using the merge system to spawn Primitive Parasites.");
    }

    private static void initmergeConfig(Configuration cfg) {
        String MergeDescription = " \n The Assimilated have the ability to learn from their battles and if the conditions are met, they will \n start to melt until they're some Moving Flesh \n If 2 of these things meet, they will fuse together and grow, if they get big enough they will spawn \n a mob from the Mob List.\n \n Conditions for the Assimilated to turn into Moving Flesh: \n \n -The first condition: the Assimilated needs to reach the primitive killcount. \n -The second condition: it needs to be next to 3 more Assimilated, regardless of their killcount/specie \n OR it needs to be next to a Moving Flesh. \n If the Assimilated with the killcount is next to atleast 3 more Assimilated, the four of them will start \n to melt BUT if it is next to a Moving flesh, only it will start to melt.";
        String mergeS = " Ex. \"minecraft:zombie;11\"  Where: \n \"minecraft:zombie\" is for the entity, \n \"11\" is for the value the entity has (value must be an integer). \n Each Assimilated has a value, the value then passes to the Moving Flesh and when 2 Moving Flesh merge together both values will add up\n If the value matches one in the list, the corresponding entity will spawn, else it will be a random one. \n";
        String mergeI = " Ex. \"srparasites:infhuman;22\"  Where: \n \"srparasites:infhuman\" is for the entity (only works for Assimilated versions minus Big Spider, Enderdragon), \n \"22\" is for the value the Moving Flesh will have (value must be an integer). \n";
        cfg.addCustomCategoryComment("merge_System", "Merge System" + MergeDescription);
        mergeRandom = cfg.getBoolean("Merge System Random", "merge_System", mergeRandom, "Set to false if you don't want to spawn random mobs from the Mob List (values will be used).");
        mergeHealth = cfg.getFloat("Merge System Mob Health", "merge_System", (float)mergeHealth, 0.0f, 1.0f, "Amount of health (1 = 100%) the mob spawns with.");
        mergeMobTable = cfg.getStringList("Merge System Mob List", "merge_System", mergeMobTable, "Mob list used in the merge system to spawn mobs." + mergeS);
        mergeInfValues = cfg.getStringList("Merge System Assimilated Values", "merge_System", mergeInfValues, "Assimilated mob list with their values used in the merge system to spawn mobs." + mergeI);
    }

    public static void initConfig(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        CommonProxy.tfconfigSystems = new Configuration(new File(directory.getPath(), "SRPCalamity/twilightforest/TFCalamitySystems.cfg"));
        CalamityTFConfigSystems.readConfig();
    }

    public static boolean readConfig() {
        Configuration cfgM = CommonProxy.tfconfigSystems;
        try {
            cfgM.load();
            CalamityTFConfigSystems.initTFGeneralConfig(cfgM);
            CalamityTFConfigSystems.initevolutionConfig(cfgM);
            CalamityTFConfigSystems.initmergeConfig(cfgM);
            boolean bl = true;
            return bl;
        }
        catch (Exception exc) {
            SRPCalamity.logger.log(Level.ERROR, "Problem loading configuration file", (Throwable)exc);
        }
        finally {
            if (cfgM.hasChanged()) {
                cfgM.save();
            }
        }
        return false;
    }
}

