/*
 * Decompiled with CFR 0.152.
 */
package infinity_gauntlet.network;

import infinity_gauntlet.InfinityGauntletMod;
import infinity_gauntlet.procedures.KillstonefunProcedure;
import infinity_gauntlet.procedures.PowerStoneProcedure;
import infinity_gauntlet.procedures.RealitvstonefunProcedure;
import infinity_gauntlet.procedures.TimestoneProcedure;
import infinity_gauntlet.procedures.TpstoneProcedure;
import infinity_gauntlet.world.inventory.GauntletMenu;
import java.util.HashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GauntletButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GauntletButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GauntletButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GauntletButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GauntletButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GauntletButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GauntletMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            TimestoneProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            RealitvstonefunProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            TpstoneProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            PowerStoneProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            KillstonefunProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        InfinityGauntletMod.addNetworkMessage(GauntletButtonMessage.class, GauntletButtonMessage::buffer, GauntletButtonMessage::new, GauntletButtonMessage::handler);
    }
}

