/*
 * Decompiled with CFR 0.152.
 */
package fbanna.chestprotection.check;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.sgui.api.gui.SimpleGui;
import fbanna.chestprotection.ChestProtection;
import fbanna.chestprotection.trade.TradeInventory;
import fbanna.chestprotection.trade.TradeItem;
import fbanna.chestprotection.trade.TradeItemList;
import fbanna.chestprotection.trade.profit.ProfitInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1843;
import net.minecraft.class_1937;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_9262;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9302;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class CheckChest {
    public status chestStatus;
    public String author;
    public TradeItemList tradeItems;
    public class_1263 chestInventory;
    public ProfitInventory profitInventory;
    public class_1937 world;
    public class_2338 position;
    private class_1799 stack;
    private SimpleGui screen;

    public CheckChest(class_2338 position, class_1937 world) {
        block24: {
            this.chestStatus = status.CLEAR;
            this.screen = null;
            if (world.method_8321(position) instanceof class_2595) {
                this.world = world;
                this.position = position;
                this.chestInventory = class_2281.method_17458((class_2281)((class_2281)world.method_8320(position).method_26204()), (class_2680)world.method_8320(position), (class_1937)world, (class_2338)position, (boolean)true);
                this.stack = this.chestInventory.method_5438(0);
                if (this.stack.method_7909() instanceof class_1843) {
                    class_9302 book = (class_9302)this.stack.method_58694(class_9334.field_49606);
                    if (Objects.equals(book.comp_2419().comp_2369(), "LOCK")) {
                        this.chestStatus = status.LOCK;
                        this.author = book.comp_2420();
                    } else if (Objects.equals(book.comp_2419().comp_2369(), "SELL")) {
                        this.chestStatus = status.ERROR;
                        this.author = book.comp_2420();
                        List pages = book.comp_2422();
                        if (pages.size() == 2) {
                            String[] pageList = new String[]{((class_2561)((class_9262)pages.get(0)).comp_2369()).getString(), ((class_2561)((class_9262)pages.get(1)).comp_2369()).getString()};
                            TradeItem[] out = new TradeItem[2];
                            boolean success = true;
                            for (int i = 0; i < 2; ++i) {
                                TradeItem saveItem;
                                JsonElement element;
                                if (pageList[i].isEmpty()) {
                                    success = false;
                                    break;
                                }
                                try {
                                    element = JsonParser.parseString((String)pageList[i]);
                                }
                                catch (Exception e) {
                                    success = false;
                                    break;
                                }
                                DataResult result = TradeItem.CODEC.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)element);
                                if (result.isSuccess()) {
                                    saveItem = (TradeItem)result.getOrThrow();
                                    if (!saveItem.getIsItem()) {
                                        for (class_9331 type : saveItem.getStack().method_7972().method_57353().method_57831()) {
                                            if (!type.equals((Object)class_9334.field_49622)) continue;
                                            saveItem.setItem(class_1802.field_8545);
                                        }
                                    }
                                } else {
                                    ChestProtection.LOGGER.info("Error in parsing, when someone opened a chest! ChestProtection");
                                    success = false;
                                    break;
                                }
                                out[i] = saveItem;
                            }
                            if (success) {
                                this.tradeItems = new TradeItemList(out);
                                this.chestStatus = status.SELL;
                            }
                        }
                        if (this.stack.method_57826(class_9334.field_49628)) {
                            class_9279 data = (class_9279)this.stack.method_58694(class_9334.field_49628);
                            if (data != null) {
                                class_2487 nbt = data.method_57461();
                                if (book.comp_2421() != 0 || nbt.method_10580("profitInventory").method_10711() == 11) {
                                    this.stack.method_57379(class_9334.field_49606, (Object)new class_9302(book.comp_2419(), book.comp_2420(), 0, book.comp_2422(), book.comp_2423()));
                                    this.profitInventory = new ProfitInventory(this, 54);
                                    this.stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentNbt -> currentNbt.method_10582("profitInventory", this.profitInventory.encode())));
                                } else if (data.method_57450("profitInventory")) {
                                    String string = (String)nbt.method_10558("profitInventory").get();
                                    try {
                                        JsonElement element = JsonParser.parseString((String)string);
                                        DataResult result = class_9288.field_49335.parse((DynamicOps)world.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)element);
                                        if (result.isSuccess()) {
                                            this.profitInventory = new ProfitInventory(this, 54, ((class_9288)result.getOrThrow()).method_57489().toList());
                                            break block24;
                                        }
                                        this.profitInventory = new ProfitInventory(this, 54);
                                    }
                                    catch (Exception e) {
                                        this.profitInventory = new ProfitInventory(this, 54);
                                    }
                                }
                            }
                        } else {
                            this.profitInventory = new ProfitInventory(this, 54);
                            this.stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentNbt -> currentNbt.method_10582("profitInventory", this.profitInventory.encode())));
                        }
                    }
                }
            }
        }
    }

    public boolean isStock(TradeItem product) {
        int total = 0;
        for (int i = 0; i < this.chestInventory.method_5439(); ++i) {
            class_1799 stack = this.chestInventory.method_5438(i);
            if (!TradeInventory.ItemsEqual(stack, product)) continue;
            total += stack.method_7947();
        }
        return product.getStack().method_7947() <= total;
    }

    public void setScreen(SimpleGui screen) {
        this.screen = screen;
    }

    public Optional<SimpleGui> getScreen() {
        if (this.screen != null) {
            return Optional.of(this.screen);
        }
        return Optional.empty();
    }

    public Optional<CheckChest> checkSame(class_2338 pos, class_1937 world) {
        if (pos.equals((Object)this.position) && world.equals(this.world)) {
            return Optional.of(this);
        }
        return Optional.empty();
    }

    public void saveTrade(boolean[] isItem, class_1799[] stacks) {
        ArrayList<class_9262> newPages = new ArrayList<class_9262>();
        class_9302 book = (class_9302)this.stack.method_58694(class_9334.field_49606);
        int i = 0;
        for (class_1799 transactionStack : stacks) {
            if (transactionStack == null || transactionStack.method_7960()) {
                if (book != null && book.comp_2422().size() > i) {
                    newPages.add((class_9262)book.comp_2422().get(i));
                } else {
                    newPages.add(class_9262.method_57137((Object)class_2561.method_43473()));
                }
            } else {
                TradeItem saveItemCodec = new TradeItem(isItem[i], transactionStack);
                DataResult result = TradeItem.CODEC.encodeStart((DynamicOps)this.world.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)saveItemCodec);
                JsonElement jsonElement = (JsonElement)result.getOrThrow();
                String json = jsonElement.toString();
                newPages.add(class_9262.method_57137((Object)class_2561.method_30163((String)json)));
            }
            ++i;
        }
        ChestProtection.LOGGER.info(((Object)newPages).toString());
        class_9302 book1 = new class_9302(book.comp_2419(), book.comp_2420(), book.comp_2421(), newPages, book.comp_2423());
        this.stack.method_57379(class_9334.field_49606, (Object)book1);
    }

    public void writeProfitInventory() {
        this.stack.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, comp -> comp.method_57451(currentNbt -> currentNbt.method_10582("profitInventory", this.profitInventory.encode())));
    }

    public static enum status {
        CLEAR,
        ERROR,
        SELL,
        LOCK;

    }
}

