/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.client.GlobeRenderData;
import net.mehvahdjukaar.supplementaries.common.misc.globe.GlobeData;
import net.mehvahdjukaar.supplementaries.common.utils.Credits;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1043;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobeManager {
    private static final Map<String, TextureInstance> TEXTURE_CACHE = Maps.newHashMap();
    private static final HashMap<class_2960, IntList> DIMENSION_COLORS = new HashMap();
    private static final IntList SEPIA_COLORS = new IntArrayList();
    private static final Map<String, GlobeRenderData> NAME_CACHE = new HashMap<String, GlobeRenderData>();
    private static final Map<String, Float> MODEL_ID_MAP = new HashMap<String, Float>();
    public static final List<class_2960> TEXTURES = new ArrayList<class_2960>();
    public static final GlobeRenderData DEFAULT_DATA = new GlobeRenderData(){

        @Override
        public Model getModel(boolean sepia) {
            return Model.GLOBE;
        }

        @Override
        @NotNull
        public class_2960 getTexture(boolean sepia) {
            if (!ClientConfigs.Blocks.GLOBE_RANDOM.get().booleanValue()) {
                return SpecialGlobe.EARTH.getTexture(sepia);
            }
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return ModTextures.GLOBE_EARTH_TEXTURE;
            }
            return GlobeManager.getTextureInstance((class_1937)level, (boolean)sepia).textureLocation;
        }
    };

    public static void refreshTextures() {
        TEXTURE_CACHE.clear();
    }

    private static TextureInstance getTextureInstance(class_1937 world, boolean sepia) {
        return TEXTURE_CACHE.computeIfAbsent(GlobeManager.getTextureIdPerDimension(world, sepia), i -> new TextureInstance(world, sepia));
    }

    private static String getTextureIdPerDimension(class_1937 level, boolean sepia) {
        Object id = level.method_27983().method_29177().method_12832();
        if (sepia) {
            id = (String)id + "_sepia";
        }
        return id;
    }

    public static GlobeRenderData computeRenderData(boolean sheared, @Nullable class_2561 customName) {
        GlobeRenderData specialGlobe;
        if (sheared) {
            return SpecialGlobe.SHEARED;
        }
        if (customName != null && (specialGlobe = NAME_CACHE.get(customName.getString().toLowerCase(Locale.ROOT))) != null) {
            return specialGlobe;
        }
        return DEFAULT_DATA;
    }

    public static Float getNamedGlobeTextureID(String text) {
        return Float.valueOf(Float.NEGATIVE_INFINITY);
    }

    public static void refreshColorsAndTextures(class_3300 manager) {
        DIMENSION_COLORS.clear();
        int targetColors = 13;
        for (class_2960 res : manager.method_14488("textures/entity/globes/palettes", r -> r.method_12832().endsWith(".png")).keySet()) {
            List l = SpriteUtils.parsePaletteStrip((class_3300)manager, (class_2960)res, (int)targetColors);
            String name = res.method_12832();
            if ((name = name.substring(name.lastIndexOf("/") + 1).replace(".png", "")).equals("sepia")) {
                SEPIA_COLORS.clear();
                SEPIA_COLORS.addAll((Collection)l);
                continue;
            }
            DIMENSION_COLORS.put(class_2960.method_12829((String)name.replace(".", ":")), (IntList)new IntArrayList((Collection)l));
        }
        if (DIMENSION_COLORS.isEmpty()) {
            Supplementaries.LOGGER.error("Could not find any globe palette in textures/entity/globes/palettes");
        }
        if (SEPIA_COLORS.isEmpty()) {
            throw new RuntimeException("Could not find sepia globe palette in textures/entity/globes/palettes");
        }
        GlobeManager.recomputeCache();
        GlobeManager.refreshTextures();
    }

    private static void recomputeCache() {
        NAME_CACHE.clear();
        for (SpecialGlobe type : SpecialGlobe.values()) {
            if (type.keyWords.length == 0) continue;
            if (type.transKeyWord != null && !type.transKeyWord.getString().isEmpty()) {
                NAME_CACHE.put(type.transKeyWord.getString().toLowerCase(Locale.ROOT), type);
            }
            for (String s : type.keyWords) {
                if (s.isEmpty()) continue;
                NAME_CACHE.put(s, type);
            }
        }
        for (Map.Entry entry : Credits.INSTANCE.globes().entrySet()) {
            class_2960 path = (class_2960)entry.getValue();
            Model model = Model.GLOBE;
            if (path.method_12832().contains("globe_wais")) {
                model = Model.SNOW;
            }
            NAME_CACHE.put((String)entry.getKey(), SimpleData.of(model, path));
        }
        TEXTURES.clear();
        HashSet allTextures = new HashSet();
        NAME_CACHE.values().forEach(o -> {
            if (o == DEFAULT_DATA || o == SpecialGlobe.ROUND) {
                return;
            }
            class_2960 t1 = o.getTexture(false);
            allTextures.add(t1);
            class_2960 t2 = o.getTexture(true);
            if (t1 != t2) {
                allTextures.add(t2);
            }
        });
        TEXTURES.addAll(allTextures);
    }

    private static class TextureInstance
    implements AutoCloseable {
        private final class_2960 textureLocation;
        private final class_1043 texture;
        private final class_2960 dimensionId;
        private final boolean sepiaColored;

        private TextureInstance(class_1937 world, boolean sepia) {
            this.sepiaColored = sepia;
            this.dimensionId = world.method_27983().method_29177();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture = new class_1043(32, 16, false);
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
            this.updateTexture(world);
            this.textureLocation = class_310.method_1551().method_1531().method_4617("globe/" + this.dimensionId.toString().replace(":", "_"), this.texture);
        }

        private void updateTexture(class_1937 world) {
            GlobeData data = (GlobeData)ModRegistry.GLOBE_DATA.getData(world);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 32; ++j) {
                    this.texture.method_4525().method_4305(j, i, -13061505);
                }
            }
            int width = data.getTextureWidth();
            int height = data.getTextureHeight();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.texture.method_4525().method_4305(x, y, TextureInstance.getRGBA(data.getPixel(x, y), this.dimensionId, this.sepiaColored));
                }
            }
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)true);
            this.texture.method_4524();
            RenderUtil.setDynamicTexturesToUseMipmap((boolean)false);
        }

        @Override
        public void close() {
            this.texture.close();
            class_310.method_1551().method_1531().method_4615(this.textureLocation);
        }

        private static int getRGBA(byte b, class_2960 dimension, boolean sepia) {
            if (sepia) {
                return SEPIA_COLORS.getInt((int)b);
            }
            IntList l = DIMENSION_COLORS.getOrDefault(dimension, DIMENSION_COLORS.get(class_2960.method_60656((String)"overworld")));
            if (l != null) {
                return l.getInt((int)b);
            }
            return 1;
        }
    }

    private static enum SpecialGlobe implements GlobeRenderData
    {
        FLAT((class_2561)class_2561.method_43471((String)"globe.supplementaries.flat"), ModTextures.GLOBE_FLAT_TEXTURE, ModTextures.GLOBE_FLAT_TEXTURE_SEPIA, Model.FLAT, "flat", "flat earth"),
        MOON((class_2561)class_2561.method_43471((String)"globe.supplementaries.moon"), ModTextures.GLOBE_MOON_TEXTURE, ModTextures.GLOBE_MOON_TEXTURE, "moon", "luna", "selene", "cynthia"),
        EARTH((class_2561)class_2561.method_43471((String)"globe.supplementaries.earth"), ModTextures.GLOBE_EARTH_TEXTURE, ModTextures.GLOBE_EARTH_TEXTURE_SEPIA, "earth", "terra", "gaia", "gaea", "tierra", "tellus", "terre"),
        SUN((class_2561)class_2561.method_43471((String)"globe.supplementaries.sun"), ModTextures.GLOBE_SUN_TEXTURE, ModTextures.GLOBE_SUN_TEXTURE, "sun", "sol", "helios"),
        SHEARED((class_2561)class_2561.method_43470((String)"sheared"), ModTextures.GLOBE_SHEARED_TEXTURE, ModTextures.GLOBE_SHEARED_SEPIA_TEXTURE, Model.SHEARED, new String[0]),
        ROUND((class_2561)class_2561.method_43471((String)"globe.supplementaries.round"), ModTextures.GLOBE_EARTH_TEXTURE, ModTextures.GLOBE_EARTH_TEXTURE_SEPIA, Model.ROUND, "round", "sphere", "spherical");

        private final String[] keyWords;
        private final class_2561 transKeyWord;
        private final class_2960 texture;
        private final class_2960 textureSepia;
        private final Model model;

        private SpecialGlobe(class_2561 tr, class_2960 texture, class_2960 textureSepia, String ... key) {
            this(tr, texture, textureSepia, Model.GLOBE, key);
        }

        private SpecialGlobe(class_2561 tr, class_2960 texture, class_2960 textureSepia, Model model, String ... keywords) {
            this.keyWords = keywords;
            this.transKeyWord = tr;
            this.texture = texture;
            this.textureSepia = textureSepia;
            this.model = model;
        }

        @Override
        @NotNull
        public class_2960 getTexture(boolean sepia) {
            if (this == ROUND) {
                return DEFAULT_DATA.getTexture(sepia);
            }
            return sepia ? this.textureSepia : this.texture;
        }

        @Override
        public Model getModel(boolean sepia) {
            return this.model;
        }
    }

    public static enum Model {
        GLOBE,
        FLAT,
        SNOW,
        SHEARED,
        ROUND;

    }

    private record SimpleData(Model model, @NotNull class_2960 texture) implements GlobeRenderData
    {
        public static SimpleData of(Model model, @NotNull class_2960 texture) {
            return new SimpleData(model, texture);
        }

        @Override
        public Model getModel(boolean sepia) {
            return this.model;
        }

        @Override
        @NotNull
        public class_2960 getTexture(boolean sepia) {
            return this.texture;
        }
    }
}

