/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities.data;

import com.mojang.serialization.Codec;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.class_1309;
import net.minecraft.class_3532;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class SlimedData {
    public static final Codec<SlimedData> CODEC = Codec.INT.xmap(SlimedData::new, d -> d.slimedTicks);
    public static final class_9139<class_9129, SlimedData> STREAM_CODEC = class_9135.field_48550.method_56432(SlimedData::new, d -> d.slimedTicks);
    private int slimedTicks;

    public SlimedData(int slimedTicks) {
        this.slimedTicks = slimedTicks;
    }

    public SlimedData() {
        this(0);
    }

    public void tick(class_1309 entity) {
        if (this.slimedTicks > 0) {
            if (entity.method_5869()) {
                this.slimedTicks = 0;
                ModRegistry.SLIMED_DATA.sync((Object)entity);
            } else {
                --this.slimedTicks;
            }
        }
    }

    public void setSlimedTicks(class_1309 entity, int newSlimedTicks) {
        int old = this.slimedTicks;
        this.slimedTicks = newSlimedTicks;
        if (!entity.method_37908().field_9236) {
            ModRegistry.SLIMED_DATA.sync((Object)entity);
            if (newSlimedTicks > old) {
                entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), ModSounds.SLIME_SPLAT.get(), entity.method_5634(), 1.0f, 1.0f);
            }
        }
    }

    public void clear(class_1309 entity) {
        this.setSlimedTicks(entity, 0);
    }

    public boolean isSlimed() {
        return this.slimedTicks > 0;
    }

    public int getSlimedTicks() {
        return this.slimedTicks;
    }

    public static float getAlpha(class_1309 le, float partialTicks) {
        if (!ClientConfigs.Tweaks.SLIME_OVERLAY.get().booleanValue()) {
            return 0.0f;
        }
        SlimedData data = (SlimedData)ModRegistry.SLIMED_DATA.getOrCreate((Object)le);
        float slimeTicks = (float)data.slimedTicks - partialTicks;
        float maxFade = 70.0f;
        return slimeTicks > maxFade ? 1.0f : class_3532.method_15363((float)(slimeTicks / maxFade), (float)0.0f, (float)1.0f);
    }
}

