/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.UUID;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.supplementaries.common.misc.mob_container.MobContainer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MobContainerView
implements class_9299 {
    public static final Codec<MobContainerView> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobContainer.MobData.CODEC.forGetter(v -> v.inner.getData()), (App)Codec.FLOAT.fieldOf("width").forGetter(v -> Float.valueOf(v.inner.getWidth())), (App)Codec.FLOAT.fieldOf("height").forGetter(v -> Float.valueOf(v.inner.getHeight())), (App)Codec.BOOL.fieldOf("aquarium").forGetter(v -> v.inner.isAquarium())).apply((Applicative)instance, MobContainerView::new));
    public static final class_9139<class_9129, MobContainerView> STREAM_CODEC = class_9139.method_56905(MobContainer.MobData.STREAM_CODEC, v -> v.inner.getData(), (class_9139)class_9135.field_48552, v -> Float.valueOf(v.inner.getWidth()), (class_9139)class_9135.field_48552, v -> Float.valueOf(v.inner.getHeight()), (class_9139)class_9135.field_48547, v -> v.inner.isAquarium(), MobContainerView::new);
    private final MobContainer inner;

    private MobContainerView(@NotNull MobContainer.MobData data, float width, float height, boolean aquarium) {
        this.inner = new MobContainer(width, height, aquarium);
        this.inner.setData((MobContainer.MobData)Preconditions.checkNotNull((Object)data, (Object)"cannot create mob container view with null data"));
    }

    private MobContainerView(MobContainer container) {
        this.inner = container.makeCopy();
    }

    @Nullable
    public MobContainerView copyWithNewUUID(UUID newUUID) {
        MobContainer.MobData mobData = this.inner.getData();
        if (mobData instanceof MobContainer.MobData.Entity) {
            MobContainer.MobData.Entity e = (MobContainer.MobData.Entity)mobData;
            return new MobContainerView(e.copyWithNewUUID(newUUID), this.inner.getWidth(), this.inner.getHeight(), this.inner.isAquarium());
        }
        return null;
    }

    public static MobContainerView of(MobContainer container) {
        Preconditions.checkNotNull((Object)container.getData(), (Object)"cannot create mob container view with null container");
        return new MobContainerView(container.makeCopy());
    }

    public int getFishTexture() {
        return this.inner.getData().getFishTexture();
    }

    public class_6880<SoftFluid> getVisualFluid() {
        return this.inner.getData().getVisualFluid();
    }

    public void apply(MobContainer mobContainer) {
        mobContainer.setData(this.inner.getData());
    }

    public class_1297 getVisualEntity(class_1937 level) {
        return this.inner.getDisplayedMob(level, null);
    }

    public float getRenderScale() {
        return ((MobContainer.MobData.Entity)this.inner.getData()).getScale();
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        String name = this.inner.getData().getName();
        if (name != null) {
            tooltipAdder.accept((class_2561)class_2561.method_43471((String)name).method_27692(class_124.field_1080));
        }
    }

    public MobContainer.MobData getDataUnsafe() {
        return this.inner.getData();
    }

    public boolean equals(Object obj) {
        if (obj instanceof MobContainerView) {
            MobContainerView other = (MobContainerView)obj;
            return this.inner.getData().equals(other.inner.getData());
        }
        return false;
    }

    public int hashCode() {
        return this.inner.getData().hashCode();
    }
}

