/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import org.jetbrains.annotations.Nullable;

public final class PresentAddress
implements class_9299 {
    private static final class_2561 PUBLIC = class_2561.method_43471((String)"message.supplementaries.present.public").method_27692(class_124.field_1080);
    public static final Codec<PresentAddress> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("recipient").forGetter(PresentAddress::recipient), (App)Codec.STRING.fieldOf("sender").forGetter(PresentAddress::sender), (App)Codec.STRING.fieldOf("description").forGetter(PresentAddress::description)).apply((Applicative)instance, PresentAddress::new));
    public static final class_9139<class_9129, PresentAddress> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_48554, PresentAddress::recipient, (class_9139)class_9135.field_48554, PresentAddress::sender, (class_9139)class_9135.field_48554, PresentAddress::description, PresentAddress::new);
    private final String recipient;
    private final String sender;
    private final String description;
    @Nullable
    private final class_2561 recipientComp;
    @Nullable
    private final class_2561 senderComp;

    private PresentAddress(String recipient, String sender, String description) {
        this.recipient = recipient;
        this.sender = sender;
        this.description = description;
        this.recipientComp = PresentAddress.getRecipientMessage(recipient);
        this.senderComp = PresentAddress.getSenderMessage(sender);
    }

    @Nullable
    public static PresentAddress of(String recipient, String sender, String description) {
        if (recipient.isEmpty() && sender.isEmpty()) {
            return null;
        }
        return new PresentAddress(recipient, sender, description);
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltipAdder, class_1836 tooltipFlag) {
        boolean isPacked = false;
        if (this.senderComp != null) {
            tooltipAdder.accept(this.senderComp);
            isPacked = true;
        }
        if (this.recipientComp != null) {
            tooltipAdder.accept(this.recipientComp);
            isPacked = true;
        }
        if (!isPacked) {
            tooltipAdder.accept(PUBLIC);
        }
    }

    @Nullable
    private static class_5250 getSenderMessage(String sender) {
        if (sender.isEmpty()) {
            return null;
        }
        return class_2561.method_43469((String)"message.supplementaries.present.from", (Object[])new Object[]{sender}).method_27692(class_124.field_1080);
    }

    @Nullable
    private static class_5250 getRecipientMessage(String recipient) {
        if (recipient.isEmpty()) {
            return null;
        }
        if (recipient.equalsIgnoreCase("@e")) {
            return class_2561.method_43471((String)"message.supplementaries.present.public").method_27692(class_124.field_1080);
        }
        return class_2561.method_43469((String)"message.supplementaries.present.to", (Object[])new Object[]{recipient}).method_27692(class_124.field_1080);
    }

    @Nullable
    public String recipient() {
        return this.recipient;
    }

    @Nullable
    public String sender() {
        return this.sender;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    public boolean isPublic() {
        return this.recipient.equalsIgnoreCase("@e");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PresentAddress)) {
            return false;
        }
        PresentAddress that = (PresentAddress)o;
        return Objects.equals(this.recipient, that.recipient) && Objects.equals(this.sender, that.sender) && Objects.equals(this.description, that.description) && Objects.equals(this.recipientComp, that.recipientComp) && Objects.equals(this.senderComp, that.senderComp);
    }

    public int hashCode() {
        return Objects.hash(this.recipient, this.sender, this.description, this.recipientComp, this.senderComp);
    }
}

